/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_22;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import ru.casperix.RGBAMapFeature;
import ru.casperix.RenderFactory;
import ru.casperix.map_improvements.MinecraftExtension;
import ru.casperix.map_improvements.config.ModConfig;
import ru.casperix.map_improvements.config.ModConfigProvider;
import ru.casperix.map_improvements.types.ABGRColor;
import ru.casperix.map_improvements.types.MapDTO;
import ru.casperix.map_improvements.types.MapEntryDTO;
import ru.casperix.map_improvements.types.MapLayerDTO;
import ru.casperix.map_improvements.types.MathExtKt;
import ru.casperix.map_improvements.types.TypeExtensionsKt;
import ru.casperix.math.angle.float32.DegreeFloat;
import ru.casperix.math.axis_aligned.float32.Box2f;
import ru.casperix.math.axis_aligned.int32.Box2i;
import ru.casperix.math.geometry.Quad;
import ru.casperix.math.quaternion.float32.QuaternionFloat;
import ru.casperix.math.vector.VectorExtensionKt;
import ru.casperix.math.vector.float32.Vector2f;
import ru.casperix.math.vector.float32.Vector3f;
import ru.casperix.math.vector.int32.Vector2i;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001@B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0011\u001a\b\u0018\u00010\u0010R\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u001f\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0019\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010%\u001a\u00020\r2\u0006\u0010$\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010(\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\b2\u0006\u0010'\u001a\u00020#H\u0002\u00a2\u0006\u0004\b(\u0010)J\u0013\u0010+\u001a\u00020\r*\u00020*H\u0002\u00a2\u0006\u0004\b+\u0010,J\u001b\u0010-\u001a\u00020\r*\u00020*2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b-\u0010.J\u001b\u00100\u001a\u00020\r*\u00020*2\u0006\u0010/\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b0\u00101J\u001f\u00105\u001a\u0002042\u0006\u00103\u001a\u0002022\u0006\u0010/\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b5\u00106R\u0014\u00108\u001a\u0002078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0014\u0010:\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010;R \u0010>\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00150=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?\u00a8\u0006A"}, d2={"Lru/casperix/CustomMapRenderer;", "", "<init>", "()V", "Lnet/minecraft/class_4587;", "matrices", "Lnet/minecraft/class_4597;", "vertexConsumers", "", "mapId", "Lnet/minecraft/class_22;", "mapState", "light", "", "render", "(Lnet/minecraft/class_4587;Lnet/minecraft/class_4597;ILnet/minecraft/class_22;I)V", "Lnet/minecraft/class_22$class_23;", "getHoldingPlayer", "(Lnet/minecraft/class_22;)Lnet/minecraft/class_22$class_23;", "Lru/casperix/map_improvements/types/MapEntryDTO;", "mapEntry", "Lru/casperix/CustomMapRenderer$MapRenderEntry;", "resolvedMapTexture", "(Lru/casperix/map_improvements/types/MapEntryDTO;)Lru/casperix/CustomMapRenderer$MapRenderEntry;", "createMapTexture", "Lnet/minecraft/class_2960;", "textureId", "Lru/casperix/map_improvements/types/MapLayerDTO;", "section", "", "updateMapTexture", "(Lnet/minecraft/class_2960;Lru/casperix/map_improvements/types/MapLayerDTO;)Z", "Lnet/minecraft/class_1043;", "getTexture", "(Lnet/minecraft/class_2960;)Lnet/minecraft/class_1043;", "Lnet/minecraft/class_1011;", "target", "drawMapSection", "(Lnet/minecraft/class_1011;Lru/casperix/map_improvements/types/MapLayerDTO;)V", "image", "uploadTexture", "(ILnet/minecraft/class_1011;)Lnet/minecraft/class_2960;", "Lru/casperix/RenderFactory;", "renderBackground", "(Lru/casperix/RenderFactory;)V", "renderBody", "(Lru/casperix/RenderFactory;Lru/casperix/map_improvements/types/MapEntryDTO;)V", "mapData", "renderPlayerMarker", "(Lru/casperix/RenderFactory;Lnet/minecraft/class_22;)V", "Lru/casperix/math/vector/float32/Vector3f;", "worldPos", "Lru/casperix/math/vector/float32/Vector2f;", "worldToMapCoordinates", "(Lru/casperix/math/vector/float32/Vector3f;Lnet/minecraft/class_22;)Lru/casperix/math/vector/float32/Vector2f;", "Lru/casperix/map_improvements/config/ModConfig;", "config", "Lru/casperix/map_improvements/config/ModConfig;", "ARROW_TEXTURE", "Lnet/minecraft/class_2960;", "BACKGROUND_TEXTURE", "", "mapTextureCache", "Ljava/util/Map;", "MapRenderEntry", "map_improvements-mc1.19.4_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nCustomMapRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomMapRenderer.kt\nru/casperix/CustomMapRenderer\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,159:1\n32#2,2:160\n*S KotlinDebug\n*F\n+ 1 CustomMapRenderer.kt\nru/casperix/CustomMapRenderer\n*L\n100#1:160,2\n*E\n"})
public final class CustomMapRenderer {
    @NotNull
    public static final CustomMapRenderer INSTANCE = new CustomMapRenderer();
    @NotNull
    private static final ModConfig config = ModConfigProvider.INSTANCE.getConfig();
    @NotNull
    private static final class_2960 ARROW_TEXTURE = MinecraftExtension.INSTANCE.createIdentifier("map_improvements", "textures/arrow.png");
    @NotNull
    private static final class_2960 BACKGROUND_TEXTURE = MinecraftExtension.INSTANCE.createIdentifier("map_improvements", "textures/background.png");
    @NotNull
    private static final Map<Integer, MapRenderEntry> mapTextureCache = new LinkedHashMap();

    private CustomMapRenderer() {
    }

    public final void render(@NotNull class_4587 matrices, @NotNull class_4597 vertexConsumers, int mapId, @NotNull class_22 mapState, int light) {
        RenderFactory renderFactory;
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        Intrinsics.checkNotNullParameter((Object)mapState, (String)"mapState");
        RGBAMapFeature rgbaMapFeature = (RGBAMapFeature)mapState;
        long l = rgbaMapFeature.mi_getModifyCounter();
        MapDTO mapDTO = rgbaMapFeature.mi_getMapDto();
        Intrinsics.checkNotNullExpressionValue((Object)mapDTO, (String)"mi_getMapDto(...)");
        MapEntryDTO mapEntry = new MapEntryDTO(mapId, l, mapDTO);
        RenderFactory $this$render_u24lambda_u240 = renderFactory = new RenderFactory(matrices, vertexConsumers, light);
        boolean bl = false;
        INSTANCE.renderBackground($this$render_u24lambda_u240);
        INSTANCE.renderBody($this$render_u24lambda_u240, mapEntry);
        INSTANCE.renderPlayerMarker($this$render_u24lambda_u240, mapState);
    }

    private final class_22.class_23 getHoldingPlayer(class_22 mapState) {
        class_310 minecraft = class_310.method_1551();
        class_746 class_7462 = minecraft.field_1724;
        if (class_7462 == null) {
            return null;
        }
        class_746 localPlayer = class_7462;
        return mapState.method_101((class_1657)localPlayer);
    }

    private final MapRenderEntry resolvedMapTexture(MapEntryDTO mapEntry) {
        MapRenderEntry current;
        block1: {
            block0: {
                current = mapTextureCache.get(mapEntry.getId());
                if (current != null) break block0;
                current = this.createMapTexture(mapEntry);
                mapTextureCache.put(mapEntry.getId(), current);
                break block1;
            }
            if (current.getModifyCounter() == mapEntry.getModifyCounter()) break block1;
            this.updateMapTexture(current.getTextureId(), mapEntry.getMap().getPrimaryLayer());
            mapTextureCache.put(mapEntry.getId(), MapRenderEntry.copy$default(current, 0, mapEntry.getModifyCounter(), null, 5, null));
        }
        return current;
    }

    private final MapRenderEntry createMapTexture(MapEntryDTO mapEntry) {
        MapDTO map = mapEntry.getMap();
        class_1011 image = new class_1011(class_1011.class_1012.field_4997, map.getSize().getX().intValue(), map.getSize().getY().intValue(), false);
        this.drawMapSection(image, map.getPrimaryLayer());
        class_2960 textureId = this.uploadTexture(mapEntry.getId(), image);
        return new MapRenderEntry(mapEntry.getId(), mapEntry.getModifyCounter(), textureId);
    }

    private final boolean updateMapTexture(class_2960 textureId, MapLayerDTO section) {
        class_1043 class_10432 = this.getTexture(textureId);
        if (class_10432 == null) {
            return false;
        }
        class_1043 texture = class_10432;
        class_1011 class_10112 = texture.method_4525();
        if (class_10112 == null) {
            return false;
        }
        class_1011 image = class_10112;
        this.drawMapSection(image, section);
        texture.method_4524();
        return true;
    }

    private final class_1043 getTexture(class_2960 textureId) {
        class_1060 textureManager = class_310.method_1551().method_1531();
        class_1044 class_10442 = textureManager.method_4619(textureId);
        class_1043 texture = class_10442 instanceof class_1043 ? (class_1043)class_10442 : null;
        return texture;
    }

    private final void drawMapSection(class_1011 target, MapLayerDTO section) {
        Box2i imageArea = Box2i.Companion.byDimension(Vector2i.Companion.getZERO(), new Vector2i(target.method_4323(), target.method_4307()));
        Box2i box2i = MathExtKt.intersection(imageArea, section.getRegion());
        if (box2i == null) {
            return;
        }
        Box2i updateArea = box2i;
        if (Intrinsics.areEqual((Object)updateArea, (Object)imageArea) && section.getColors().isDirect()) {
            long byteLength = (long)imageArea.getVolume().intValue() * 4L;
            long sourcePtr = MemoryUtil.memAddress((ByteBuffer)section.getColors());
            MemoryUtil.memCopy((long)sourcePtr, (long)target.field_4988, (long)byteLength);
        } else {
            Iterator $this$forEach$iv = updateArea.iterator();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv;
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                Vector2i it = (Vector2i)element$iv;
                boolean bl = false;
                ABGRColor color = section.getColor(it);
                target.method_4305(it.getX().intValue(), it.getY().intValue(), color.getValue());
            }
        }
    }

    private final class_2960 uploadTexture(int mapId, class_1011 image) {
        class_2960 textureId = MinecraftExtension.INSTANCE.createIdentifier("map_improvements", "world_map_" + mapId);
        class_1060 textureManager = class_310.method_1551().method_1531();
        textureManager.method_4616(textureId, (class_1044)new class_1043(image));
        return textureId;
    }

    private final void renderBackground(RenderFactory $this$renderBackground) {
        class_1921.class_4687 class_46872 = $this$renderBackground.createSolid(BACKGROUND_TEXTURE);
        Intrinsics.checkNotNullExpressionValue((Object)class_46872, (String)"createSolid(...)");
        $this$renderBackground.drawQuad((class_1921)class_46872, (Quad<Vector2f>)VectorExtensionKt.toQuad((Box2f)new Box2f(new Vector2f(0.0f), new Vector2f(128.0f))), -0.2f);
    }

    private final void renderBody(RenderFactory $this$renderBody, MapEntryDTO mapEntry) {
        MapRenderEntry renderEntry = this.resolvedMapTexture(mapEntry);
        class_1921.class_4687 class_46872 = $this$renderBody.createTransparent(renderEntry.getTextureId());
        Intrinsics.checkNotNullExpressionValue((Object)class_46872, (String)"createTransparent(...)");
        $this$renderBody.drawQuad((class_1921)class_46872, (Quad<Vector2f>)VectorExtensionKt.toQuad((Box2f)new Box2f(Vector2f.Companion.getZERO(), new Vector2f(128.0f))), -0.4f);
    }

    private final void renderPlayerMarker(RenderFactory $this$renderPlayerMarker, class_22 mapData) {
        class_22.class_23 class_232 = this.getHoldingPlayer(mapData);
        if (class_232 == null) {
            return;
        }
        class_22.class_23 player = class_232;
        float arrowSize = config.getPlayerArrowSize();
        class_243 class_2432 = player.field_125.method_19538();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"getPos(...)");
        Vector3f worldPlayerPos = TypeExtensionsKt.toVector3d(class_2432).toVector3f();
        Vector2f mapPlayerPos = this.worldToMapCoordinates(worldPlayerPos, mapData);
        Box2f mapArea = Box2f.Companion.byDimension(Vector2f.Companion.getZERO(), new Vector2f(128.0f));
        QuaternionFloat playerRotation = QuaternionFloat.Companion.fromAxisAnge(Vector3f.Companion.getZ(), DegreeFloat.toRadian-Phnk6t4((float)DegreeFloat.constructor-impl((float)(player.field_125.method_36454() - 180.0f))));
        if (!mapArea.isInside(mapPlayerPos)) {
            return;
        }
        $this$renderPlayerMarker.getMatrices().method_22903();
        $this$renderPlayerMarker.getMatrices().method_46416(mapPlayerPos.getX().floatValue(), mapPlayerPos.getY().floatValue(), 0.0f);
        $this$renderPlayerMarker.getMatrices().method_22905(arrowSize, arrowSize, 1.0f);
        $this$renderPlayerMarker.getMatrices().method_22907(TypeExtensionsKt.toQuaternionf(playerRotation));
        $this$renderPlayerMarker.getMatrices().method_46416(-0.5f, -0.5f, 0.0f);
        class_1921.class_4687 class_46872 = $this$renderPlayerMarker.createTransparent(ARROW_TEXTURE);
        Intrinsics.checkNotNullExpressionValue((Object)class_46872, (String)"createTransparent(...)");
        $this$renderPlayerMarker.drawQuad((class_1921)class_46872, (Quad<Vector2f>)VectorExtensionKt.toQuad((Box2f)new Box2f(Vector2f.Companion.getZERO(), new Vector2f(1.0f))), -0.6f);
        $this$renderPlayerMarker.getMatrices().method_22909();
    }

    private final Vector2f worldToMapCoordinates(Vector3f worldPos, class_22 mapData) {
        int scale = 1 << mapData.field_119;
        float mapX = (float)64 + (worldPos.getX().floatValue() - (float)mapData.field_116) / (float)scale;
        float mapZ = (float)64 + (worldPos.getZ().floatValue() - (float)mapData.field_115) / (float)scale;
        return new Vector2f(mapX, mapZ);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ.\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\rR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001e\u001a\u0004\b\u001f\u0010\u000f\u00a8\u0006 "}, d2={"Lru/casperix/CustomMapRenderer$MapRenderEntry;", "", "", "mapId", "", "modifyCounter", "Lnet/minecraft/class_2960;", "textureId", "<init>", "(IJLnet/minecraft/class_2960;)V", "component1", "()I", "component2", "()J", "component3", "()Lnet/minecraft/class_2960;", "copy", "(IJLnet/minecraft/class_2960;)Lru/casperix/CustomMapRenderer$MapRenderEntry;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getMapId", "J", "getModifyCounter", "Lnet/minecraft/class_2960;", "getTextureId", "map_improvements-mc1.19.4_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class MapRenderEntry {
        private final int mapId;
        private final long modifyCounter;
        @NotNull
        private final class_2960 textureId;

        public MapRenderEntry(int mapId, long modifyCounter, @NotNull class_2960 textureId) {
            Intrinsics.checkNotNullParameter((Object)textureId, (String)"textureId");
            this.mapId = mapId;
            this.modifyCounter = modifyCounter;
            this.textureId = textureId;
        }

        public final int getMapId() {
            return this.mapId;
        }

        public final long getModifyCounter() {
            return this.modifyCounter;
        }

        @NotNull
        public final class_2960 getTextureId() {
            return this.textureId;
        }

        public final int component1() {
            return this.mapId;
        }

        public final long component2() {
            return this.modifyCounter;
        }

        @NotNull
        public final class_2960 component3() {
            return this.textureId;
        }

        @NotNull
        public final MapRenderEntry copy(int mapId, long modifyCounter, @NotNull class_2960 textureId) {
            Intrinsics.checkNotNullParameter((Object)textureId, (String)"textureId");
            return new MapRenderEntry(mapId, modifyCounter, textureId);
        }

        public static /* synthetic */ MapRenderEntry copy$default(MapRenderEntry mapRenderEntry, int n, long l, class_2960 class_29602, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = mapRenderEntry.mapId;
            }
            if ((n2 & 2) != 0) {
                l = mapRenderEntry.modifyCounter;
            }
            if ((n2 & 4) != 0) {
                class_29602 = mapRenderEntry.textureId;
            }
            return mapRenderEntry.copy(n, l, class_29602);
        }

        @NotNull
        public String toString() {
            return "MapRenderEntry(mapId=" + this.mapId + ", modifyCounter=" + this.modifyCounter + ", textureId=" + this.textureId + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.mapId);
            result = result * 31 + Long.hashCode(this.modifyCounter);
            result = result * 31 + this.textureId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MapRenderEntry)) {
                return false;
            }
            MapRenderEntry mapRenderEntry = (MapRenderEntry)other;
            if (this.mapId != mapRenderEntry.mapId) {
                return false;
            }
            if (this.modifyCounter != mapRenderEntry.modifyCounter) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.textureId, (Object)mapRenderEntry.textureId);
        }
    }
}

