/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.map_improvements.composite;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.class_1922;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import ru.casperix.map_improvements.misc.CachedBlockAccessor;
import ru.casperix.map_improvements.types.TypeExtensionsKt;
import ru.casperix.math.vector.int32.Vector3i;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lru/casperix/map_improvements/composite/VisibilityCalculator;", "", "<init>", "()V", "Lru/casperix/map_improvements/misc/CachedBlockAccessor;", "accessor", "Lru/casperix/math/vector/int32/Vector3i;", "viewPosition", "", "viewRange", "calculateVisibilityRange", "(Lru/casperix/map_improvements/misc/CachedBlockAccessor;Lru/casperix/math/vector/int32/Vector3i;I)I", "map_improvements-mc1.19.4"})
@SourceDebugExtension(value={"SMAP\nVisibilityCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisibilityCalculator.kt\nru/casperix/map_improvements/composite/VisibilityCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1869#2:42\n1869#2,2:43\n1870#2:45\n*S KotlinDebug\n*F\n+ 1 VisibilityCalculator.kt\nru/casperix/map_improvements/composite/VisibilityCalculator\n*L\n19#1:42\n20#1:43,2\n19#1:45\n*E\n"})
public final class VisibilityCalculator {
    @NotNull
    public static final VisibilityCalculator INSTANCE = new VisibilityCalculator();

    private VisibilityCalculator() {
    }

    public final int calculateVisibilityRange(@NotNull CachedBlockAccessor accessor, @NotNull Vector3i viewPosition, int viewRange) {
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        Intrinsics.checkNotNullParameter((Object)viewPosition, (String)"viewPosition");
        int xzRange = 2;
        int maxAbsoluteHeight = accessor.getLevel().method_8597().comp_653();
        Function2 isSolid = (arg_0, arg_1) -> VisibilityCalculator.calculateVisibilityRange$lambda$0(accessor, arg_0, arg_1);
        int solidCounter = 0;
        int totalDirections = (xzRange * 2 + 1) * (xzRange * 2 + 1);
        Iterable $this$forEach$iv = (Iterable)new IntRange(-xzRange, xzRange);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int dx = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)new IntRange(-xzRange, xzRange);
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            block1: while (iterator2.hasNext()) {
                int element$iv2;
                int dz = element$iv2 = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                int y = viewPosition.getY();
                if (y > maxAbsoluteHeight) continue;
                while (true) {
                    Vector3i worldPos;
                    class_2680 state;
                    if ((state = accessor.getBlockState(worldPos = new Vector3i(viewPosition.getX() + dx, y, viewPosition.getZ() + dz))) == null || ((Boolean)isSolid.invoke((Object)state, (Object)worldPos)).booleanValue()) {
                        ++solidCounter;
                        continue block1;
                    }
                    if (y == maxAbsoluteHeight) continue block1;
                    ++y;
                }
            }
        }
        float solidRatio = (float)solidCounter / (float)totalDirections;
        return solidRatio >= 0.7f ? 0 : (solidRatio >= 0.4f ? viewRange / 2 : viewRange);
    }

    private static final boolean calculateVisibilityRange$lambda$0(CachedBlockAccessor $accessor, class_2680 state, Vector3i pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return !state.method_26215() && state.method_26212((class_1922)$accessor.getLevel(), TypeExtensionsKt.toBlockPos(pos));
    }
}

