/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.map_improvements.composite.collector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import org.jetbrains.annotations.NotNull;
import ru.casperix.map_improvements.composite.ColumnBlock;
import ru.casperix.map_improvements.composite.CompositingCategory;
import ru.casperix.map_improvements.composite.MapContext;
import ru.casperix.map_improvements.composite.WorldColumn;
import ru.casperix.map_improvements.composite.collector.ColumnCollector;
import ru.casperix.map_improvements.composite.collector.CompositingCategoryCalculator;
import ru.casperix.map_improvements.config.BlockRenderConfig;
import ru.casperix.map_improvements.misc.BlockAccessor;
import ru.casperix.map_improvements.types.TypeExtensionsKt;
import ru.casperix.math.vector.int32.Vector2i;
import ru.casperix.math.vector.int32.Vector3i;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lru/casperix/map_improvements/composite/collector/SimpleColumnCollector;", "Lru/casperix/map_improvements/composite/collector/ColumnCollector;", "Lru/casperix/map_improvements/misc/BlockAccessor;", "blockAccessor", "Lru/casperix/map_improvements/composite/MapContext;", "mapContext", "Lru/casperix/map_improvements/config/BlockRenderConfig;", "config", "<init>", "(Lru/casperix/map_improvements/misc/BlockAccessor;Lru/casperix/map_improvements/composite/MapContext;Lru/casperix/map_improvements/config/BlockRenderConfig;)V", "", "Lru/casperix/math/vector/int32/Vector2i;", "tiles", "Lru/casperix/map_improvements/composite/WorldColumn;", "create", "(Ljava/util/List;)Ljava/util/List;", "worldPos", "calculateColumnInfo", "(Lru/casperix/math/vector/int32/Vector2i;)Lru/casperix/map_improvements/composite/WorldColumn;", "Lru/casperix/map_improvements/misc/BlockAccessor;", "getBlockAccessor", "()Lru/casperix/map_improvements/misc/BlockAccessor;", "Lru/casperix/map_improvements/composite/MapContext;", "getMapContext", "()Lru/casperix/map_improvements/composite/MapContext;", "Lru/casperix/map_improvements/config/BlockRenderConfig;", "getConfig", "()Lru/casperix/map_improvements/config/BlockRenderConfig;", "map_improvements-mc1.19.4"})
@SourceDebugExtension(value={"SMAP\nSimpleColumnCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleColumnCollector.kt\nru/casperix/map_improvements/composite/collector/SimpleColumnCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1617#2,9:68\n1869#2:77\n1870#2:79\n1626#2:80\n1869#2,2:81\n1#3:78\n*S KotlinDebug\n*F\n+ 1 SimpleColumnCollector.kt\nru/casperix/map_improvements/composite/collector/SimpleColumnCollector\n*L\n21#1:68,9\n21#1:77\n21#1:79\n21#1:80\n40#1:81,2\n21#1:78\n*E\n"})
public final class SimpleColumnCollector
implements ColumnCollector {
    @NotNull
    private final BlockAccessor blockAccessor;
    @NotNull
    private final MapContext mapContext;
    @NotNull
    private final BlockRenderConfig config;

    public SimpleColumnCollector(@NotNull BlockAccessor blockAccessor, @NotNull MapContext mapContext, @NotNull BlockRenderConfig config) {
        Intrinsics.checkNotNullParameter((Object)blockAccessor, (String)"blockAccessor");
        Intrinsics.checkNotNullParameter((Object)mapContext, (String)"mapContext");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.blockAccessor = blockAccessor;
        this.mapContext = mapContext;
        this.config = config;
    }

    @NotNull
    public final BlockAccessor getBlockAccessor() {
        return this.blockAccessor;
    }

    @NotNull
    public final MapContext getMapContext() {
        return this.mapContext;
    }

    @NotNull
    public final BlockRenderConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<WorldColumn> create(@NotNull List<Vector2i> tiles) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(tiles, (String)"tiles");
        Iterable $this$mapNotNull$iv = tiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            WorldColumn it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Vector2i tilePos = (Vector2i)element$iv$iv;
            boolean bl2 = false;
            if (this.calculateColumnInfo(tilePos) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final WorldColumn calculateColumnInfo(Vector2i worldPos) {
        class_2818 chunk = this.blockAccessor.getChunk(TypeExtensionsKt.toChunkPos(worldPos));
        int maxHeight = chunk.method_12005(class_2902.class_2903.field_13202, worldPos.getX().intValue(), worldPos.getY().intValue()) + 1;
        if (maxHeight <= this.mapContext.getLevel().method_31607()) {
            return null;
        }
        ColumnBlock solid = null;
        List transparentList = new ArrayList();
        IntProgression steps = RangesKt.downTo((int)maxHeight, (int)this.mapContext.getLevel().method_31607());
        Iterable $this$forEach$iv = (Iterable)steps;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            class_2680 blockState;
            int element$iv;
            int height = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Vector3i pos = new Vector3i(worldPos.getX().intValue(), height, worldPos.getY().intValue());
            if (this.blockAccessor.getBlockState(pos) == null) continue;
            CompositingCategory compositingCategory = CompositingCategoryCalculator.INSTANCE.getCategory(blockState, this.config);
            switch (WhenMappings.$EnumSwitchMapping$0[compositingCategory.ordinal()]) {
                case 1: {
                    solid = new ColumnBlock(height, blockState);
                    break;
                }
                case 2: {
                    ((Collection)transparentList).add(new ColumnBlock(height, blockState));
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (solid == null) continue;
            Vector2i mapPos = this.mapContext.worldPosToMapPos(worldPos);
            return new WorldColumn(mapPos, worldPos, solid, transparentList);
        }
        if (!((Collection)transparentList).isEmpty()) {
            Vector2i mapPos = this.mapContext.worldPosToMapPos(worldPos);
            ColumnBlock pseudoSolid = (ColumnBlock)CollectionsKt.removeLast((List)transparentList);
            return new WorldColumn(mapPos, worldPos, pseudoSolid, transparentList);
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompositingCategory.values().length];
            try {
                nArray[CompositingCategory.SOLID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompositingCategory.TRANSLUCENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompositingCategory.HIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

