/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.map_improvements.composite.effect;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import ru.casperix.map_improvements.composite.RGBAMapDrawerContext;
import ru.casperix.map_improvements.composite.effect.MapColorEffect;
import ru.casperix.map_improvements.types.ABGRColor;
import ru.casperix.math.vector.int32.Vector2i;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0012\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lru/casperix/map_improvements/composite/effect/MapDistanceEffect;", "Lru/casperix/map_improvements/composite/effect/MapColorEffect;", "Lru/casperix/math/vector/int32/Vector2i;", "viewPosition", "", "fadeStart", "fadeFinish", "<init>", "(Lru/casperix/math/vector/int32/Vector2i;II)V", "Lru/casperix/map_improvements/composite/RGBAMapDrawerContext;", "context", "Lru/casperix/map_improvements/types/ABGRColor;", "source", "calculate", "(Lru/casperix/map_improvements/composite/RGBAMapDrawerContext;Lru/casperix/map_improvements/types/ABGRColor;)Lru/casperix/map_improvements/types/ABGRColor;", "Lru/casperix/math/vector/int32/Vector2i;", "getViewPosition", "()Lru/casperix/math/vector/int32/Vector2i;", "I", "getFadeStart", "()I", "getFadeFinish", "map_improvements-mc1.19.4"})
public final class MapDistanceEffect
implements MapColorEffect {
    @NotNull
    private final Vector2i viewPosition;
    private final int fadeStart;
    private final int fadeFinish;

    public MapDistanceEffect(@NotNull Vector2i viewPosition, int fadeStart, int fadeFinish) {
        Intrinsics.checkNotNullParameter((Object)viewPosition, (String)"viewPosition");
        this.viewPosition = viewPosition;
        this.fadeStart = fadeStart;
        this.fadeFinish = fadeFinish;
    }

    @NotNull
    public final Vector2i getViewPosition() {
        return this.viewPosition;
    }

    public final int getFadeStart() {
        return this.fadeStart;
    }

    public final int getFadeFinish() {
        return this.fadeFinish;
    }

    @Override
    @NotNull
    public ABGRColor calculate(@NotNull RGBAMapDrawerContext context, @NotNull ABGRColor source) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Vector2i position = context.getColumn().getWorldPos();
        int distance = position.distTo(this.viewPosition);
        if (distance <= this.fadeStart) {
            return source;
        }
        float factor = 1.0f - (float)(distance - this.fadeStart) / (float)(this.fadeFinish - this.fadeStart);
        return ABGRColor.Companion.mulAlpha(source, ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(factor), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue());
    }
}

