/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.map_improvements.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.casperix.map_improvements.types.ColorFormat;
import ru.casperix.map_improvements.types.MapLayerDTO;
import ru.casperix.math.vector.int32.Vector2i;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000e\u001a\u0004\b\u0011\u0010\u0010R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lru/casperix/map_improvements/types/MapDTO;", "", "Lru/casperix/math/vector/int32/Vector2i;", "size", "center", "", "scale", "Lru/casperix/map_improvements/types/MapLayerDTO;", "primaryLayer", "<init>", "(Lru/casperix/math/vector/int32/Vector2i;Lru/casperix/math/vector/int32/Vector2i;ILru/casperix/map_improvements/types/MapLayerDTO;)V", "", "validate", "()V", "Lru/casperix/math/vector/int32/Vector2i;", "getSize", "()Lru/casperix/math/vector/int32/Vector2i;", "getCenter", "I", "getScale", "()I", "Lru/casperix/map_improvements/types/MapLayerDTO;", "getPrimaryLayer", "()Lru/casperix/map_improvements/types/MapLayerDTO;", "map_improvements-mc1.19.4"})
public final class MapDTO {
    @NotNull
    private final Vector2i size;
    @NotNull
    private final Vector2i center;
    private final int scale;
    @NotNull
    private final MapLayerDTO primaryLayer;

    public MapDTO(@NotNull Vector2i size, @NotNull Vector2i center, int scale, @NotNull MapLayerDTO primaryLayer) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)primaryLayer, (String)"primaryLayer");
        this.size = size;
        this.center = center;
        this.scale = scale;
        this.primaryLayer = primaryLayer;
    }

    @NotNull
    public final Vector2i getSize() {
        return this.size;
    }

    @NotNull
    public final Vector2i getCenter() {
        return this.center;
    }

    public final int getScale() {
        return this.scale;
    }

    @NotNull
    public final MapLayerDTO getPrimaryLayer() {
        return this.primaryLayer;
    }

    public final void validate() {
        if (!this.size.greaterOrEq(Vector2i.Companion.getZERO())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int n = this.scale;
        if (!(0 <= n ? n < 8 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.primaryLayer.getFormat() == ColorFormat.ABGR)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!Intrinsics.areEqual((Object)this.primaryLayer.getRegion().getMin(), (Object)Vector2i.Companion.getZERO())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.primaryLayer.getRegion().getDimension().volume() * 4 == this.primaryLayer.getColors().limit())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }
}

