/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.block;

import com.theplumteam.block.PopBlockColor;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.client.ClientHelpers;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import com.theplumteam.registry.ModBlockEntities;
import com.theplumteam.registry.ModItems;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;

public class BoxBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);

    public BoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape baseShape = SHAPE;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BoxBlockEntity) {
            BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
            double localOffsetX = boxBlockEntity.getHitboxOffsetX();
            double localOffsetY = boxBlockEntity.getHitboxOffsetY();
            double localOffsetZ = boxBlockEntity.getHitboxOffsetZ();
            double hitboxScaleX = boxBlockEntity.getHitboxScaleX();
            double hitboxScaleY = boxBlockEntity.getHitboxScaleY();
            double hitboxScaleZ = boxBlockEntity.getHitboxScaleZ();
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            VoxelShape scaledShape = baseShape;
            if (hitboxScaleX != 1.0 || hitboxScaleY != 1.0 || hitboxScaleZ != 1.0) {
                double centerX = 8.0;
                double centerY = 7.0;
                double centerZ = 8.0;
                double effectiveScaleX = hitboxScaleX;
                double effectiveScaleZ = hitboxScaleZ;
                if (facing == Direction.EAST || facing == Direction.WEST) {
                    effectiveScaleX = hitboxScaleZ;
                    effectiveScaleZ = hitboxScaleX;
                }
                double minX = centerX + (3.0 - centerX) * effectiveScaleX;
                double minY = 0.0;
                double minZ = centerZ + (3.0 - centerZ) * effectiveScaleZ;
                double maxX = centerX + (13.0 - centerX) * effectiveScaleX;
                double maxY = 14.0 * hitboxScaleY;
                double maxZ = centerZ + (13.0 - centerZ) * effectiveScaleZ;
                scaledShape = Block.m_49796_((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            }
            if (localOffsetX != 0.0 || localOffsetY != 0.0 || localOffsetZ != 0.0) {
                double worldOffsetX = 0.0;
                double worldOffsetZ = 0.0;
                switch (facing) {
                    case NORTH: {
                        worldOffsetX = localOffsetX;
                        worldOffsetZ = -localOffsetZ;
                        break;
                    }
                    case SOUTH: {
                        worldOffsetX = -localOffsetX;
                        worldOffsetZ = localOffsetZ;
                        break;
                    }
                    case EAST: {
                        worldOffsetX = localOffsetZ;
                        worldOffsetZ = localOffsetX;
                        break;
                    }
                    case WEST: {
                        worldOffsetX = -localOffsetZ;
                        worldOffsetZ = -localOffsetX;
                    }
                }
                return scaledShape.m_83216_(worldOffsetX, localOffsetY, worldOffsetZ);
            }
            return scaledShape;
        }
        return baseShape;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BoxBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? BoxBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.BOX_BLOCK.get()), BoxBlockEntity::tick) : null;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_150930_(Items.f_42398_)) {
            BoxBlockEntity boxBlockEntity;
            BlockEntity blockEntity;
            if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof BoxBlockEntity && (boxBlockEntity = (BoxBlockEntity)blockEntity).hasFigure()) {
                boxBlockEntity.cycleAlternativeSkin();
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof BoxBlockEntity)) {
            return InteractionResult.PASS;
        }
        BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
        if (player.m_6144_()) {
            if (boxBlockEntity.isOpen() && !level.f_46443_) {
                boxBlockEntity.toggleOpen();
                return InteractionResult.SUCCESS;
            }
            if (!boxBlockEntity.isOpen() && level.f_46443_ && !FMLLoader.isProduction()) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHelpers.openBoxFigureScreen(pos, boxBlockEntity));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!level.f_46443_) {
            if (boxBlockEntity.isOpen()) {
                if (heldItem.m_41720_() == ModItems.FIGURE_BLOCK_ITEM.get() && boxBlockEntity.isFigureExtracted()) {
                    CompoundTag blockEntityTag = heldItem.m_41737_("BlockEntityTag");
                    if (blockEntityTag != null) {
                        String heldFigureId = blockEntityTag.m_128461_("FigureId");
                        String heldCollectionId = blockEntityTag.m_128461_("CollectionId");
                        if (heldFigureId.equals(boxBlockEntity.getFigureId()) && heldCollectionId.equals(boxBlockEntity.getCollectionId())) {
                            if (blockEntityTag.m_128441_("QuickSkinId")) {
                                boxBlockEntity.setQuickSkinId(blockEntityTag.m_128461_("QuickSkinId"));
                            }
                            if (blockEntityTag.m_128441_("SkinSnapshot")) {
                                boxBlockEntity.setSkinSnapshot(blockEntityTag.m_128461_("SkinSnapshot"));
                            }
                            boxBlockEntity.setFigureExtracted(false);
                            boxBlockEntity.toggleOpen();
                            heldItem.m_41774_(1);
                            level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            return InteractionResult.SUCCESS;
                        }
                    }
                } else if (boxBlockEntity.hasFigure() && !boxBlockEntity.isFigureExtracted()) {
                    ItemStack figureBlockItem = new ItemStack((ItemLike)ModItems.FIGURE_BLOCK_ITEM.get());
                    CompoundTag blockEntityTag = new CompoundTag();
                    blockEntityTag.m_128359_("FigureId", boxBlockEntity.getFigureId());
                    blockEntityTag.m_128359_("CollectionId", boxBlockEntity.getCollectionId());
                    blockEntityTag.m_128405_("AlternativeSkinIndex", boxBlockEntity.getAlternativeSkinIndex());
                    blockEntityTag.m_128347_("FigureOffsetX", boxBlockEntity.getFigureOffsetX());
                    blockEntityTag.m_128347_("FigureOffsetY", boxBlockEntity.getFigureOffsetY());
                    blockEntityTag.m_128347_("FigureOffsetZ", boxBlockEntity.getFigureOffsetZ());
                    blockEntityTag.m_128347_("FigureScale", boxBlockEntity.getFigureScale());
                    FigureDefinition figureDef = boxBlockEntity.getFigureDefinition();
                    if (figureDef != null && figureDef.getType() == FigureType.PLAYER) {
                        String quickSkinId;
                        String snapshot = boxBlockEntity.getSkinSnapshot();
                        if (snapshot != null && !snapshot.isEmpty()) {
                            blockEntityTag.m_128359_("SkinSnapshot", snapshot);
                        }
                        if ((quickSkinId = boxBlockEntity.getQuickSkinId()) != null && !quickSkinId.isEmpty()) {
                            blockEntityTag.m_128359_("QuickSkinId", quickSkinId);
                        }
                    }
                    figureBlockItem.m_41700_("BlockEntityTag", (Tag)blockEntityTag);
                    if (!player.m_150109_().m_36054_(figureBlockItem)) {
                        player.m_36176_(figureBlockItem, false);
                    }
                    boxBlockEntity.setFigureExtracted(true);
                    level.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (heldItem.m_41720_() == Items.f_42574_) {
                    boxBlockEntity.toggleOpen();
                    level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                player.m_5661_((Component)Component.m_237113_((String)"Use Shears to open").m_130940_(ChatFormatting.GRAY), true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction playerFacing = context.m_8125_();
        Direction blockFacing = playerFacing.m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockFacing);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof BoxBlockEntity) {
            BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
            CompoundTag tag = stack.m_41737_("BlockEntityTag");
            if (tag != null) {
                if (tag.m_128441_("QuickSkinId")) {
                    boxBlockEntity.setQuickSkinId(tag.m_128461_("QuickSkinId"));
                }
                if (tag.m_128441_("SkinSnapshot")) {
                    boxBlockEntity.setSkinSnapshot(tag.m_128461_("SkinSnapshot"));
                }
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof BoxBlockEntity) {
            BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
            String collectionId = boxBlockEntity.getCollectionId();
            PopBlockColor color = boxBlockEntity.getColor();
            ItemStack dropStack = color != null ? new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)color).get()) : (collectionId != null && !collectionId.isEmpty() ? new ItemStack((ItemLike)ModItems.BOX_BLOCK_ITEMS.get(collectionId).get()) : new ItemStack((ItemLike)this.m_5456_()));
            boxBlockEntity.m_187476_(dropStack);
            BoxBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)dropStack);
        }
        super.m_5707_(level, pos, state, player);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BoxBlockEntity) {
            BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
            boxBlockEntity.m_187476_(stack);
        }
        return stack;
    }

    private BlockState getWoolBlockState(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BoxBlockEntity) {
            BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity;
            PopBlockColor color = boxBlockEntity.getColor();
            String collectionId = boxBlockEntity.getCollectionId();
            if (color != null) {
                return switch (color) {
                    default -> throw new IncompatibleClassChangeError();
                    case PopBlockColor.ORIGINAL -> Blocks.f_50041_.m_49966_();
                    case PopBlockColor.BLACK -> Blocks.f_50109_.m_49966_();
                    case PopBlockColor.BLUE -> Blocks.f_50105_.m_49966_();
                    case PopBlockColor.BROWN -> Blocks.f_50106_.m_49966_();
                    case PopBlockColor.CYAN -> Blocks.f_50103_.m_49966_();
                    case PopBlockColor.GRAY -> Blocks.f_50101_.m_49966_();
                    case PopBlockColor.GREEN -> Blocks.f_50107_.m_49966_();
                    case PopBlockColor.LIGHT_BLUE -> Blocks.f_50097_.m_49966_();
                    case PopBlockColor.LIGHT_GRAY -> Blocks.f_50102_.m_49966_();
                    case PopBlockColor.LIME -> Blocks.f_50099_.m_49966_();
                    case PopBlockColor.MAGENTA -> Blocks.f_50096_.m_49966_();
                    case PopBlockColor.ORANGE -> Blocks.f_50042_.m_49966_();
                    case PopBlockColor.PINK -> Blocks.f_50100_.m_49966_();
                    case PopBlockColor.PURPLE -> Blocks.f_50104_.m_49966_();
                    case PopBlockColor.RED -> Blocks.f_50108_.m_49966_();
                    case PopBlockColor.YELLOW -> Blocks.f_50098_.m_49966_();
                };
            }
            if (collectionId != null && !collectionId.isEmpty()) {
                return switch (collectionId) {
                    case "adventuretime" -> Blocks.f_50097_.m_49966_();
                    case "fnaf" -> Blocks.f_50109_.m_49966_();
                    case "jojos" -> Blocks.f_50096_.m_49966_();
                    case "jujutsukaisen" -> Blocks.f_50109_.m_49966_();
                    case "onepiece" -> Blocks.f_50105_.m_49966_();
                    case "starwars" -> Blocks.f_50109_.m_49966_();
                    case "supermario" -> Blocks.f_50106_.m_49966_();
                    case "deltarune" -> Blocks.f_50104_.m_49966_();
                    case "world_players" -> Blocks.f_50041_.m_49966_();
                    default -> Blocks.f_50041_.m_49966_();
                };
            }
        }
        return Blocks.f_50041_.m_49966_();
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level.m_5776_()) {
            BlockState woolState = this.getWoolBlockState(level, pos);
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, woolState), entity.m_20185_() + (Math.random() - 0.5) * (double)entity.m_20205_(), entity.m_20186_() + 0.1, entity.m_20189_() + (Math.random() - 0.5) * (double)entity.m_20205_(), (Math.random() - 0.5) * 0.15, 0.05, (Math.random() - 0.5) * 0.15);
        }
        return true;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine particleEngine) {
                BlockState woolState = BoxBlock.this.getWoolBlockState(level, pos);
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        for (int k = 0; k < 4; ++k) {
                            double x = (double)pos.m_123341_() + ((double)i + 0.5) / 4.0;
                            double y = (double)pos.m_123342_() + ((double)j + 0.5) / 4.0;
                            double z = (double)pos.m_123343_() + ((double)k + 0.5) / 4.0;
                            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, woolState), x, y, z, (Math.random() - 0.5) * 0.8, (Math.random() - 0.5) * 0.8, (Math.random() - 0.5) * 0.8);
                        }
                    }
                }
                return true;
            }

            public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine particleEngine) {
                if (!(target instanceof BlockHitResult)) {
                    return false;
                }
                BlockHitResult blockHit = (BlockHitResult)target;
                BlockPos pos = blockHit.m_82425_();
                BlockState woolState = BoxBlock.this.getWoolBlockState(level, pos);
                Direction side = blockHit.m_82434_();
                for (int i = 0; i < 4; ++i) {
                    double x = (double)pos.m_123341_() + 0.5 + (double)side.m_122429_() * 0.5 + (Math.random() - 0.5) * 0.4;
                    double y = (double)pos.m_123342_() + 0.5 + (double)side.m_122430_() * 0.5 + (Math.random() - 0.5) * 0.4;
                    double z = (double)pos.m_123343_() + 0.5 + (double)side.m_122431_() * 0.5 + (Math.random() - 0.5) * 0.4;
                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, woolState), x, y, z, (double)side.m_122429_() * 0.01, (double)side.m_122430_() * 0.01, (double)side.m_122431_() * 0.01);
                }
                return true;
            }
        });
    }
}

