/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.capability;

import com.theplumteam.capability.PlayerDiscoveryProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="blockpops", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapabilityEvents {
    private static final ResourceLocation PLAYER_DISCOVERY_CAP = new ResourceLocation("blockpops", "player_discovery");

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            PlayerDiscoveryProvider provider = new PlayerDiscoveryProvider();
            event.addCapability(PLAYER_DISCOVERY_CAP, (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerDiscoveryProvider.PLAYER_DISCOVERY).ifPresent(oldDiscovery -> event.getEntity().getCapability(PlayerDiscoveryProvider.PLAYER_DISCOVERY).ifPresent(newDiscovery -> newDiscovery.syncFrom(oldDiscovery.getDiscoveredSet())));
        }
    }
}

