/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.discovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientDiscoveryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientDiscoveryManager.class);
    private static final Set<String> discoveredFigures = new HashSet<String>();
    private static final Map<String, String> figureSkins = new HashMap<String, String>();

    public static void setData(Set<String> figures, Map<String, String> skins) {
        discoveredFigures.clear();
        discoveredFigures.addAll(figures);
        figureSkins.clear();
        figureSkins.putAll(skins);
        LOGGER.debug("Discovery data synced: {} figures, {} skins", (Object)discoveredFigures.size(), (Object)figureSkins.size());
    }

    @Deprecated
    public static void setData(Set<String> figures) {
        ClientDiscoveryManager.setData(figures, Collections.emptyMap());
    }

    public static void unlock(String figureId) {
        if (discoveredFigures.add(figureId)) {
            LOGGER.info("Figure unlocked: {}", (Object)figureId);
        }
    }

    public static boolean isDiscovered(String figureId) {
        return discoveredFigures.contains(figureId);
    }

    public static Set<String> getAllDiscovered() {
        return Collections.unmodifiableSet(discoveredFigures);
    }

    public static void clear() {
        discoveredFigures.clear();
        figureSkins.clear();
        LOGGER.debug("Discovery data cleared");
    }

    public static void saveFigureSkin(String figureId, String skinUrl) {
        figureSkins.put(figureId, skinUrl);
    }

    @Nullable
    public static String getFigureSkin(String figureId) {
        return figureSkins.get(figureId);
    }
}

