/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.client.config.ClientConfig;
import com.theplumteam.client.gui.util.GuiScaleManager;
import com.theplumteam.client.gui.widget.ColorSelectionButton;
import com.theplumteam.forge.BlockPopsModForge;
import com.theplumteam.network.SetFavoriteColorPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FavoriteColorSelectionScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger(FavoriteColorSelectionScreen.class);
    @Nullable
    private PopBlockColor selectedColor = null;
    private Button doneButton;
    private final List<ColorSelectionButton> colorButtons = new ArrayList<ColorSelectionButton>();
    private int panelX;
    private int panelY;
    private int panelWidth;
    private int panelHeight;
    private static final int MIN_PANEL_WIDTH = 400;
    private static final int MAX_PANEL_WIDTH = 600;
    private static final int MIN_PANEL_HEIGHT = 450;
    private static final ResourceLocation STAR_PATTERN_TEXTURE = new ResourceLocation("blockpops", "textures/gui/background/star_pattern.png");
    private float rotationX = 342.3f;
    private float rotationY = 335.9f;
    private float rotationZ = 0.0f;
    private float scale = 1.2f;
    private float offsetX = 198.0f;
    private float offsetY = -134.0f;
    private float offsetZ = 0.0f;
    private float containerScale = 1.2f;

    public FavoriteColorSelectionScreen() {
        super((Component)Component.m_237113_((String)"Choose Your Favorite Color"));
        LOGGER.info("FavoriteColorSelectionScreen created");
    }

    protected void m_7856_() {
        if (GuiScaleManager.setMenuGuiScale(GuiScaleManager.getOptimalMenuScale())) {
            return;
        }
        super.m_7856_();
        this.m_169413_();
        this.colorButtons.clear();
        this.calculatePanelDimensions();
        int scaledPadding = 20;
        int scaledSpacing = 10;
        int scaledComponentHeight = 24;
        int titleY = this.panelY + scaledPadding;
        int buttonSize = (int)(60.0f * this.containerScale);
        int gridCols = 4;
        int gridRows = 4;
        int gridWidth = gridCols * buttonSize + (gridCols - 1) * scaledSpacing;
        int gridHeight = gridRows * buttonSize + (gridRows - 1) * scaledSpacing;
        int gridStartX = this.panelX + (this.panelWidth - gridWidth) / 2;
        Objects.requireNonNull(this.f_96547_);
        int descriptionHeight = 9 * 3;
        int gridStartY = titleY + descriptionHeight + scaledPadding;
        PopBlockColor[] colors = PopBlockColor.values();
        for (int i = 0; i < colors.length; ++i) {
            PopBlockColor color = colors[i];
            int row = i / gridCols;
            int col = i % gridCols;
            int x = gridStartX + col * (buttonSize + scaledSpacing);
            int y = gridStartY + row * (buttonSize + scaledSpacing);
            ColorSelectionButton colorButton = new ColorSelectionButton(x, y, buttonSize, color, this);
            this.m_142416_((GuiEventListener)colorButton);
            this.colorButtons.add(colorButton);
        }
        int buttonWidth = 200;
        int doneButtonX = this.panelX + (this.panelWidth - buttonWidth) / 2;
        int doneButtonY = this.panelY + this.panelHeight - scaledPadding - scaledComponentHeight;
        this.doneButton = Button.m_253074_((Component)Component.m_237113_((String)"Done"), button -> {
            if (this.selectedColor != null) {
                LOGGER.info("Player confirmed favorite color choice: {}", (Object)this.selectedColor.m_7912_());
                SetFavoriteColorPacket packet = new SetFavoriteColorPacket(this.selectedColor.m_7912_());
                BlockPopsModForge.NETWORK_CHANNEL.sendToServer((Object)packet);
                this.m_7379_();
            }
        }).m_252987_(doneButtonX, doneButtonY, buttonWidth, scaledComponentHeight).m_253136_();
        this.doneButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.doneButton);
        this.updateButtonTransforms();
    }

    private void updateButtonTransforms() {
        for (ColorSelectionButton button : this.colorButtons) {
            button.setTransforms(this.rotationX, this.rotationY, this.rotationZ, this.scale, this.offsetX, this.offsetY, this.offsetZ);
        }
    }

    private void calculatePanelDimensions() {
        int desiredWidth = (int)((float)this.f_96543_ * 0.5f);
        int desiredHeight = (int)((float)this.f_96544_ * 0.7f);
        this.panelWidth = Mth.m_14045_((int)desiredWidth, (int)400, (int)Math.min(600, this.f_96543_ - 60));
        this.panelHeight = Mth.m_14045_((int)desiredHeight, (int)450, (int)(this.f_96544_ - 60));
        this.panelX = (this.f_96543_ - this.panelWidth) / 2;
        this.panelY = (this.f_96544_ - this.panelHeight) / 2;
    }

    public void setSelectedColor(PopBlockColor color) {
        this.selectedColor = color;
        this.doneButton.f_93623_ = true;
        for (ColorSelectionButton button : this.colorButtons) {
            button.setSelected(button.getColor() == color);
        }
        LOGGER.debug("Selected color: {}", (Object)color.m_7912_());
    }

    public void m_7861_() {
        GuiScaleManager.restoreOriginalGuiScale();
        super.m_7861_();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackgroundEffects(graphics, partialTick);
        this.renderPanel(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.renderTitleAndDescription(graphics);
    }

    private void renderBackgroundEffects(GuiGraphics graphics, float partialTick) {
        int bgColor = -16777216;
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, bgColor);
        this.renderStarPattern(graphics, partialTick);
    }

    private void renderStarPattern(GuiGraphics graphics, float partialTick) {
        int textureSize = 1024;
        int tileSize = 55;
        double pixelsPerSecond = 8.0;
        int tickCount = this.f_96541_ != null ? this.f_96541_.f_91065_.m_93079_() : 0;
        double smoothTime = (double)((float)tickCount + partialTick) / 20.0;
        double offset = smoothTime * pixelsPerSecond % (double)tileSize;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ClientConfig config = ClientConfig.getInstance();
        RenderSystem.setShaderColor((float)config.starColorR, (float)config.starColorG, (float)config.starColorB, (float)config.starOpacity);
        int xTiles = Mth.m_14167_((float)((float)this.f_96543_ / (float)tileSize)) + 2;
        int yTiles = Mth.m_14167_((float)((float)this.f_96544_ / (float)tileSize)) + 1;
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        for (int y = 0; y < yTiles; ++y) {
            for (int x = 0; x < xTiles; ++x) {
                double drawX = (double)(x * tileSize) - offset;
                double drawY = y * tileSize;
                pose.m_85836_();
                pose.m_85837_(drawX, drawY, 0.0);
                pose.m_85841_((float)tileSize / (float)textureSize, (float)tileSize / (float)textureSize, 1.0f);
                graphics.m_280398_(STAR_PATTERN_TEXTURE, 0, 0, 0, 0.0f, 0.0f, textureSize, textureSize, textureSize, textureSize);
                pose.m_85849_();
            }
        }
        pose.m_85849_();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderPanel(GuiGraphics graphics) {
        ClientConfig config = ClientConfig.getInstance();
        int alpha = (int)(config.panelOpacity * 255.0f);
        int panelBgColor = alpha << 24 | 0;
        graphics.m_280509_(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, panelBgColor);
        graphics.m_280509_(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + 1, 0x60FFFFFF);
        graphics.m_280509_(this.panelX, this.panelY + this.panelHeight - 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight, 0x60FFFFFF);
        graphics.m_280509_(this.panelX, this.panelY + 1, this.panelX + 1, this.panelY + this.panelHeight - 1, 0x60FFFFFF);
        graphics.m_280509_(this.panelX + this.panelWidth - 1, this.panelY + 1, this.panelX + this.panelWidth, this.panelY + this.panelHeight - 1, 0x60FFFFFF);
    }

    private void renderTitleAndDescription(GuiGraphics graphics) {
        int scaledPadding = 20;
        int titleY = this.panelY + scaledPadding;
        String title = "Choose Your Favorite Color";
        int titleWidth = this.f_96547_.m_92895_(title);
        int titleX = this.panelX + (this.panelWidth - titleWidth) / 2;
        graphics.m_280056_(this.f_96547_, title, titleX, titleY, 0xFFFFFF, false);
        Objects.requireNonNull(this.f_96547_);
        String desc1 = "This color will be used for your figure box";
        int desc1Width = this.f_96547_.m_92895_(desc1);
        int desc1X = this.panelX + (this.panelWidth - desc1Width) / 2;
        graphics.m_280056_(this.f_96547_, desc1, desc1X, titleY += 9 + 8, 0xAAAAAA, false);
        Objects.requireNonNull(this.f_96547_);
        String desc2 = "in the World Players collection.";
        int desc2Width = this.f_96547_.m_92895_(desc2);
        int desc2X = this.panelX + (this.panelWidth - desc2Width) / 2;
        graphics.m_280056_(this.f_96547_, desc2, desc2X, titleY += 9 + 2, 0xAAAAAA, false);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6913_() {
        return false;
    }
}

