/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.theplumteam.client.discovery.ClientDiscoveryManager;
import com.theplumteam.client.gui.widget.CollectionListWidget;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.FigureDefinition;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class CollectionEntry
extends ObjectSelectionList.Entry<CollectionEntry> {
    private final Minecraft mc;
    private final FigureCollection collection;
    private final CollectionListWidget parent;
    private static final int PADDING = 4;
    private static final int TOP_PADDING = 12;
    private static final int LOGO_MAX_SIZE = 56;
    private static final int LINK_BUTTON_SIZE = 14;
    private int linkButtonX;
    private int linkButtonY;
    private boolean isLinkHovered;

    public CollectionEntry(CollectionListWidget parent, FigureCollection collection) {
        this.parent = parent;
        this.mc = Minecraft.m_91087_();
        this.collection = collection;
    }

    public void m_6311_(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
        boolean isSelected = this.parent.m_93511_() == this;
        int highlightPaddingH = 4;
        int highlightPaddingV = 2;
        int highlightLeft = x - highlightPaddingH;
        int highlightRight = x + entryWidth - 10;
        int highlightTop = y - highlightPaddingV;
        int highlightBottom = y + entryHeight + highlightPaddingV;
        if (isSelected) {
            graphics.m_280509_(highlightLeft, highlightTop, highlightRight, highlightBottom, -2144301888);
            graphics.m_280637_(highlightLeft, highlightTop, highlightRight - highlightLeft, highlightBottom - highlightTop, -12549889);
        } else if (isMouseOver) {
            graphics.m_280509_(highlightLeft, highlightTop, highlightRight, highlightBottom, 0x30FFFFFF);
        }
        int logoContainerX = x + 4;
        int logoContainerWidth = 56;
        ResourceLocation logoTexture = this.collection.getLogoTexture();
        int textStartX = logoContainerX + logoContainerWidth + 4;
        if (logoTexture != null) {
            int logoHeight;
            int logoWidth;
            int maxSize;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)logoTexture);
            int textureId = RenderSystem.getShaderTexture((int)0);
            int[] width = new int[1];
            int[] height = new int[1];
            GL11.glBindTexture((int)3553, (int)textureId);
            GL11.glGetTexLevelParameteriv((int)3553, (int)0, (int)4096, (int[])width);
            GL11.glGetTexLevelParameteriv((int)3553, (int)0, (int)4097, (int[])height);
            int textureWidth = width[0] > 0 ? width[0] : 256;
            int textureHeight = height[0] > 0 ? height[0] : 256;
            float aspectRatio = (float)textureWidth / (float)textureHeight;
            int n = maxSize = "world_players".equals(this.collection.getId()) ? 40 : 56;
            if (aspectRatio > 1.0f) {
                logoWidth = maxSize;
                logoHeight = (int)((float)maxSize / aspectRatio);
            } else {
                logoHeight = maxSize;
                logoWidth = (int)((float)maxSize * aspectRatio);
            }
            int logoX = logoContainerX + (logoContainerWidth - logoWidth) / 2;
            int logoY = y + (entryHeight - logoHeight) / 2;
            graphics.m_280411_(logoTexture, logoX, logoY, logoWidth, logoHeight, 0.0f, 0.0f, textureWidth, textureHeight, textureWidth, textureHeight);
        }
        int textX = textStartX;
        int textY = y + 12;
        int textColor = isSelected ? 0xFFFFFF : 0xE0E0E0;
        graphics.m_280056_(this.mc.f_91062_, this.collection.getName(), textX, textY, textColor, false);
        int totalFigures = this.collection.getFigures().size();
        int discoveredCount = 0;
        for (FigureDefinition figure : this.collection.getFigures()) {
            String figureId = this.collection.getId() + ":" + figure.getId();
            if (!ClientDiscoveryManager.isDiscovered(figureId)) continue;
            ++discoveredCount;
        }
        String figureCount = discoveredCount + "/" + totalFigures + " figures";
        Objects.requireNonNull(this.mc.f_91062_);
        int subTextY = textY + 9 + 2;
        int subTextColor = isSelected ? 0xAAAAAA : 0x808080;
        graphics.m_280056_(this.mc.f_91062_, figureCount, textX, subTextY, subTextColor, false);
        String author = this.collection.getAuthor();
        MutableComponent authorText = "world_players".equals(this.collection.getId()) ? Component.m_237113_((String)"Auto-generated skins").m_130940_(ChatFormatting.GOLD) : (author.equals("Unknown") ? Component.m_237113_((String)"Collection with multiple creators").m_130940_(ChatFormatting.GOLD) : Component.m_237113_((String)"Skin creator: ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)author).m_130940_(ChatFormatting.GOLD)));
        Objects.requireNonNull(this.mc.f_91062_);
        int authorY = subTextY + 9 + 2;
        graphics.m_280614_(this.mc.f_91062_, (Component)authorText, textX, authorY, 0xFFFFFF, false);
        this.isLinkHovered = false;
        if (isMouseOver && this.collection.getAuthorUrl() != null && !this.collection.getAuthorUrl().isEmpty()) {
            int margin = 4;
            this.linkButtonX = highlightRight - 14 - margin;
            this.linkButtonY = highlightTop + margin;
            boolean linkHovered = mouseX >= this.linkButtonX && mouseX < this.linkButtonX + 14 && mouseY >= this.linkButtonY && mouseY < this.linkButtonY + 14;
            graphics.m_280509_(this.linkButtonX, this.linkButtonY, this.linkButtonX + 14, this.linkButtonY + 14, linkHovered ? -4684277 : -1063686144);
            graphics.m_280637_(this.linkButtonX, this.linkButtonY, 14, 14, linkHovered ? -2448096 : -4684277);
            String planetEmoji = "\ud83c\udf10";
            int emojiWidth = this.mc.f_91062_.m_92895_(planetEmoji);
            int emojiX = this.linkButtonX + (14 - emojiWidth) / 2;
            int emojiY = this.linkButtonY + 3;
            graphics.m_280056_(this.mc.f_91062_, planetEmoji, emojiX, emojiY, 0xFFFFFF, false);
            this.isLinkHovered = linkHovered;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isLinkHovered && this.collection.getAuthorUrl() != null && !this.collection.getAuthorUrl().isEmpty()) {
                try {
                    this.mc.f_91080_.m_5561_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, this.collection.getAuthorUrl())));
                }
                catch (Exception e) {
                    System.err.println("Failed to open URL: " + this.collection.getAuthorUrl());
                }
                return true;
            }
            this.parent.m_6987_((AbstractSelectionList.Entry)this);
            this.parent.onCollectionSelected(this);
            return true;
        }
        return false;
    }

    public Component m_142172_() {
        int totalFigures = this.collection.getFigures().size();
        int discoveredCount = 0;
        for (FigureDefinition figure : this.collection.getFigures()) {
            String figureId = this.collection.getId() + ":" + figure.getId();
            if (!ClientDiscoveryManager.isDiscovered(figureId)) continue;
            ++discoveredCount;
        }
        return Component.m_237113_((String)(this.collection.getName() + " - " + discoveredCount + "/" + totalFigures + " figures"));
    }

    public FigureCollection getCollection() {
        return this.collection;
    }
}

