/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui.widget;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.client.discovery.ClientDiscoveryManager;
import com.theplumteam.client.model.FigureModel;
import com.theplumteam.figure.FigureDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class FigureEntry
extends ObjectSelectionList.Entry<FigureEntry> {
    private final Minecraft mc;
    private final List<FigureDefinition> figures;
    private final String collectionId;
    private final FigureModel figureModel;
    private final GeoBlockRenderer<BoxBlockEntity> figureRenderer;
    private final Map<String, BoxBlockEntity> renderEntityCache = new HashMap<String, BoxBlockEntity>();
    private float modelScale = 1.0f;
    private float xRotation = 0.0f;
    private float yRotation = 70.0f;
    private float zRotation = 0.0f;
    private float xOffset = -60.0f;
    private float yOffset = 15.0f;
    private float zOffset = 0.0f;
    private static final int FIGURE_SIZE = 80;
    private static final int GRID_SPACING = 4;

    public FigureEntry(List<FigureDefinition> figures, String collectionId) {
        this.mc = Minecraft.m_91087_();
        this.figures = new ArrayList<FigureDefinition>(figures);
        this.collectionId = collectionId;
        this.figureModel = new FigureModel();
        this.figureRenderer = new GeoBlockRenderer((GeoModel)this.figureModel);
    }

    public void setConfiguration(float modelScale, float xRotation, float yRotation, float zRotation, float xOffset, float yOffset, float zOffset) {
        this.modelScale = modelScale;
        this.xRotation = xRotation;
        this.yRotation = yRotation;
        this.zRotation = zRotation;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }

    public void m_6311_(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
        int totalFiguresWidth = this.figures.size() * 80 + (this.figures.size() - 1) * 4;
        int startX = x + (entryWidth - totalFiguresWidth) / 2;
        for (int i = 0; i < this.figures.size(); ++i) {
            boolean isFigureHovered;
            FigureDefinition figure = this.figures.get(i);
            int figureX = startX + i * 84;
            String uniqueFigureId = this.collectionId + ":" + figure.getId();
            boolean isDiscovered = ClientDiscoveryManager.isDiscovered(uniqueFigureId);
            if (isDiscovered) {
                graphics.m_280509_(figureX, y, figureX + 80, y + 80, 0x30FFFFFF);
            } else {
                graphics.m_280509_(figureX, y, figureX + 80, y + 80, 0x50000000);
            }
            boolean bl = isFigureHovered = mouseX >= figureX && mouseX < figureX + 80 && mouseY >= y && mouseY < y + 80;
            if (isFigureHovered) {
                if (isDiscovered) {
                    graphics.m_280509_(figureX, y, figureX + 80, y + 80, 0x40FFFFFF);
                } else {
                    graphics.m_280509_(figureX, y, figureX + 80, y + 80, 0x60000000);
                }
            }
            int borderColor = isDiscovered ? -2130706433 : 0x60808080;
            graphics.m_280509_(figureX, y, figureX + 80, y + 1, borderColor);
            graphics.m_280509_(figureX, y + 80 - 1, figureX + 80, y + 80, borderColor);
            graphics.m_280509_(figureX, y, figureX + 1, y + 80, borderColor);
            graphics.m_280509_(figureX + 80 - 1, y, figureX + 80, y + 80, borderColor);
            if (isDiscovered) {
                this.render3DFigure(graphics, figure, figureX, y, 80, partialTick);
                MutableComponent figureName = Component.m_237113_((String)figure.getName());
                int nameWidth = this.mc.f_91062_.m_92852_((FormattedText)figureName);
                if (nameWidth > 76) {
                    String truncated = figure.getName();
                    while (this.mc.f_91062_.m_92895_(truncated + "...") > 76 && truncated.length() > 0) {
                        truncated = truncated.substring(0, truncated.length() - 1);
                    }
                    figureName = Component.m_237113_((String)(truncated + "..."));
                }
                int nameX = figureX + (80 - this.mc.f_91062_.m_92852_((FormattedText)figureName)) / 2;
                Objects.requireNonNull(this.mc.f_91062_);
                int nameY = y + 80 - 9 - 2;
                graphics.m_280614_(this.mc.f_91062_, (Component)figureName, nameX, nameY, 0xFFFFFF, true);
                continue;
            }
            MutableComponent questionMark = Component.m_237113_((String)"?");
            int qmWidth = this.mc.f_91062_.m_92852_((FormattedText)questionMark);
            int qmX = figureX + (80 - qmWidth) / 2;
            Objects.requireNonNull(this.mc.f_91062_);
            int qmY = y + (80 - 9) / 2;
            graphics.m_280614_(this.mc.f_91062_, (Component)questionMark, qmX, qmY, 0x808080, false);
        }
    }

    private void render3DFigure(GuiGraphics graphics, FigureDefinition figure, int x, int y, int size, float partialTick) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        BoxBlockEntity renderEntity = this.getOrCreateRenderEntity(figure);
        if (renderEntity == null) {
            poseStack.m_85849_();
            return;
        }
        graphics.m_280588_(x, y, x + size, y + size);
        RenderSystem.disableDepthTest();
        float centerX = (float)x + (float)size / 2.0f + this.xOffset;
        float centerY = (float)y + (float)size * 0.6f + this.yOffset;
        float centerZ = 100.0f + this.zOffset;
        Lighting.m_84930_();
        poseStack.m_252880_(centerX, centerY, centerZ);
        float scale = (float)size * this.modelScale;
        poseStack.m_85841_(scale, -scale, scale);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(this.yRotation));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(this.xRotation));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(this.zRotation));
        MultiBufferSource.BufferSource bufferSource = this.mc.m_91269_().m_110104_();
        try {
            ResourceLocation modelResource = this.figureModel.getModelResource(renderEntity);
            if (modelResource == null) {
                RenderSystem.enableDepthTest();
                graphics.m_280618_();
                poseStack.m_85849_();
                return;
            }
            BakedGeoModel bakedModel = this.figureModel.getBakedModel(modelResource);
            ResourceLocation textureResource = this.figureModel.getTextureResource(renderEntity);
            if (textureResource == null) {
                RenderSystem.enableDepthTest();
                graphics.m_280618_();
                poseStack.m_85849_();
                return;
            }
            RenderType renderType = this.figureModel.getRenderType(renderEntity, textureResource);
            VertexConsumer buffer = bufferSource.m_6299_(renderType);
            this.figureRenderer.actuallyRender(poseStack, (BlockEntity)renderEntity, bakedModel, renderType, (MultiBufferSource)bufferSource, buffer, false, partialTick, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            bufferSource.m_109911_();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RenderSystem.enableDepthTest();
        graphics.m_280618_();
        Lighting.m_84931_();
        poseStack.m_85849_();
    }

    private BoxBlockEntity getOrCreateRenderEntity(FigureDefinition figure) {
        String cacheKey = this.collectionId + ":" + figure.getId();
        BoxBlockEntity cached = this.renderEntityCache.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        try {
            BoxBlockEntity entity = new BoxBlockEntity(BlockPos.f_121853_, Blocks.f_50016_.m_49966_());
            entity.setFigureId(figure.getId());
            entity.setCollectionIdOverride(this.collectionId);
            this.renderEntityCache.put(cacheKey, entity);
            return entity;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return false;
    }

    public Component m_142172_() {
        if (this.figures.isEmpty()) {
            return Component.m_237113_((String)"Empty row");
        }
        if (this.figures.size() == 1) {
            FigureDefinition figure = this.figures.get(0);
            String uniqueFigureId = this.collectionId + ":" + figure.getId();
            boolean isDiscovered = ClientDiscoveryManager.isDiscovered(uniqueFigureId);
            return Component.m_237113_((String)(isDiscovered ? figure.getName() : "Undiscovered Figure"));
        }
        int discoveredCount = 0;
        for (FigureDefinition figure : this.figures) {
            String uniqueFigureId = this.collectionId + ":" + figure.getId();
            if (!ClientDiscoveryManager.isDiscovered(uniqueFigureId)) continue;
            ++discoveredCount;
        }
        return Component.m_237113_((String)(discoveredCount + " of " + this.figures.size() + " figures discovered"));
    }

    public List<FigureDefinition> getFigures() {
        return this.figures;
    }
}

