/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.gui.widget;

import com.theplumteam.client.gui.widget.FigureEntry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.FigureDefinition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import org.jetbrains.annotations.Nullable;

public class FigureListWidget
extends ObjectSelectionList<FigureEntry> {
    @Nullable
    private FigureCollection currentCollection;
    private float modelScale = 1.0f;
    private float xRotation = 0.0f;
    private float yRotation = 150.0f;
    private float zRotation = 0.0f;
    private float xOffset = 14.0f;
    private float yOffset = 15.0f;
    private float zOffset = 0.0f;

    public FigureListWidget(Minecraft mc, int width, int height, int y, int entryHeight) {
        super(mc, width, height, y, y + height, entryHeight);
    }

    public void setCollection(@Nullable FigureCollection collection) {
        this.currentCollection = collection;
        this.m_6702_().clear();
        if (collection != null) {
            List<FigureDefinition> figures = collection.getFigures();
            ArrayList<FigureDefinition> currentRow = new ArrayList<FigureDefinition>();
            for (int i = 0; i < figures.size(); ++i) {
                currentRow.add(figures.get(i));
                if (currentRow.size() != 4 && i != figures.size() - 1) continue;
                FigureEntry entry = new FigureEntry(currentRow, collection.getId());
                entry.setConfiguration(this.modelScale, this.xRotation, this.yRotation, this.zRotation, this.xOffset, this.yOffset, this.zOffset);
                this.m_7085_((AbstractSelectionList.Entry)entry);
                currentRow = new ArrayList();
            }
        }
        this.m_93410_(0.0);
    }

    public void updateConfiguration(float modelScale, float xRotation, float yRotation, float zRotation, float xOffset, float yOffset, float zOffset) {
        this.modelScale = modelScale;
        this.xRotation = xRotation;
        this.yRotation = yRotation;
        this.zRotation = zRotation;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        for (FigureEntry entry : this.m_6702_()) {
            entry.setConfiguration(modelScale, xRotation, yRotation, zRotation, xOffset, yOffset, zOffset);
        }
    }

    public float getModelScale() {
        return this.modelScale;
    }

    public float getXRotation() {
        return this.xRotation;
    }

    public float getYRotation() {
        return this.yRotation;
    }

    public float getZRotation() {
        return this.zRotation;
    }

    public float getXOffset() {
        return this.xOffset;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public float getZOffset() {
        return this.zOffset;
    }

    @Nullable
    public FigureCollection getCurrentCollection() {
        return this.currentCollection;
    }

    public int m_5759_() {
        return this.f_93388_ - 8;
    }

    protected int m_5756_() {
        return this.f_93392_ - 6;
    }

    protected void m_7733_(GuiGraphics graphics) {
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.m_93410_(this.m_93517_() - amount * 20.0);
        return true;
    }
}

