/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.theplumteam.blockentity.BoxBlockEntity;
import com.theplumteam.client.model.BoxBlockModel;
import com.theplumteam.client.model.FigureModel;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.util.SkinModelDetector;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class BoxBlockRenderer
extends GeoBlockRenderer<BoxBlockEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoxBlockRenderer.class);
    private final GeoBlockRenderer<BoxBlockEntity> figureRenderer = new GeoBlockRenderer<BoxBlockEntity>((GeoModel)new FigureModel()){

        protected void rotateBlock(Direction facing, PoseStack poseStack) {
        }

        public void preRender(PoseStack poseStack, BoxBlockEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            super.preRender(poseStack, (BlockEntity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            if (animatable.hasFigure()) {
                ResourceLocation texture = this.getGeoModel().getTextureResource((GeoAnimatable)animatable);
                SkinModelDetector.SkinModel skinModel = SkinModelDetector.detectSkinModel(texture);
                boolean isSlim = skinModel == SkinModelDetector.SkinModel.SLIM;
                GeoBone rightArmSlim = model.getBone("RightArmSlim").orElse(null);
                GeoBone leftArmSlim = model.getBone("LeftArmSlim").orElse(null);
                GeoBone rightArmClassic = model.getBone("RightArmClassic").orElse(null);
                GeoBone leftArmClassic = model.getBone("LeftArmClassic").orElse(null);
                if (rightArmSlim != null) {
                    rightArmSlim.setHidden(!isSlim);
                }
                if (leftArmSlim != null) {
                    leftArmSlim.setHidden(!isSlim);
                }
                if (rightArmClassic != null) {
                    rightArmClassic.setHidden(isSlim);
                }
                if (leftArmClassic != null) {
                    leftArmClassic.setHidden(isSlim);
                }
            }
        }
    };
    private boolean renderingFigure = false;

    public BoxBlockRenderer() {
        super((GeoModel)new BoxBlockModel());
    }

    public void actuallyRender(PoseStack poseStack, BoxBlockEntity animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.actuallyRender(poseStack, (BlockEntity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (animatable.hasFigure()) {
            if (!animatable.isFigureExtracted()) {
                poseStack.m_85836_();
                poseStack.m_85837_(animatable.getFigureOffsetX(), animatable.getFigureOffsetY(), animatable.getFigureOffsetZ());
                poseStack.m_85841_((float)animatable.getFigureScale(), (float)animatable.getFigureScale(), (float)animatable.getFigureScale());
                this.figureRenderer.m_6922_((BlockEntity)animatable, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
                poseStack.m_85849_();
            }
            this.renderFigureFace(poseStack, animatable, model, bufferSource, partialTick, packedLight, packedOverlay);
        }
        this.renderLogo(poseStack, animatable, model, bufferSource, partialTick, packedLight, packedOverlay);
    }

    private void renderFigureFace(PoseStack poseStack, BoxBlockEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
        FigureDefinition figure = animatable.getFigureDefinition();
        if (figure == null) {
            return;
        }
        ResourceLocation skinTexture = this.figureRenderer.getGeoModel().getTextureResource((GeoAnimatable)animatable);
        if (skinTexture == null) {
            return;
        }
        RenderType skinRenderType = RenderType.m_110470_((ResourceLocation)skinTexture);
        VertexConsumer skinBuffer = bufferSource.m_6299_(skinRenderType);
        for (GeoBone bone : model.topLevelBones()) {
            if (bone.getName().equals("figure_face")) {
                poseStack.m_85836_();
                this.renderRecursively(poseStack, animatable, bone, skinRenderType, bufferSource, skinBuffer, true, partialTick, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                poseStack.m_85849_();
                continue;
            }
            if (!bone.getName().equals("figure_face_3d")) continue;
            poseStack.m_85836_();
            this.renderRecursively(poseStack, animatable, bone, skinRenderType, bufferSource, skinBuffer, true, partialTick, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
    }

    private void renderLogo(PoseStack poseStack, BoxBlockEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
        if (animatable.isHideLogo()) {
            return;
        }
        String collectionId = animatable.getCollectionId();
        FigureCollection collection = CollectionRegistry.getCollection(collectionId).orElse(null);
        if (collection == null) {
            return;
        }
        FigureCollection.LogoConfig collectionLogoConfig = collection.getLogoConfig();
        if (collectionLogoConfig == null) {
            return;
        }
        float logoPositionX = animatable.getLogoPositionX() != null ? animatable.getLogoPositionX().floatValue() : collectionLogoConfig.getPositionX();
        float logoPositionY = animatable.getLogoPositionY() != null ? animatable.getLogoPositionY().floatValue() : collectionLogoConfig.getPositionY();
        float logoPositionZ = animatable.getLogoPositionZ() != null ? animatable.getLogoPositionZ().floatValue() : collectionLogoConfig.getPositionZ();
        float logoScaleX = animatable.getLogoScaleX() != null ? animatable.getLogoScaleX().floatValue() : collectionLogoConfig.getScaleX();
        float logoScaleY = animatable.getLogoScaleY() != null ? animatable.getLogoScaleY().floatValue() : collectionLogoConfig.getScaleY();
        float logoScaleZ = animatable.getLogoScaleZ() != null ? animatable.getLogoScaleZ().floatValue() : collectionLogoConfig.getScaleZ();
        RenderType logoRenderType = RenderType.m_110458_((ResourceLocation)collectionLogoConfig.getTexture());
        VertexConsumer logoBuffer = bufferSource.m_6299_(logoRenderType);
        for (GeoBone bone : model.topLevelBones()) {
            if (!bone.getName().equals("logo")) continue;
            poseStack.m_85836_();
            poseStack.m_252880_(logoPositionX, logoPositionY, logoPositionZ);
            poseStack.m_85841_(logoScaleX, logoScaleY, logoScaleZ);
            this.renderRecursively(poseStack, animatable, bone, logoRenderType, bufferSource, logoBuffer, true, partialTick, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
            break;
        }
    }

    public void renderRecursively(PoseStack poseStack, BoxBlockEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        String boneName = bone.getName();
        if ((boneName.equals("figure_face") || boneName.equals("figure_face_3d") || boneName.equals("logo")) && !isReRender) {
            return;
        }
        super.renderRecursively(poseStack, (BlockEntity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

