/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.theplumteam.capability.PlayerDiscoveryProvider;
import com.theplumteam.forge.BlockPopsModForge;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.server.ServerTickHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadRegularTokensCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReloadRegularTokensCommand.class);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"blockpops").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reloadregular").requires(source -> source.m_6761_(2))).executes(ReloadRegularTokensCommand::executeCommand)));
    }

    private static int executeCommand(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer player = source.m_81375_();
            player.getCapability(PlayerDiscoveryProvider.PLAYER_DISCOVERY).ifPresent(discovery -> {
                discovery.setRegularTokens(3);
                discovery.setNextRegularTokenTime(0L);
                LOGGER.info("Reloaded regular tokens for player {}", (Object)player.m_7755_().getString());
                long gameTime = player.m_284548_().m_46467_();
                long nextRegularTime = discovery.getNextRegularTokenTime();
                long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
                long millisUntilReset = ServerTickHandler.calculateMillisUntilNextReset();
                SyncTokenDataPacket tokenPacket = new SyncTokenDataPacket(discovery.getRegularTokens(), ticksUntilNext, !discovery.hasUsedTodaySpecialToken(), millisUntilReset);
                BlockPopsModForge.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)tokenPacket);
            });
            source.m_288197_(() -> Component.m_237113_((String)"Reloaded regular tokens to 3"), true);
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)"This command can only be executed by a player"));
            LOGGER.error("Error executing reloadregular command", (Throwable)e);
            return 0;
        }
    }
}

