/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.theplumteam.BlockPopsMod;
import com.theplumteam.capability.PlayerDiscoveryProvider;
import com.theplumteam.command.ChangeFavoriteColorCommand;
import com.theplumteam.command.GetBoxCommand;
import com.theplumteam.command.GetFavoriteColorCommand;
import com.theplumteam.command.ReloadGuaranteedTokenCommand;
import com.theplumteam.command.ReloadRegularTokensCommand;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.PlayerCollectionGenerator;
import com.theplumteam.network.ClawMachineCollectionPacket;
import com.theplumteam.network.DropBoxPacket;
import com.theplumteam.network.FigurePositionPacket;
import com.theplumteam.network.OpenFavoriteColorScreenPacket;
import com.theplumteam.network.ReloadTokensPacket;
import com.theplumteam.network.SetFavoriteColorPacket;
import com.theplumteam.network.SyncDiscoveryDataPacket;
import com.theplumteam.network.SyncDynamicCollectionsPacket;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.network.UnlockCollectionPacket;
import com.theplumteam.network.UnlockFigurePacket;
import com.theplumteam.network.UpdateGuaranteedResetHourPacket;
import com.theplumteam.registry.ModBlockEntities;
import com.theplumteam.registry.ModBlocks;
import com.theplumteam.registry.ModCreativeTabs;
import com.theplumteam.registry.ModItems;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.platform.forge.EventBuses;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod(value="blockpops")
public final class BlockPopsModForge {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("blockpops", "main"), () -> "1", "1"::equals, "1"::equals);

    public BlockPopsModForge() {
        EventBuses.registerModEventBus((String)"blockpops", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        ModBlocks.register();
        ModItems.register();
        ModBlockEntities.register();
        ModCreativeTabs.register();
        this.registerNetworkPackets();
        this.registerServerEvents();
        MinecraftForge.EVENT_BUS.register((Object)this);
        BlockPopsMod.init();
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        GetBoxCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ChangeFavoriteColorCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        GetFavoriteColorCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ReloadRegularTokensCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ReloadGuaranteedTokenCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        BlockPopsMod.LOGGER.info("Registered /blockpops commands: getbox, changefavoritecolor, getfavoritecolor, reloadregular, reloadguaranteed");
    }

    private void registerServerEvents() {
        LifecycleEvent.SERVER_STARTING.register(server -> {
            BlockPopsMod.LOGGER.info("Generating World Players collection...");
            FigureCollection playerCollection = PlayerCollectionGenerator.generate(server);
            CollectionRegistry.registerDynamicCollection(playerCollection);
        });
        PlayerEvent.PLAYER_JOIN.register(player -> {
            if (player.m_20194_() != null) {
                FigureCollection updatedCollection = PlayerCollectionGenerator.generate(player.m_20194_());
                CollectionRegistry.registerDynamicCollection(updatedCollection);
                BlockPopsMod.LOGGER.debug("Updated World Players collection after player join: {}", (Object)player.m_7755_().getString());
                ArrayList<FigureCollection> dynamicCollections = new ArrayList<FigureCollection>();
                CollectionRegistry.getAllCollections().forEach(collection -> {
                    if ("world_players".equals(collection.getId())) {
                        dynamicCollections.add((FigureCollection)collection);
                    }
                });
                if (!dynamicCollections.isEmpty()) {
                    SyncDynamicCollectionsPacket collectionsPacket = new SyncDynamicCollectionsPacket((List<FigureCollection>)dynamicCollections);
                    NETWORK_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)collectionsPacket);
                    BlockPopsMod.LOGGER.info("Synced {} dynamic collections to all players", (Object)dynamicCollections.size());
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = player;
                    serverPlayer.getCapability(PlayerDiscoveryProvider.PLAYER_DISCOVERY).ifPresent(discovery -> {
                        SyncDiscoveryDataPacket discoveryPacket = new SyncDiscoveryDataPacket(discovery.getDiscoveredSet(), discovery.getAllFigureSkins());
                        NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)discoveryPacket);
                        BlockPopsMod.LOGGER.info("Synced {} discovered figures and {} skins to {}", new Object[]{discovery.getDiscoveredSet().size(), discovery.getAllFigureSkins().size(), serverPlayer.m_7755_().getString()});
                        long gameTime = serverPlayer.m_284548_().m_46467_();
                        long nextRegularTime = discovery.getNextRegularTokenTime();
                        long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
                        long millisUntilReset = BlockPopsModForge.calculateMillisUntilNextReset();
                        SyncTokenDataPacket tokenPacket = new SyncTokenDataPacket(discovery.getRegularTokens(), ticksUntilNext, !discovery.hasUsedTodaySpecialToken(), millisUntilReset);
                        NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)tokenPacket);
                        BlockPopsMod.LOGGER.info("Synced token data to {}: {} regular tokens, special: {}", new Object[]{serverPlayer.m_7755_().getString(), discovery.getRegularTokens(), !discovery.hasUsedTodaySpecialToken() ? "available" : "used"});
                        if (!discovery.hasChosenFavoriteColor()) {
                            BlockPopsMod.LOGGER.info("Player {} has not chosen a favorite color. Sending packet to open selection screen.", (Object)serverPlayer.m_7755_().getString());
                            NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new OpenFavoriteColorScreenPacket());
                        }
                    });
                }
            }
        });
    }

    private void registerNetworkPackets() {
        int packetId = 0;
        NETWORK_CHANNEL.registerMessage(packetId++, FigurePositionPacket.class, FigurePositionPacket::encode, FigurePositionPacket::decode, FigurePositionPacket::handle);
        NETWORK_CHANNEL.registerMessage(packetId++, ClawMachineCollectionPacket.class, ClawMachineCollectionPacket::encode, ClawMachineCollectionPacket::decode, ClawMachineCollectionPacket::handle);
        NETWORK_CHANNEL.registerMessage(packetId++, DropBoxPacket.class, DropBoxPacket::encode, DropBoxPacket::decode, DropBoxPacket::handle);
        NETWORK_CHANNEL.registerMessage(packetId++, SyncDiscoveryDataPacket.class, SyncDiscoveryDataPacket::encode, SyncDiscoveryDataPacket::decode, SyncDiscoveryDataPacket::handle);
        NETWORK_CHANNEL.registerMessage(packetId++, UnlockFigurePacket.class, UnlockFigurePacket::encode, UnlockFigurePacket::decode, UnlockFigurePacket::handle);
        NETWORK_CHANNEL.registerMessage(packetId++, SyncTokenDataPacket.class, SyncTokenDataPacket::encode, SyncTokenDataPacket::decode, SyncTokenDataPacket::handle);
        NETWORK_CHANNEL.registerMessage(packetId++, OpenFavoriteColorScreenPacket.class, OpenFavoriteColorScreenPacket::encode, OpenFavoriteColorScreenPacket::decode, OpenFavoriteColorScreenPacket::handle);
        NETWORK_CHANNEL.registerMessage(packetId++, SetFavoriteColorPacket.class, SetFavoriteColorPacket::encode, SetFavoriteColorPacket::decode, SetFavoriteColorPacket::handle);
        NETWORK_CHANNEL.registerMessage(packetId++, SyncDynamicCollectionsPacket.class, SyncDynamicCollectionsPacket::encode, SyncDynamicCollectionsPacket::decode, SyncDynamicCollectionsPacket::handle);
        NETWORK_CHANNEL.registerMessage(packetId++, UnlockCollectionPacket.class, UnlockCollectionPacket::encode, UnlockCollectionPacket::decode, UnlockCollectionPacket::handle);
        NETWORK_CHANNEL.registerMessage(packetId++, ReloadTokensPacket.class, ReloadTokensPacket::encode, ReloadTokensPacket::decode, ReloadTokensPacket::handle);
        NETWORK_CHANNEL.registerMessage(packetId++, UpdateGuaranteedResetHourPacket.class, UpdateGuaranteedResetHourPacket::encode, UpdateGuaranteedResetHourPacket::decode, UpdateGuaranteedResetHourPacket::handle);
    }

    private static long calculateMillisUntilNextReset() {
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
        ZonedDateTime nextReset = now.withHour(18).withMinute(0).withSecond(0).withNano(0);
        if (now.getHour() >= 18) {
            nextReset = nextReset.plusDays(1L);
        }
        return nextReset.toInstant().toEpochMilli() - now.toInstant().toEpochMilli();
    }
}

