/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.blockentity.ClawMachineBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClawMachineCollectionPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClawMachineCollectionPacket.class);
    private final BlockPos pos;
    private final String collectionId;

    public ClawMachineCollectionPacket(BlockPos pos, String collectionId) {
        this.pos = pos;
        this.collectionId = collectionId;
    }

    public static void encode(ClawMachineCollectionPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.m_130070_(packet.collectionId);
    }

    public static ClawMachineCollectionPacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        String collectionId = buffer.m_130277_();
        return new ClawMachineCollectionPacket(pos, collectionId);
    }

    public static void handle(ClawMachineCollectionPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        LOGGER.info("Received packet on server - Position: {}, Collection ID: {}", (Object)packet.pos, (Object)packet.collectionId);
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                LOGGER.info("Player is not null: {}", (Object)player.m_7755_().getString());
                BlockEntity blockEntity = player.m_9236_().m_7702_(packet.pos);
                LOGGER.info("BlockEntity at {}: {}", (Object)packet.pos, (Object)blockEntity);
                if (blockEntity instanceof ClawMachineBlockEntity) {
                    ClawMachineBlockEntity clawMachineBlockEntity = (ClawMachineBlockEntity)blockEntity;
                    LOGGER.info("Setting collection ID on ClawMachineBlockEntity");
                    clawMachineBlockEntity.setCollectionId(packet.collectionId);
                    player.m_9236_().m_7260_(packet.pos, blockEntity.m_58900_(), blockEntity.m_58900_(), 3);
                    LOGGER.info("Collection ID updated successfully");
                } else {
                    LOGGER.warn("BlockEntity is not a ClawMachineBlockEntity!");
                }
            } else {
                LOGGER.warn("Player is null in packet handler!");
            }
        });
        context.setPacketHandled(true);
    }
}

