/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.capability.IPlayerDiscovery;
import com.theplumteam.capability.PlayerDiscoveryProvider;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import com.theplumteam.figure.PlayerCollectionGenerator;
import com.theplumteam.forge.BlockPopsModForge;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.network.TokenType;
import com.theplumteam.network.UnlockFigurePacket;
import com.theplumteam.registry.ModItems;
import com.theplumteam.server.ServerTickHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropBoxPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropBoxPacket.class);
    private final BlockPos pos;
    private final String collectionId;
    private final TokenType tokenType;

    public DropBoxPacket(BlockPos pos, String collectionId, TokenType tokenType) {
        this.pos = pos;
        this.collectionId = collectionId;
        this.tokenType = tokenType;
    }

    public static void encode(DropBoxPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.m_130070_(packet.collectionId);
        buffer.m_130068_((Enum)packet.tokenType);
    }

    public static DropBoxPacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        String collectionId = buffer.m_130277_();
        TokenType tokenType = (TokenType)buffer.m_130066_(TokenType.class);
        return new DropBoxPacket(pos, collectionId, tokenType);
    }

    public static void handle(DropBoxPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        LOGGER.info("Received drop box packet on server - Position: {}, Collection ID: {}, Token Type: {}", new Object[]{packet.pos, packet.collectionId, packet.tokenType});
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                LOGGER.info("Player: {} - Processing {} token request", (Object)player.m_7755_().getString(), (Object)packet.tokenType);
                if (player.m_150109_().m_36062_() == -1) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7cInventory is full! Cannot receive figure box."));
                    LOGGER.info("Player {} inventory is full, token not consumed", (Object)player.m_7755_().getString());
                    return;
                }
                player.getCapability(PlayerDiscoveryProvider.PLAYER_DISCOVERY).ifPresent(discovery -> {
                    if (!DropBoxPacket.verifyAndConsumeToken(player, discovery, packet.tokenType)) {
                        LOGGER.warn("Player {} tried to use unavailable {} token", (Object)player.m_7755_().getString(), (Object)packet.tokenType);
                        return;
                    }
                    DropBoxPacket.processBoxDrop(player, packet, discovery);
                });
            } else {
                LOGGER.warn("Player is null in packet handler!");
            }
        });
        context.setPacketHandled(true);
    }

    @Nullable
    private static GameProfile getFreshGameProfile(ServerPlayer player, FigureDefinition figure) {
        if (figure.getPlayerUUID() == null) {
            return null;
        }
        try {
            GameProfile freshProfile = new GameProfile(figure.getPlayerUUID(), figure.getName());
            return player.m_20194_().m_129925_().fillProfileProperties(freshProfile, true);
        }
        catch (Exception e) {
            LOGGER.error("Failed to fetch fresh GameProfile for {}: {}", (Object)figure.getName(), (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    private static String getQuickSkinIdFromServer(UUID playerId) {
        try {
            Class<?> repoClass = Class.forName("com.quickskin.mod.server.data.ServerPlayerAppearanceRepository");
            Method getInstanceMethod = repoClass.getMethod("getInstance", new Class[0]);
            Object repoInstance = getInstanceMethod.invoke(null, new Object[0]);
            Method getAppearanceMethod = repoClass.getMethod("getAppearance", UUID.class);
            Object appearance = getAppearanceMethod.invoke(repoInstance, playerId);
            if (appearance != null) {
                Class<?> appearanceClass = appearance.getClass();
                Method getSkinIdMethod = appearanceClass.getMethod("getSkinId", new Class[0]);
                return (String)getSkinIdMethod.invoke(appearance, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void processBoxDrop(ServerPlayer player, DropBoxPacket packet, IPlayerDiscovery discovery) {
        CollectionRegistry.getCollection(packet.collectionId).ifPresent(collection -> {
            List<FigureDefinition> figures = collection.getFigures();
            if (!figures.isEmpty()) {
                FigureDefinition selectedFigure = DropBoxPacket.selectFigure(figures, packet.tokenType, discovery, packet.collectionId);
                ItemStack boxItem = null;
                if (packet.collectionId.equals(PlayerCollectionGenerator.getCollectionId())) {
                    PopBlockColor color = selectedFigure.getFavoriteColor();
                    if (color == null) {
                        color = PopBlockColor.ORIGINAL;
                    }
                    boxItem = new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)color).get());
                } else {
                    boxItem = ModItems.BOX_BLOCK_ITEMS.containsKey(packet.collectionId) ? new ItemStack((ItemLike)ModItems.BOX_BLOCK_ITEMS.get(packet.collectionId).get()) : new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)PopBlockColor.ORIGINAL).get());
                }
                if (boxItem != null) {
                    String oldSnapshot;
                    String uniqueFigureId = packet.collectionId + ":" + selectedFigure.getId();
                    String skinSnapshot = null;
                    String quickSkinSnapshot = null;
                    if (selectedFigure.getType() == FigureType.PLAYER) {
                        String qsId;
                        GameProfile freshProfile = DropBoxPacket.getFreshGameProfile(player, selectedFigure);
                        if (freshProfile != null && !freshProfile.getProperties().get((Object)"textures").isEmpty()) {
                            skinSnapshot = ((Property)freshProfile.getProperties().get((Object)"textures").iterator().next()).getValue();
                            discovery.saveFigureSkin(uniqueFigureId, skinSnapshot);
                            LOGGER.info("Saved/updated fresh skin snapshot for {}.", (Object)uniqueFigureId);
                        }
                        if (selectedFigure.getPlayerUUID() != null && (qsId = DropBoxPacket.getQuickSkinIdFromServer(selectedFigure.getPlayerUUID())) != null && !qsId.isEmpty()) {
                            quickSkinSnapshot = qsId;
                            LOGGER.info("Captured Quick Skin ID for figure {}: {}", (Object)uniqueFigureId, (Object)qsId);
                        }
                    }
                    if (!discovery.isDiscovered(uniqueFigureId)) {
                        discovery.discover(uniqueFigureId);
                        UnlockFigurePacket unlockPacket = new UnlockFigurePacket(uniqueFigureId, selectedFigure.getName(), skinSnapshot);
                        BlockPopsModForge.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)unlockPacket);
                        LOGGER.info("Player {} discovered new figure: {} ({})", new Object[]{player.m_7755_().getString(), selectedFigure.getName(), uniqueFigureId});
                        player.m_6330_(SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    } else {
                        player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    CompoundTag blockEntityTag = new CompoundTag();
                    blockEntityTag.m_128359_("FigureId", selectedFigure.getId());
                    blockEntityTag.m_128359_("CollectionId", packet.collectionId);
                    if (packet.collectionId.equals(PlayerCollectionGenerator.getCollectionId())) {
                        PopBlockColor color = selectedFigure.getFavoriteColor();
                        if (color == null) {
                            color = PopBlockColor.ORIGINAL;
                        }
                        blockEntityTag.m_128359_("Color", color.name());
                    }
                    if (skinSnapshot != null && !skinSnapshot.isEmpty()) {
                        blockEntityTag.m_128359_("SkinSnapshot", skinSnapshot);
                    } else if (selectedFigure.getType() == FigureType.PLAYER && (oldSnapshot = discovery.getFigureSkin(uniqueFigureId)) != null && !oldSnapshot.isEmpty()) {
                        blockEntityTag.m_128359_("SkinSnapshot", oldSnapshot);
                    }
                    if (quickSkinSnapshot != null) {
                        blockEntityTag.m_128359_("QuickSkinId", quickSkinSnapshot);
                    }
                    boxItem.m_41784_().m_128365_("BlockEntityTag", (Tag)blockEntityTag);
                    player.m_150109_().m_36054_(boxItem);
                }
            }
        });
    }

    private static boolean verifyAndConsumeToken(ServerPlayer player, IPlayerDiscovery discovery, TokenType tokenType) {
        if (tokenType == TokenType.REGULAR) {
            if (discovery.getRegularTokens() > 0) {
                discovery.setRegularTokens(discovery.getRegularTokens() - 1);
                LOGGER.info("Player {} used a regular token. Remaining: {}", (Object)player.m_7755_().getString(), (Object)discovery.getRegularTokens());
                DropBoxPacket.syncTokenDataToClient(player, discovery);
                return true;
            }
        } else if (tokenType == TokenType.GUARANTEED && !discovery.hasUsedTodaySpecialToken()) {
            discovery.setUsedTodaySpecialToken(true);
            LOGGER.info("Player {} used their guaranteed token", (Object)player.m_7755_().getString());
            DropBoxPacket.syncTokenDataToClient(player, discovery);
            return true;
        }
        return false;
    }

    private static void syncTokenDataToClient(ServerPlayer player, IPlayerDiscovery discovery) {
        long gameTime = player.m_284548_().m_46467_();
        long nextRegularTime = discovery.getNextRegularTokenTime();
        long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
        long millisUntilReset = ServerTickHandler.calculateMillisUntilNextReset();
        SyncTokenDataPacket packet = new SyncTokenDataPacket(discovery.getRegularTokens(), ticksUntilNext, !discovery.hasUsedTodaySpecialToken(), millisUntilReset);
        BlockPopsModForge.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    private static FigureDefinition selectFigure(List<FigureDefinition> figures, TokenType tokenType, IPlayerDiscovery discovery, String collectionId) {
        Random random = new Random();
        if (tokenType == TokenType.GUARANTEED) {
            Set<String> discoveredSet = discovery.getDiscoveredSet();
            ArrayList<FigureDefinition> undiscoveredFigures = new ArrayList<FigureDefinition>();
            for (FigureDefinition figure : figures) {
                String figureId = collectionId + ":" + figure.getId();
                if (discoveredSet.contains(figureId)) continue;
                undiscoveredFigures.add(figure);
            }
            if (!undiscoveredFigures.isEmpty()) {
                FigureDefinition selected = (FigureDefinition)undiscoveredFigures.get(random.nextInt(undiscoveredFigures.size()));
                LOGGER.info("Guaranteed token logic: Selected undiscovered figure '{}'", (Object)selected.getId());
                return selected;
            }
            LOGGER.info("Guaranteed token logic: Collection complete, giving random duplicate");
            return figures.get(random.nextInt(figures.size()));
        }
        return figures.get(random.nextInt(figures.size()));
    }
}

