/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.block.PopBlockColor;
import com.theplumteam.capability.PlayerDiscoveryProvider;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import com.theplumteam.figure.PlayerCollectionGenerator;
import com.theplumteam.forge.BlockPopsModForge;
import com.theplumteam.network.SyncDynamicCollectionsPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetFavoriteColorPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetFavoriteColorPacket.class);
    private final String colorName;

    public SetFavoriteColorPacket(String colorName) {
        this.colorName = colorName;
    }

    public static void encode(SetFavoriteColorPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130070_(packet.colorName);
    }

    public static SetFavoriteColorPacket decode(FriendlyByteBuf buffer) {
        String colorName = buffer.m_130277_();
        return new SetFavoriteColorPacket(colorName);
    }

    public static void handle(SetFavoriteColorPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                player.getCapability(PlayerDiscoveryProvider.PLAYER_DISCOVERY).ifPresent(discovery -> {
                    try {
                        PopBlockColor color = PopBlockColor.valueOf(packet.colorName.toUpperCase());
                        discovery.setFavoriteColor(color);
                        discovery.setHasChosenFavoriteColor(true);
                        LOGGER.info("Player {} chose favorite color: {}", (Object)player.m_7755_().getString(), (Object)color.m_7912_());
                        if (player.m_20194_() != null) {
                            FigureCollection updatedCollection = PlayerCollectionGenerator.generate(player.m_20194_());
                            CollectionRegistry.registerDynamicCollection(updatedCollection);
                            LOGGER.info("Regenerated World Players collection after {} changed their favorite color", (Object)player.m_7755_().getString());
                            ArrayList<FigureCollection> dynamicCollections = new ArrayList<FigureCollection>();
                            dynamicCollections.add(updatedCollection);
                            SyncDynamicCollectionsPacket collectionsPacket = new SyncDynamicCollectionsPacket((List<FigureCollection>)dynamicCollections);
                            BlockPopsModForge.NETWORK_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)collectionsPacket);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.warn("Player {} sent invalid color name: {}", (Object)player.m_7755_().getString(), (Object)packet.colorName);
                    }
                });
            }
        });
        context.setPacketHandled(true);
    }
}

