/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.capability.IPlayerDiscovery;
import com.theplumteam.capability.PlayerDiscoveryProvider;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureDefinition;
import com.theplumteam.figure.FigureType;
import com.theplumteam.figure.PlayerCollectionGenerator;
import com.theplumteam.forge.BlockPopsModForge;
import com.theplumteam.network.UnlockFigurePacket;
import com.theplumteam.registry.ModItems;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlockCollectionPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnlockCollectionPacket.class);
    private final String collectionId;

    public UnlockCollectionPacket(String collectionId) {
        this.collectionId = collectionId;
    }

    public static void encode(UnlockCollectionPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130070_(packet.collectionId);
    }

    public static UnlockCollectionPacket decode(FriendlyByteBuf buffer) {
        String collectionId = buffer.m_130277_();
        return new UnlockCollectionPacket(collectionId);
    }

    public static void handle(UnlockCollectionPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                LOGGER.info("Player {} requested to unlock collection: {}", (Object)player.m_7755_().getString(), (Object)packet.collectionId);
                player.getCapability(PlayerDiscoveryProvider.PLAYER_DISCOVERY).ifPresent(discovery -> UnlockCollectionPacket.unlockEntireCollection(player, packet.collectionId, discovery));
            } else {
                LOGGER.warn("Player is null in UnlockCollectionPacket handler!");
            }
        });
        context.setPacketHandled(true);
    }

    private static void unlockEntireCollection(ServerPlayer player, String collectionId, IPlayerDiscovery discovery) {
        CollectionRegistry.getCollection(collectionId).ifPresent(collection -> {
            List<FigureDefinition> figures = collection.getFigures();
            if (figures.isEmpty()) {
                LOGGER.warn("Collection {} has no figures", (Object)collectionId);
                return;
            }
            LOGGER.info("Unlocking {} figures from collection {} for player {}", new Object[]{figures.size(), collectionId, player.m_7755_().getString()});
            for (FigureDefinition figure : figures) {
                UnlockCollectionPacket.giveBoxForFigure(player, collectionId, figure, discovery);
            }
            LOGGER.info("Successfully unlocked all figures from collection {} for player {}", (Object)collectionId, (Object)player.m_7755_().getString());
        });
    }

    @Nullable
    private static String getQuickSkinIdFromServer(UUID playerId) {
        try {
            Class<?> repoClass = Class.forName("com.quickskin.mod.server.data.ServerPlayerAppearanceRepository");
            Method getInstanceMethod = repoClass.getMethod("getInstance", new Class[0]);
            Object repoInstance = getInstanceMethod.invoke(null, new Object[0]);
            Method getAppearanceMethod = repoClass.getMethod("getAppearance", UUID.class);
            Object appearance = getAppearanceMethod.invoke(repoInstance, playerId);
            if (appearance != null) {
                Class<?> appearanceClass = appearance.getClass();
                Method getSkinIdMethod = appearanceClass.getMethod("getSkinId", new Class[0]);
                return (String)getSkinIdMethod.invoke(appearance, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void giveBoxForFigure(ServerPlayer player, String collectionId, FigureDefinition figure, IPlayerDiscovery discovery) {
        String oldSnapshot;
        ItemStack boxItem = null;
        if (collectionId.equals(PlayerCollectionGenerator.getCollectionId())) {
            PopBlockColor color = figure.getFavoriteColor();
            if (color == null) {
                color = PopBlockColor.ORIGINAL;
            }
            boxItem = new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)color).get());
        } else {
            boxItem = ModItems.BOX_BLOCK_ITEMS.containsKey(collectionId) ? new ItemStack((ItemLike)ModItems.BOX_BLOCK_ITEMS.get(collectionId).get()) : new ItemStack((ItemLike)ModItems.DEFAULT_BOX_BLOCK_ITEMS.get((Object)PopBlockColor.ORIGINAL).get());
        }
        if (boxItem == null) {
            LOGGER.warn("Could not find box item for collection {}", (Object)collectionId);
            return;
        }
        String uniqueFigureId = collectionId + ":" + figure.getId();
        String skinSnapshot = null;
        String quickSkinSnapshot = null;
        if (figure.getType() == FigureType.PLAYER) {
            String qsId;
            GameProfile freshProfile = UnlockCollectionPacket.getFreshGameProfile(player, figure);
            if (freshProfile != null && !freshProfile.getProperties().get((Object)"textures").isEmpty()) {
                skinSnapshot = ((Property)freshProfile.getProperties().get((Object)"textures").iterator().next()).getValue();
                discovery.saveFigureSkin(uniqueFigureId, skinSnapshot);
                LOGGER.debug("Saved skin snapshot for player figure: {}", (Object)uniqueFigureId);
            }
            if (figure.getPlayerUUID() != null && (qsId = UnlockCollectionPacket.getQuickSkinIdFromServer(figure.getPlayerUUID())) != null && !qsId.isEmpty()) {
                quickSkinSnapshot = qsId;
                LOGGER.info("Captured Quick Skin ID for figure {}: {}", (Object)uniqueFigureId, (Object)qsId);
            }
        }
        if (!discovery.isDiscovered(uniqueFigureId)) {
            discovery.discover(uniqueFigureId);
            UnlockFigurePacket unlockPacket = new UnlockFigurePacket(uniqueFigureId, figure.getName(), skinSnapshot);
            BlockPopsModForge.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)unlockPacket);
            LOGGER.debug("Unlocked new figure: {} ({})", (Object)figure.getName(), (Object)uniqueFigureId);
        }
        CompoundTag blockEntityTag = new CompoundTag();
        blockEntityTag.m_128359_("FigureId", figure.getId());
        blockEntityTag.m_128359_("CollectionId", collectionId);
        if (collectionId.equals(PlayerCollectionGenerator.getCollectionId())) {
            PopBlockColor color = figure.getFavoriteColor();
            if (color == null) {
                color = PopBlockColor.ORIGINAL;
            }
            blockEntityTag.m_128359_("Color", color.name());
        }
        if (skinSnapshot != null && !skinSnapshot.isEmpty()) {
            blockEntityTag.m_128359_("SkinSnapshot", skinSnapshot);
        } else if (figure.getType() == FigureType.PLAYER && (oldSnapshot = discovery.getFigureSkin(uniqueFigureId)) != null && !oldSnapshot.isEmpty()) {
            blockEntityTag.m_128359_("SkinSnapshot", oldSnapshot);
        }
        if (quickSkinSnapshot != null) {
            blockEntityTag.m_128359_("QuickSkinId", quickSkinSnapshot);
        }
        boxItem.m_41784_().m_128365_("BlockEntityTag", (Tag)blockEntityTag);
        ItemEntity itemEntity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), boxItem);
        itemEntity.m_20334_(0.0, 0.2, 0.0);
        player.m_9236_().m_7967_((Entity)itemEntity);
    }

    @Nullable
    private static GameProfile getFreshGameProfile(ServerPlayer player, FigureDefinition figure) {
        if (figure.getPlayerUUID() == null) {
            return null;
        }
        try {
            GameProfile freshProfile = new GameProfile(figure.getPlayerUUID(), figure.getName());
            return player.m_20194_().m_129925_().fillProfileProperties(freshProfile, true);
        }
        catch (Exception e) {
            LOGGER.error("Failed to fetch fresh GameProfile for {}: {}", (Object)figure.getName(), (Object)e.getMessage());
            return null;
        }
    }
}

