/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.carving;

import com.leclowndu93150.chisel.api.carving.IChiselMode;
import com.leclowndu93150.chisel.api.carving.IModeRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ChiselModeRegistry implements IModeRegistry
{
    INSTANCE;

    private final Map<String, IChiselMode> modes = new LinkedHashMap<String, IChiselMode>();

    @Override
    public void registerMode(@Nonnull IChiselMode mode) {
        this.modes.put(mode.name(), mode);
    }

    @Override
    @Nonnull
    public Collection<IChiselMode> getAllModes() {
        return Collections.unmodifiableCollection(this.modes.values());
    }

    @Override
    @Nullable
    public IChiselMode getModeByName(String name) {
        return this.modes.get(name);
    }

    public IChiselMode getNextMode(IChiselMode current) {
        IChiselMode[] allModes = this.modes.values().toArray(new IChiselMode[0]);
        for (int i = 0; i < allModes.length; ++i) {
            if (allModes[i] != current) continue;
            return allModes[(i + 1) % allModes.length];
        }
        return allModes.length > 0 ? allModes[0] : current;
    }

    public IChiselMode getPreviousMode(IChiselMode current) {
        IChiselMode[] allModes = this.modes.values().toArray(new IChiselMode[0]);
        for (int i = 0; i < allModes.length; ++i) {
            if (allModes[i] != current) continue;
            return allModes[(i - 1 + allModes.length) % allModes.length];
        }
        return allModes.length > 0 ? allModes[0] : current;
    }
}

