/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.inventory;

import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.inventory.ChiselMenu;
import com.leclowndu93150.chisel.inventory.InventoryChiselSelection;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class SlotChiselSelection
extends Slot {
    private final ChiselMenu container;

    public SlotChiselSelection(ChiselMenu container, InventoryChiselSelection inv, int slot, int x, int y) {
        super((Container)inv, slot, x, y);
        this.container = container;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public boolean mayPickup(Player player) {
        return player.containerMenu.getCarried().isEmpty();
    }

    public static ItemStack craft(ChiselMenu container, Player player, ItemStack target, boolean simulate) {
        ItemStack source = container.getInventoryChisel().getStackInSpecialSlot();
        ItemStack chisel = container.getChisel();
        if (simulate) {
            target = target.copy();
            source = source.isEmpty() ? ItemStack.EMPTY : source.copy();
            chisel = chisel.copy();
        }
        ItemStack result = ItemStack.EMPTY;
        if (!chisel.isEmpty() && !source.isEmpty()) {
            Item item = chisel.getItem();
            if (!(item instanceof IChiselItem)) {
                return result;
            }
            IChiselItem chiselItem = (IChiselItem)item;
            if (!chiselItem.canChisel(player.level(), player, chisel, target)) {
                return result;
            }
            EquipmentSlot equipSlot = container.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            result = chiselItem.craftItem(chisel, source, target, player, equipSlot);
            if (!simulate) {
                container.getInventoryChisel().setStackInSpecialSlot(source.isEmpty() ? ItemStack.EMPTY : source);
                container.onChiselSlotChanged();
                Block targetBlock = Blocks.AIR;
                Item item2 = target.getItem();
                if (item2 instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item2;
                    targetBlock = blockItem.getBlock();
                }
                chiselItem.onChisel(player.level(), player, chisel, targetBlock);
                if (chisel.isEmpty() || chisel.getCount() == 0) {
                    container.getInventoryPlayer().setItem(container.getChiselSlot(), ItemStack.EMPTY);
                }
                if (!source.isEmpty() && !chiselItem.canChisel(player.level(), player, chisel, target)) {
                    container.onChiselBroken();
                }
                container.getInventoryChisel().updateItems();
                container.broadcastChanges();
            }
        }
        return result;
    }

    public void onTake(Player player, ItemStack stack) {
        ItemStack chisel = this.container.getChisel().copy();
        ItemStack result = SlotChiselSelection.craft(this.container, player, stack, false);
        if (!result.isEmpty()) {
            Block targetBlock = Blocks.AIR;
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                targetBlock = blockItem.getBlock();
            }
            CarvingHelper.playChiselSound(player.level(), player, targetBlock);
            ClickType clickType = this.container.getCurrentClickType();
            if (clickType != null) {
                switch (clickType) {
                    case PICKUP: 
                    case PICKUP_ALL: 
                    case QUICK_CRAFT: 
                    case QUICK_MOVE: {
                        this.container.setCarried(result);
                        break;
                    }
                    case SWAP: 
                    case THROW: {
                        stack.setCount(result.getCount());
                        break;
                    }
                }
            } else {
                this.container.setCarried(result);
            }
        } else {
            stack.setCount(0);
        }
    }
}

