/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.item;

import com.leclowndu93150.chisel.ChiselConfig;
import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.api.carving.IChiselMode;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.carving.ChiselMode;
import com.leclowndu93150.chisel.carving.ChiselModeRegistry;
import com.leclowndu93150.chisel.component.ChiselData;
import com.leclowndu93150.chisel.init.ChiselDataComponents;
import com.leclowndu93150.chisel.inventory.ChiselMenu;
import com.leclowndu93150.chisel.inventory.HitechChiselMenu;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ItemChisel
extends Item
implements IChiselItem {
    private final ChiselType type;

    public ItemChisel(ChiselType type, Item.Properties properties) {
        super(properties.durability(type.getMaxDamage()));
        this.type = type;
    }

    public ChiselType getChiselType() {
        return this.type;
    }

    public int getMaxDamage(ItemStack stack) {
        if (ChiselConfig.allowChiselDamage) {
            return this.type.getMaxDamage();
        }
        return 0;
    }

    public boolean isDamageable(ItemStack stack) {
        return ChiselConfig.allowChiselDamage;
    }

    public boolean isValidRepairItem(ItemStack damagedItem, ItemStack repairMaterial) {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1, 2 -> repairMaterial.is(Items.DIAMOND);
            case 0 -> repairMaterial.is(Items.IRON_INGOT);
        };
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"chisel.tooltip.gui").withStyle(ChatFormatting.GRAY));
        if (this.type.canLeftClick()) {
            tooltip.add((Component)Component.translatable((String)"chisel.tooltip.leftclick.1").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"chisel.tooltip.leftclick.2").withStyle(ChatFormatting.GRAY));
        }
        if (this.type.hasModes()) {
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"chisel.tooltip.modes").withStyle(ChatFormatting.GRAY));
            IChiselMode mode = this.getMode(stack);
            tooltip.add((Component)Component.translatable((String)"chisel.tooltip.selectedmode", (Object[])new Object[]{mode.getLocalizedName().copy().withStyle(ChatFormatting.GREEN)}).withStyle(ChatFormatting.GRAY));
        }
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)this.type.getAttackDamage(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, final InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching() && this.type.hasModes()) {
            if (!level.isClientSide) {
                this.cycleMode(stack, player, true);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        if (!level.isClientSide && this.canOpenGui(level, player, hand) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            IChiselItem.ChiselGuiType guiType = this.getGuiType(level, player, hand);
            if (guiType == IChiselItem.ChiselGuiType.HITECH) {
                serverPlayer.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"container.chisel.hitech");
                    }

                    public AbstractContainerMenu createMenu(int containerId, Inventory playerInv, Player p) {
                        return new HitechChiselMenu(containerId, playerInv, hand);
                    }
                }, buf -> buf.writeBoolean(hand == InteractionHand.MAIN_HAND));
            } else {
                serverPlayer.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"container.chisel");
                    }

                    public AbstractContainerMenu createMenu(int containerId, Inventory playerInv, Player p) {
                        return new ChiselMenu(containerId, playerInv, hand);
                    }
                }, buf -> buf.writeBoolean(hand == InteractionHand.MAIN_HAND));
            }
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public boolean canOpenGui(Level world, Player player, InteractionHand hand) {
        return true;
    }

    @Override
    public IChiselItem.ChiselGuiType getGuiType(Level world, Player player, InteractionHand hand) {
        return this.type == ChiselType.HITECH ? IChiselItem.ChiselGuiType.HITECH : IChiselItem.ChiselGuiType.NORMAL;
    }

    @Override
    public boolean onChisel(Level world, Player player, ItemStack chisel, Block target) {
        return ChiselConfig.allowChiselDamage;
    }

    @Override
    public boolean canChisel(Level world, Player player, ItemStack chisel, ItemStack target) {
        return !chisel.isEmpty() && CarvingHelper.canChisel(target);
    }

    @Override
    public boolean canChiselBlock(Level world, Player player, InteractionHand hand, BlockPos pos, BlockState state) {
        return this.type.canLeftClick() && CarvingHelper.canChisel(state);
    }

    @Override
    public boolean supportsMode(Player player, ItemStack chisel, IChiselMode mode) {
        if (this.type == ChiselType.HITECH) {
            return true;
        }
        if (this.type == ChiselType.DIAMOND || ChiselConfig.ironChiselHasModes) {
            return mode != ChiselMode.CONTIGUOUS && mode != ChiselMode.CONTIGUOUS_2D;
        }
        return mode == ChiselMode.SINGLE;
    }

    @Override
    public IChiselMode getMode(ItemStack stack) {
        IChiselMode mode;
        ChiselData data = (ChiselData)stack.get((DataComponentType)ChiselDataComponents.CHISEL_DATA.get());
        if (data != null && (mode = ChiselModeRegistry.INSTANCE.getModeByName(data.mode())) != null) {
            return mode;
        }
        return ChiselMode.SINGLE;
    }

    public void setMode(ItemStack stack, IChiselMode mode) {
        ChiselData data = (ChiselData)stack.getOrDefault((DataComponentType)ChiselDataComponents.CHISEL_DATA.get(), (Object)ChiselData.DEFAULT);
        stack.set((DataComponentType)ChiselDataComponents.CHISEL_DATA.get(), (Object)data.withMode(mode.name()));
    }

    public int getPreviewType(ItemStack stack) {
        ChiselData data = (ChiselData)stack.get((DataComponentType)ChiselDataComponents.CHISEL_DATA.get());
        return data != null ? data.previewType() : 0;
    }

    public void setPreviewType(ItemStack stack, int type) {
        ChiselData data = (ChiselData)stack.getOrDefault((DataComponentType)ChiselDataComponents.CHISEL_DATA.get(), (Object)ChiselData.DEFAULT);
        stack.set((DataComponentType)ChiselDataComponents.CHISEL_DATA.get(), (Object)data.withPreviewType(type));
    }

    public int getSelectionSlot(ItemStack stack) {
        ChiselData data = (ChiselData)stack.get((DataComponentType)ChiselDataComponents.CHISEL_DATA.get());
        return data != null ? data.selectionSlot() : -1;
    }

    public void setSelectionSlot(ItemStack stack, int slot) {
        ChiselData data = (ChiselData)stack.getOrDefault((DataComponentType)ChiselDataComponents.CHISEL_DATA.get(), (Object)ChiselData.DEFAULT);
        stack.set((DataComponentType)ChiselDataComponents.CHISEL_DATA.get(), (Object)data.withSelectionSlot(slot));
    }

    public int getTargetSlot(ItemStack stack) {
        ChiselData data = (ChiselData)stack.get((DataComponentType)ChiselDataComponents.CHISEL_DATA.get());
        return data != null ? data.targetSlot() : -1;
    }

    public void setTargetSlot(ItemStack stack, int slot) {
        ChiselData data = (ChiselData)stack.getOrDefault((DataComponentType)ChiselDataComponents.CHISEL_DATA.get(), (Object)ChiselData.DEFAULT);
        stack.set((DataComponentType)ChiselDataComponents.CHISEL_DATA.get(), (Object)data.withTargetSlot(slot));
    }

    public boolean getRotate(ItemStack stack) {
        ChiselData data = (ChiselData)stack.get((DataComponentType)ChiselDataComponents.CHISEL_DATA.get());
        return data != null && data.rotate();
    }

    public void setRotate(ItemStack stack, boolean rotate) {
        ChiselData data = (ChiselData)stack.getOrDefault((DataComponentType)ChiselDataComponents.CHISEL_DATA.get(), (Object)ChiselData.DEFAULT);
        stack.set((DataComponentType)ChiselDataComponents.CHISEL_DATA.get(), (Object)data.withRotate(rotate));
    }

    @Override
    public ItemStack getTarget(ItemStack stack) {
        ChiselData data = (ChiselData)stack.get((DataComponentType)ChiselDataComponents.CHISEL_DATA.get());
        return data != null ? data.target() : ItemStack.EMPTY;
    }

    public void setTarget(ItemStack stack, ItemStack target) {
        ChiselData data = (ChiselData)stack.getOrDefault((DataComponentType)ChiselDataComponents.CHISEL_DATA.get(), (Object)ChiselData.DEFAULT);
        stack.set((DataComponentType)ChiselDataComponents.CHISEL_DATA.get(), (Object)data.withTarget(target));
    }

    public void cycleMode(ItemStack stack, Player player, boolean forward) {
        IChiselMode current = this.getMode(stack);
        IChiselMode next = forward ? ChiselModeRegistry.INSTANCE.getNextMode(current) : ChiselModeRegistry.INSTANCE.getPreviousMode(current);
        while (next != current && !this.supportsMode(player, stack, next)) {
            if (forward) {
                next = ChiselModeRegistry.INSTANCE.getNextMode(next);
                continue;
            }
            next = ChiselModeRegistry.INSTANCE.getPreviousMode(next);
        }
        if (next != current) {
            this.setMode(stack, next);
            player.displayClientMessage((Component)Component.translatable((String)"chisel.message.mode_changed", (Object[])new Object[]{next.getLocalizedName()}), true);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    @Override
    public void openGui(Player player, final InteractionHand hand, ItemStack chisel) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            IChiselItem.ChiselGuiType guiType = this.getGuiType(player.level(), player, hand);
            if (guiType == IChiselItem.ChiselGuiType.HITECH) {
                serverPlayer.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"container.chisel.hitech");
                    }

                    public AbstractContainerMenu createMenu(int containerId, Inventory playerInv, Player p) {
                        return new HitechChiselMenu(containerId, playerInv, hand);
                    }
                }, buf -> buf.writeBoolean(hand == InteractionHand.MAIN_HAND));
            } else {
                serverPlayer.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"container.chisel");
                    }

                    public AbstractContainerMenu createMenu(int containerId, Inventory playerInv, Player p) {
                        return new ChiselMenu(containerId, playerInv, hand);
                    }
                }, buf -> buf.writeBoolean(hand == InteractionHand.MAIN_HAND));
            }
        }
    }

    public static enum ChiselType {
        IRON(false, false),
        DIAMOND(true, true),
        HITECH(true, true);

        private final boolean canLeftClick;
        private final boolean hasModes;

        private ChiselType(boolean canLeftClick, boolean hasModes) {
            this.canLeftClick = canLeftClick;
            this.hasModes = hasModes;
        }

        public int getMaxDamage() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> ChiselConfig.ironChiselMaxDamage;
                case 1 -> ChiselConfig.diamondChiselMaxDamage;
                case 2 -> ChiselConfig.hitechChiselMaxDamage;
            };
        }

        public int getAttackDamage() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> ChiselConfig.ironChiselAttackDamage;
                case 1 -> ChiselConfig.diamondChiselAttackDamage;
                case 2 -> ChiselConfig.hitechChiselAttackDamage;
            };
        }

        public boolean canLeftClick() {
            return this.canLeftClick || ChiselConfig.ironChiselCanLeftClick;
        }

        public boolean hasModes() {
            return this.hasModes || ChiselConfig.ironChiselHasModes;
        }
    }
}

