/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.baguettelib.network;

import com.leclowndu93150.baguettelib.network.NetworkManager;
import com.leclowndu93150.baguettelib.network.PacketContext;
import com.leclowndu93150.baguettelib.network.PacketDirection;
import com.leclowndu93150.baguettelib.network.PacketHandler;
import com.leclowndu93150.baguettelib.network.SimplePacketHandler;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class PacketBuilder<T extends CustomPacketPayload> {
    private final NetworkManager manager;
    private final Class<T> packetClass;
    private final String name;
    private final CustomPacketPayload.Type<T> type;
    private StreamCodec<RegistryFriendlyByteBuf, T> codec;
    private PacketDirection direction = PacketDirection.BIDIRECTIONAL;
    private PacketHandler<T> handler;

    PacketBuilder(NetworkManager manager, Class<T> packetClass, String name) {
        this.manager = manager;
        this.packetClass = packetClass;
        this.name = name;
        this.type = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)manager.modId, (String)name));
    }

    public PacketBuilder<T> codec(StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        this.codec = codec;
        return this;
    }

    public PacketBuilder<T> clientToServer() {
        this.direction = PacketDirection.CLIENT_TO_SERVER;
        return this;
    }

    public PacketBuilder<T> serverToClient() {
        this.direction = PacketDirection.SERVER_TO_CLIENT;
        return this;
    }

    public PacketBuilder<T> bidirectional() {
        this.direction = PacketDirection.BIDIRECTIONAL;
        return this;
    }

    public PacketBuilder<T> handler(PacketHandler<T> handler) {
        this.handler = handler;
        return this;
    }

    public PacketBuilder<T> handler(final SimplePacketHandler<T> handler) {
        this.handler = new PacketHandler<T>(){

            @Override
            public void handle(T packet, PacketContext context) {
                handler.handle(packet, context);
            }

            @Override
            public StreamCodec<RegistryFriendlyByteBuf, T> getCodec() {
                return PacketBuilder.this.codec;
            }

            @Override
            public PacketDirection getDirection() {
                return PacketBuilder.this.direction;
            }
        };
        return this;
    }

    public void build() {
        if (this.codec == null) {
            throw new IllegalStateException("Codec must be set");
        }
        if (this.handler == null) {
            throw new IllegalStateException("Handler must be set");
        }
        if (this.handler.getCodec() == null) {
            this.handler = new PacketHandler<T>(){

                @Override
                public void handle(T packet, PacketContext context) {
                    PacketBuilder.this.handler.handle(packet, context);
                }

                @Override
                public StreamCodec<RegistryFriendlyByteBuf, T> getCodec() {
                    return PacketBuilder.this.codec;
                }

                @Override
                public PacketDirection getDirection() {
                    return PacketBuilder.this.direction;
                }
            };
        }
        this.manager.registerPacketInternal(this.name, this.packetClass, this.type, this.codec, this.handler);
    }
}

