/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel;

import com.leclowndu93150.chisel.ChiselConfig;
import com.leclowndu93150.chisel.api.block.ChiselBlockType;
import com.leclowndu93150.chisel.api.block.ICarvable;
import com.leclowndu93150.chisel.block.BlockCarvableGlass;
import com.leclowndu93150.chisel.carving.ChiselMode;
import com.leclowndu93150.chisel.client.gui.AutoChiselScreen;
import com.leclowndu93150.chisel.client.gui.ChiselScreen;
import com.leclowndu93150.chisel.client.gui.HitechChiselScreen;
import com.leclowndu93150.chisel.client.particle.HolystoneStarParticle;
import com.leclowndu93150.chisel.compat.ChiselRebornCompat;
import com.leclowndu93150.chisel.init.ChiselBlockEntities;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import com.leclowndu93150.chisel.init.ChiselCreativeTabs;
import com.leclowndu93150.chisel.init.ChiselDataComponents;
import com.leclowndu93150.chisel.init.ChiselItems;
import com.leclowndu93150.chisel.init.ChiselMenus;
import com.leclowndu93150.chisel.init.ChiselParticles;
import com.leclowndu93150.chisel.init.ChiselRegistries;
import com.leclowndu93150.chisel.init.ChiselSounds;
import com.leclowndu93150.chisel.network.ChiselNetwork;
import com.mojang.logging.LogUtils;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="chisel")
public class Chisel {
    public static final String MODID = "chisel";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Chisel() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModContainer modContainer = ModLoadingContext.get().getContainer();
        modEventBus.addListener(this::commonSetup);
        ChiselRebornCompat.init();
        ChiselNetwork.register();
        ChiselRegistries.BLOCKS.register(modEventBus);
        ChiselRegistries.ITEMS.register(modEventBus);
        ChiselRegistries.CREATIVE_TABS.register(modEventBus);
        ChiselRegistries.BLOCK_ENTITY_TYPES.register(modEventBus);
        ChiselRegistries.MENU_TYPES.register(modEventBus);
        ChiselRegistries.SOUND_EVENTS.register(modEventBus);
        ChiselRegistries.PARTICLE_TYPES.register(modEventBus);
        ChiselSounds.init();
        ChiselParticles.init();
        ChiselBlocks.init();
        ChiselItems.init();
        ChiselMenus.init();
        ChiselCreativeTabs.init();
        ChiselDataComponents.init();
        ChiselBlockEntities.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ChiselConfig.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ChiselMode.registerAll();
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MODID, path);
    }

    @Mod.EventBusSubscriber(modid="chisel", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                ClientModEvents.registerBlockRenderType(ChiselBlocks.GLASS, RenderType.m_110463_());
                for (ChiselBlockType<BlockCarvableGlass> chiselBlockType : ChiselBlocks.GLASS_STAINED.values()) {
                    ClientModEvents.registerBlockRenderType(chiselBlockType, RenderType.m_110466_());
                }
                for (ChiselBlockType<BlockCarvableGlass> chiselBlockType : ChiselBlocks.GLASS_DYED.values()) {
                    ClientModEvents.registerBlockRenderType(chiselBlockType, RenderType.m_110466_());
                }
                for (ChiselBlockType<ICarvable> chiselBlockType : ChiselBlocks.GLASSPANE_DYED.values()) {
                    ClientModEvents.registerBlockRenderType(chiselBlockType, RenderType.m_110466_());
                }
                ClientModEvents.registerBlockRenderType(ChiselBlocks.IRONPANE, RenderType.m_110463_());
                ClientModEvents.registerBlockRenderType(ChiselBlocks.WATERSTONE, RenderType.m_110463_());
                ClientModEvents.registerBlockRenderType(ChiselBlocks.LAVASTONE, RenderType.m_110463_());
                ClientModEvents.registerBlockRenderType(ChiselBlocks.ANTIBLOCK, RenderType.m_110463_());
                ClientModEvents.registerBlockRenderType(ChiselBlocks.CLOUD, RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)ChiselBlocks.AUTO_CHISEL.get()), (RenderType)RenderType.m_110463_());
            });
        }

        private static void registerBlockRenderType(ChiselBlockType<?> blockType, RenderType renderType) {
            for (RegistryObject<?> registryObject : blockType.getAllBlocks()) {
                Block block = (Block)registryObject.get();
                ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderType);
            }
        }

        @SubscribeEvent
        public static void registerMenuScreens(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                MenuScreens.m_96206_((MenuType)((MenuType)ChiselMenus.CHISEL_MENU.get()), ChiselScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)ChiselMenus.HITECH_CHISEL_MENU.get()), HitechChiselScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)ChiselMenus.AUTO_CHISEL_MENU.get()), AutoChiselScreen::new);
            });
        }

        @SubscribeEvent
        public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ChiselParticles.HOLYSTONE_STAR.get(), HolystoneStarParticle.Provider::new);
        }
    }
}

