/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.api.carving;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.api.carving.ICarvingGroup;
import com.leclowndu93150.chisel.api.carving.IModeRegistry;
import com.leclowndu93150.chisel.carving.ChiselModeRegistry;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class CarvingUtils {
    @Nullable
    private static IModeRegistry modeRegistry;

    public static IModeRegistry getModeRegistry() {
        if (modeRegistry == null) {
            modeRegistry = ChiselModeRegistry.INSTANCE;
        }
        return modeRegistry;
    }

    public static boolean stacksEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.m_41728_((ItemStack)stack1, (ItemStack)stack2);
    }

    public static ICarvingGroup createGroup(ResourceLocation id, String displayName) {
        return CarvingUtils.createGroup(id, displayName, SoundEvents.f_12494_);
    }

    public static ICarvingGroup createGroup(final ResourceLocation id, final String displayName, final SoundEvent sound) {
        final TagKey blockTag = BlockTags.create((ResourceLocation)id);
        final TagKey itemTag = ItemTags.create((ResourceLocation)id);
        return new ICarvingGroup(){

            @Override
            public ResourceLocation getId() {
                return id;
            }

            @Override
            public String getTranslationKey() {
                return "chisel.group." + id.m_135815_().replace("/", ".");
            }

            @Override
            public Component getDisplayName() {
                return Component.m_237113_((String)displayName);
            }

            @Override
            public TagKey<Item> getItemTag() {
                return itemTag;
            }

            @Override
            public TagKey<Block> getBlockTag() {
                return blockTag;
            }

            @Override
            public SoundEvent getSound() {
                return sound;
            }
        };
    }

    public static ICarvingGroup createGroupForBlockType(String blockTypeName, String displayName) {
        return CarvingUtils.createGroup(Chisel.id("carving/" + blockTypeName.replace("/", "_")), displayName);
    }
}

