/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.api.chunkdata;

import com.leclowndu93150.chisel.api.chunkdata.IOffsetData;
import com.leclowndu93150.chisel.api.chunkdata.OffsetData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ChunkData {
    public static final String NBT_KEY = "chisel:offset_data";
    private static final IOffsetData DUMMY = pos -> BlockPos.f_121853_;
    private static final Map<Long, OffsetData> serverDataCache = new ConcurrentHashMap<Long, OffsetData>();
    private static final Map<Long, OffsetData> clientDataCache = new ConcurrentHashMap<Long, OffsetData>();

    private static Map<Long, OffsetData> getCache(Level level) {
        return level.m_5776_() ? clientDataCache : serverDataCache;
    }

    public static IOffsetData getOffsetData(BlockAndTintGetter world, BlockPos pos) {
        if (world == null || pos == null) {
            return DUMMY;
        }
        Level level = null;
        if (world instanceof Level) {
            Level lvl;
            level = lvl = (Level)world;
        } else if (world instanceof RenderChunkRegion) {
            RenderChunkRegion region = (RenderChunkRegion)world;
            level = region.f_112908_;
        }
        if (level == null) {
            return DUMMY;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        long key = ChunkData.getKey(chunkPos);
        OffsetData data = ChunkData.getCache(level).get(key);
        return data != null ? data : DUMMY;
    }

    public static OffsetData getOrCreateData(Level level, ChunkPos chunkPos) {
        long key = ChunkData.getKey(chunkPos);
        return ChunkData.getCache(level).computeIfAbsent(key, k -> new OffsetData());
    }

    public static OffsetData getData(Level level, ChunkPos chunkPos) {
        long key = ChunkData.getKey(chunkPos);
        return ChunkData.getCache(level).get(key);
    }

    public static void setData(Level level, ChunkPos chunkPos, OffsetData data) {
        long key = ChunkData.getKey(chunkPos);
        if (data == null || data.isEmpty()) {
            ChunkData.getCache(level).remove(key);
        } else {
            ChunkData.getCache(level).put(key, data);
        }
    }

    public static void removeData(Level level, ChunkPos chunkPos) {
        long key = ChunkData.getKey(chunkPos);
        ChunkData.getCache(level).remove(key);
    }

    public static void clearDataForLevel(Level level) {
        ChunkData.getCache(level).clear();
    }

    public static void clearAll() {
        serverDataCache.clear();
        clientDataCache.clear();
    }

    private static long getKey(ChunkPos pos) {
        return pos.m_45588_();
    }
}

