/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.api.chunkdata;

import com.leclowndu93150.chisel.api.chunkdata.IOffsetData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class OffsetData
implements IOffsetData {
    private final Map<BlockPos, BlockPos> offsets = new HashMap<BlockPos, BlockPos>();

    @Override
    public BlockPos getOffset(BlockPos pos) {
        return this.offsets.getOrDefault(this.toChunkLocal(pos), BlockPos.f_121853_);
    }

    public void setOffset(BlockPos pos, BlockPos offset) {
        BlockPos local = this.toChunkLocal(pos);
        if (offset.equals((Object)BlockPos.f_121853_)) {
            this.offsets.remove(local);
        } else {
            this.offsets.put(local, this.wrap(offset));
        }
    }

    public void move(BlockPos pos, Direction dir) {
        BlockPos local = this.toChunkLocal(pos);
        BlockPos current = this.offsets.getOrDefault(local, BlockPos.f_121853_);
        BlockPos newOffset = this.wrap(current.m_121945_(dir.m_122424_()));
        if (newOffset.equals((Object)BlockPos.f_121853_)) {
            this.offsets.remove(local);
        } else {
            this.offsets.put(local, newOffset);
        }
    }

    public void setOffsetForAll(Set<BlockPos> positions, BlockPos offset) {
        BlockPos wrapped = this.wrap(offset);
        for (BlockPos pos : positions) {
            BlockPos local = this.toChunkLocal(pos);
            if (wrapped.equals((Object)BlockPos.f_121853_)) {
                this.offsets.remove(local);
                continue;
            }
            this.offsets.put(local, wrapped);
        }
    }

    public void moveAll(Set<BlockPos> positions, Direction dir) {
        BlockPos firstLocal = null;
        Iterator<BlockPos> iterator = positions.iterator();
        if (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            firstLocal = this.toChunkLocal(pos);
        }
        if (firstLocal == null) {
            return;
        }
        BlockPos current = this.offsets.getOrDefault(firstLocal, BlockPos.f_121853_);
        BlockPos newOffset = this.wrap(current.m_121945_(dir.m_122424_()));
        for (BlockPos pos : positions) {
            BlockPos local = this.toChunkLocal(pos);
            if (newOffset.equals((Object)BlockPos.f_121853_)) {
                this.offsets.remove(local);
                continue;
            }
            this.offsets.put(local, newOffset);
        }
    }

    public boolean isEmpty() {
        return this.offsets.isEmpty();
    }

    private BlockPos toChunkLocal(BlockPos pos) {
        return new BlockPos(pos.m_123341_() & 0xF, pos.m_123342_(), pos.m_123343_() & 0xF);
    }

    private int positiveModulo(int num, int denom) {
        return (num % denom + denom) % denom;
    }

    private BlockPos wrap(BlockPos pos) {
        return new BlockPos(this.positiveModulo(pos.m_123341_(), 16), this.positiveModulo(pos.m_123342_(), 16), this.positiveModulo(pos.m_123343_(), 16));
    }

    public void writeToNBT(CompoundTag tag) {
        if (this.offsets.isEmpty()) {
            return;
        }
        ListTag list = new ListTag();
        for (Map.Entry<BlockPos, BlockPos> entry : this.offsets.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            BlockPos pos = entry.getKey();
            BlockPos offset = entry.getValue();
            entryTag.m_128405_("pos", pos.m_123341_() << 28 | (pos.m_123342_() & 0xFFFFFF) << 4 | pos.m_123343_());
            entryTag.m_128376_("off", (short)(offset.m_123341_() << 8 | offset.m_123342_() << 4 | offset.m_123343_()));
            list.add((Object)entryTag);
        }
        tag.m_128365_("offsets", (Tag)list);
    }

    public void readFromNBT(CompoundTag tag) {
        this.offsets.clear();
        if (!tag.m_128425_("offsets", 9)) {
            return;
        }
        ListTag list = tag.m_128437_("offsets", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entryTag = list.m_128728_(i);
            int packedPos = entryTag.m_128451_("pos");
            int x = packedPos >> 28 & 0xF;
            int y = packedPos >> 4 & 0xFFFFFF;
            int z = packedPos & 0xF;
            if ((y & 0x800000) != 0) {
                y |= 0xFF000000;
            }
            BlockPos pos = new BlockPos(x, y, z);
            short packedOffset = entryTag.m_128448_("off");
            BlockPos offset = new BlockPos(packedOffset >> 8 & 0xF, packedOffset >> 4 & 0xF, packedOffset & 0xF);
            this.offsets.put(pos, offset);
        }
    }

    public OffsetData copy() {
        OffsetData copy = new OffsetData();
        copy.offsets.putAll(this.offsets);
        return copy;
    }
}

