/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.block.entity;

import com.leclowndu93150.chisel.ChiselConfig;
import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.init.ChiselBlockEntities;
import com.leclowndu93150.chisel.inventory.AutoChiselMenu;
import com.leclowndu93150.chisel.network.ChiselNetwork;
import com.leclowndu93150.chisel.network.client.AutoChiselFXPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class AutoChiselBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    public static final int INPUT_SLOTS = 12;
    public static final int OUTPUT_SLOTS = 12;
    private static final int MAX_PROGRESS = 1024;
    private static final int BASE_PROGRESS = 16;
    private static final int SPEEDUP_PROGRESS = 64;
    private static final int POWER_PER_TICK = 20;
    private static final int MAX_ENERGY = 10000;
    private final ItemStackHandler chiselSlot = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() instanceof IChiselItem;
        }

        protected void onContentsChanged(int slot) {
            AutoChiselBlockEntity.this.m_6596_();
        }
    };
    private final ItemStackHandler targetSlot = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return CarvingHelper.canChisel(stack);
        }

        protected void onContentsChanged(int slot) {
            AutoChiselBlockEntity.this.m_6596_();
        }
    };
    private final ItemStackHandler inputInv = new ItemStackHandler(12){

        public boolean isItemValid(int slot, ItemStack stack) {
            return CarvingHelper.canChisel(stack);
        }

        protected void onContentsChanged(int slot) {
            AutoChiselBlockEntity.this.m_6596_();
        }
    };
    private final ItemStackHandler outputInv = new ItemStackHandler(12){

        protected void onContentsChanged(int slot) {
            AutoChiselBlockEntity.this.m_6596_();
        }
    };
    private final EnergyStorage energyStorage = new EnergyStorage(10000, 40, 20);
    private int progress = 0;
    private int sourceSlot = -1;
    private Component customName;
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> {
                    if (AutoChiselBlockEntity.this.sourceSlot >= 0) {
                        yield 1;
                    }
                    yield 0;
                }
                case 1 -> AutoChiselBlockEntity.this.progress;
                case 2 -> 1024;
                case 3 -> AutoChiselBlockEntity.this.energyStorage.getEnergyStored();
                case 4 -> AutoChiselBlockEntity.this.energyStorage.getMaxEnergyStored();
                case 5 -> AutoChiselBlockEntity.this.getUsagePerTick();
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
        }

        public int m_6499_() {
            return 6;
        }
    };
    private final LazyOptional<IItemHandler> itemHandlerTop = LazyOptional.of(() -> this.inputInv);
    private final LazyOptional<IItemHandler> itemHandlerBottom = LazyOptional.of(() -> this.outputInv);
    private final LazyOptional<IItemHandler> itemHandlerSides = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInv, this.outputInv}));
    private final LazyOptional<IItemHandler> itemHandlerAll = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInv, this.outputInv, this.chiselSlot, this.targetSlot}));
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);

    public AutoChiselBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ChiselBlockEntities.AUTO_CHISEL.get(), pos, state);
    }

    public void tick() {
        ItemStack result;
        TagKey<Item> sourceGroup;
        TagKey<Item> targetGroup;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.energyStorage.getEnergyStored() == 0 && ChiselConfig.autoChiselNeedsPower) {
            return;
        }
        ItemStack target = this.targetSlot.getStackInSlot(0);
        ItemStack chisel = this.chiselSlot.getStackInSlot(0);
        ItemStack source = this.sourceSlot >= 0 ? this.inputInv.getStackInSlot(this.sourceSlot) : ItemStack.f_41583_;
        TagKey<Item> tagKey = targetGroup = target.m_41619_() || chisel.m_41619_() ? null : CarvingHelper.getCarvingGroupForItem(target);
        if (chisel.m_41619_() || targetGroup == null) {
            this.sourceSlot = -1;
            this.progress = 0;
            return;
        }
        if (!(source.m_41619_() || (sourceGroup = CarvingHelper.getCarvingGroupForItem(source)) != null && sourceGroup.equals(targetGroup))) {
            source = ItemStack.f_41583_;
        }
        if (this.sourceSlot < 0 && this.f_58857_.m_46467_() % 20L == 0L || this.sourceSlot >= 0) {
            if (source.m_41619_()) {
                this.sourceSlot = -1;
            }
            result = new ItemStack((ItemLike)target.m_41720_());
            if (!source.m_41619_()) {
                result.m_41764_(source.m_41613_());
            }
            if (source.m_41619_() || this.canOutput(result)) {
                for (int i = 0; this.sourceSlot < 0 && i < this.inputInv.getSlots(); ++i) {
                    TagKey<Item> stackGroup;
                    ItemStack stack = this.inputInv.getStackInSlot(i);
                    if (stack.m_41619_() || (stackGroup = CarvingHelper.getCarvingGroupForItem(stack)) == null || !stackGroup.equals(targetGroup)) continue;
                    result.m_41764_(stack.m_41613_());
                    if (!this.canOutput(result)) continue;
                    this.sourceSlot = i;
                    source = stack.m_41777_();
                }
            } else {
                this.sourceSlot = -1;
            }
        }
        if (this.sourceSlot >= 0) {
            source = this.inputInv.getStackInSlot(this.sourceSlot);
            if (!ItemStack.m_41656_((ItemStack)source, (ItemStack)target)) {
                if (this.progress < 1024) {
                    if (!ChiselConfig.autoChiselNeedsPower) {
                        this.progress = Math.min(1024, this.progress + 16);
                    }
                    int toUse = Math.min(1024 - this.progress, this.getPowerProgressPerTick());
                    int powerToUse = this.getUsagePerTick();
                    if (toUse > 0 && powerToUse > 0) {
                        if (ChiselConfig.autoChiselPowered) {
                            int used = this.energyStorage.extractEnergy(powerToUse, false);
                            this.progress += (int)((float)toUse * ((float)used / (float)powerToUse));
                        } else {
                            this.progress += toUse;
                        }
                    }
                } else {
                    result = new ItemStack((ItemLike)target.m_41720_(), source.m_41613_());
                    this.inputInv.setStackInSlot(this.sourceSlot, ItemStack.f_41583_);
                    if (ChiselConfig.allowChiselDamage && chisel.m_41763_()) {
                        chisel.m_41721_(chisel.m_41773_() + 1);
                        if (chisel.m_41773_() >= chisel.m_41776_()) {
                            this.chiselSlot.setStackInSlot(0, ItemStack.f_41583_);
                        }
                    }
                    this.mergeOutput(result);
                    Level used = this.f_58857_;
                    if (used instanceof ServerLevel) {
                        BlockState blockState;
                        ServerLevel serverLevel = (ServerLevel)used;
                        Item item = result.m_41720_();
                        if (item instanceof BlockItem) {
                            BlockItem blockItem = (BlockItem)item;
                            blockState = blockItem.m_40614_().m_49966_();
                        } else {
                            blockState = Blocks.f_50069_.m_49966_();
                        }
                        BlockState resultState = blockState;
                        ChiselNetwork.sendToAllTrackingChunk((LevelChunk)serverLevel.m_46865_(this.f_58858_), new AutoChiselFXPacket(this.f_58858_, chisel.m_41777_(), resultState));
                    }
                    this.sourceSlot = (this.sourceSlot + 1) % this.inputInv.getSlots();
                    this.progress = 0;
                }
            } else {
                this.inputInv.setStackInSlot(this.sourceSlot, ItemStack.f_41583_);
                this.mergeOutput(source);
            }
        } else {
            this.progress = 0;
        }
    }

    private float getSpeedFactor() {
        return ChiselConfig.autoChiselPowered ? (float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored() : 1.0f;
    }

    private int getPowerProgressPerTick() {
        int maxPerTick = ChiselConfig.autoChiselNeedsPower ? 80 : 64;
        return (int)Math.ceil(this.getSpeedFactor() * (float)maxPerTick);
    }

    private int getUsagePerTick() {
        return (int)Math.ceil(this.getSpeedFactor() * 20.0f);
    }

    private boolean canOutput(ItemStack stack) {
        ItemStack remaining = stack.m_41777_();
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (!(remaining = this.outputInv.insertItem(i, remaining, true)).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private void mergeOutput(ItemStack stack) {
        for (int i = 0; i < this.outputInv.getSlots() && !stack.m_41619_(); ++i) {
            stack = this.outputInv.insertItem(i, stack, false);
        }
    }

    public void dropContents(Level level, BlockPos pos) {
        int i;
        for (i = 0; i < this.inputInv.getSlots(); ++i) {
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.inputInv.getStackInSlot(i));
        }
        for (i = 0; i < this.outputInv.getSlots(); ++i) {
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.outputInv.getStackInSlot(i));
        }
        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.chiselSlot.getStackInSlot(0));
        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.targetSlot.getStackInSlot(0));
    }

    public ItemStackHandler getChiselSlot() {
        return this.chiselSlot;
    }

    public ItemStackHandler getTargetSlot() {
        return this.targetSlot;
    }

    public ItemStackHandler getInputInv() {
        return this.inputInv;
    }

    public ItemStackHandler getOutputInv() {
        return this.outputInv;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("chisel", (Tag)this.chiselSlot.serializeNBT());
        tag.m_128365_("target", (Tag)this.targetSlot.serializeNBT());
        tag.m_128365_("input", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("output", (Tag)this.outputInv.serializeNBT());
        tag.m_128405_("energy", this.energyStorage.getEnergyStored());
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("source", this.sourceSlot);
        if (this.customName != null) {
            tag.m_128359_("customName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.chiselSlot.deserializeNBT(tag.m_128469_("chisel"));
        this.targetSlot.deserializeNBT(tag.m_128469_("target"));
        this.inputInv.deserializeNBT(tag.m_128469_("input"));
        this.outputInv.deserializeNBT(tag.m_128469_("output"));
        this.energyStorage.receiveEnergy(tag.m_128451_("energy") - this.energyStorage.getEnergyStored(), false);
        this.progress = tag.m_128451_("progress");
        this.sourceSlot = tag.m_128451_("source");
        if (tag.m_128441_("customName")) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("customName"));
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public Component m_5446_() {
        return this.m_8077_() ? this.m_7770_() : this.m_7755_();
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.m_58900_().m_60734_().m_49954_();
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInv, Player player) {
        return new AutoChiselMenu(containerId, playerInv, this, this.dataAccess, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.DOWN) {
                return this.itemHandlerBottom.cast();
            }
            if (side == Direction.UP) {
                return this.itemHandlerTop.cast();
            }
            if (side == null) {
                return this.itemHandlerAll.cast();
            }
            return this.itemHandlerSides.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerTop.invalidate();
        this.itemHandlerBottom.invalidate();
        this.itemHandlerSides.invalidate();
        this.itemHandlerAll.invalidate();
        this.energyHandler.invalidate();
    }
}

