/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.carving;

import com.leclowndu93150.chisel.api.ChiselSound;
import com.leclowndu93150.chisel.api.block.ChiselBlockType;
import com.leclowndu93150.chisel.compat.kubejs.KubeJSCompat;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public class CarvingHelper {
    @Nullable
    public static TagKey<Block> getCarvingGroup(BlockState state) {
        Block block = state.m_60734_();
        ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        for (ResourceLocation tagId : BuiltInRegistries.f_256975_.m_203613_().filter(tag -> tag.f_203868_().m_135827_().equals("chisel") && tag.f_203868_().m_135815_().startsWith("carving/")).map(TagKey::f_203868_).toList()) {
            Boolean include;
            TagKey tag2 = BlockTags.create((ResourceLocation)tagId);
            if (!state.m_204336_(tag2) || (include = KubeJSCompat.shouldIncludeBlock((TagKey<Block>)tag2, block)) != null && !include.booleanValue()) continue;
            return tag2;
        }
        TagKey<Block> kubeGroup = KubeJSCompat.getGroupForBlock(block);
        if (kubeGroup != null) {
            return kubeGroup;
        }
        return null;
    }

    @Nullable
    public static TagKey<Item> getCarvingGroupForItem(ItemStack stack) {
        TagKey<Block> kubeGroup;
        Item item = stack.m_41720_();
        for (ResourceLocation tagId : BuiltInRegistries.f_257033_.m_203613_().filter(tag -> tag.f_203868_().m_135827_().equals("chisel") && tag.f_203868_().m_135815_().startsWith("carving/")).map(TagKey::f_203868_).toList()) {
            TagKey tag2 = ItemTags.create((ResourceLocation)tagId);
            if (!stack.m_204117_(tag2)) continue;
            Block block = Block.m_49814_((Item)item);
            TagKey blockTag = BlockTags.create((ResourceLocation)tagId);
            Boolean include = KubeJSCompat.shouldIncludeBlock((TagKey<Block>)blockTag, block);
            if (include != null && !include.booleanValue()) continue;
            return tag2;
        }
        Block block = Block.m_49814_((Item)item);
        if (block != null && (kubeGroup = KubeJSCompat.getGroupForBlock(block)) != null) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)kubeGroup.f_203868_());
        }
        return null;
    }

    public static List<Block> getBlocksInGroup(TagKey<Block> groupTag) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        BuiltInRegistries.f_256975_.m_203431_(groupTag).ifPresent(tag -> tag.forEach(holder -> {
            Block block = (Block)holder.m_203334_();
            Boolean include = KubeJSCompat.shouldIncludeBlock(groupTag, block);
            if (include == null || include.booleanValue()) {
                blocks.add(block);
            }
        }));
        for (ResourceLocation blockId : KubeJSCompat.getAdditionalBlocks(groupTag)) {
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockId);
            if (block == null || blocks.contains(block)) continue;
            blocks.add(block);
        }
        return blocks;
    }

    public static List<Item> getItemsInGroup(TagKey<Item> groupTag) {
        TagKey blockTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)groupTag.f_203868_());
        ArrayList<Item> items = new ArrayList<Item>();
        BuiltInRegistries.f_257033_.m_203431_(groupTag).ifPresent(tag -> tag.forEach(holder -> {
            Item item = (Item)holder.m_203334_();
            Block block = Block.m_49814_((Item)item);
            Boolean include = KubeJSCompat.shouldIncludeBlock((TagKey<Block>)blockTag, block);
            if (include == null || include.booleanValue()) {
                items.add(item);
            }
        }));
        for (ResourceLocation blockId : KubeJSCompat.getAdditionalBlocks((TagKey<Block>)blockTag)) {
            Item item;
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockId);
            if (block == null || (item = block.m_5456_()) == Items.f_41852_ || items.contains(item)) continue;
            items.add(item);
        }
        return items;
    }

    @Nullable
    public static Block getNextVariant(BlockState currentState) {
        TagKey<Block> group = CarvingHelper.getCarvingGroup(currentState);
        if (group == null) {
            return null;
        }
        List<Block> blocks = CarvingHelper.getBlocksInGroup(group);
        if (blocks.isEmpty()) {
            return null;
        }
        Block currentBlock = currentState.m_60734_();
        int currentIndex = blocks.indexOf(currentBlock);
        if (currentIndex == -1) {
            return blocks.get(0);
        }
        return blocks.get((currentIndex + 1) % blocks.size());
    }

    @Nullable
    public static Block getPreviousVariant(BlockState currentState) {
        TagKey<Block> group = CarvingHelper.getCarvingGroup(currentState);
        if (group == null) {
            return null;
        }
        List<Block> blocks = CarvingHelper.getBlocksInGroup(group);
        if (blocks.isEmpty()) {
            return null;
        }
        Block currentBlock = currentState.m_60734_();
        int currentIndex = blocks.indexOf(currentBlock);
        if (currentIndex == -1) {
            return blocks.get(blocks.size() - 1);
        }
        return blocks.get((currentIndex - 1 + blocks.size()) % blocks.size());
    }

    @Nullable
    public static Block getVariantByIndex(BlockState currentState, int index) {
        TagKey<Block> group = CarvingHelper.getCarvingGroup(currentState);
        if (group == null) {
            return null;
        }
        List<Block> blocks = CarvingHelper.getBlocksInGroup(group);
        if (blocks.isEmpty() || index < 0 || index >= blocks.size()) {
            return null;
        }
        return blocks.get(index);
    }

    public static boolean areInSameGroup(BlockState state1, BlockState state2) {
        TagKey<Block> group1 = CarvingHelper.getCarvingGroup(state1);
        TagKey<Block> group2 = CarvingHelper.getCarvingGroup(state2);
        if (group1 == null || group2 == null) {
            return false;
        }
        return group1.f_203868_().equals((Object)group2.f_203868_());
    }

    public static void playChiselSound(Level level, Player player) {
        CarvingHelper.playChiselSound(level, player, ChiselSound.FALLBACK);
    }

    public static void playChiselSound(Level level, Player player, Block block) {
        ChiselSound sound = CarvingHelper.getChiselSoundForBlock(block);
        CarvingHelper.playChiselSound(level, player, sound);
    }

    public static void playChiselSound(Level level, Player player, ChiselSound chiselSound) {
        if (chiselSound == null) {
            chiselSound = ChiselSound.FALLBACK;
        }
        float randomValue = level.f_46441_.m_188501_();
        level.m_5594_(null, player.m_20183_(), chiselSound.getSound(), SoundSource.PLAYERS, chiselSound.getVolume(randomValue), chiselSound.getPitch(randomValue));
    }

    @Nullable
    public static ChiselSound getChiselSoundForBlock(Block block) {
        for (ChiselBlockType<?> blockType : ChiselBlocks.ALL_BLOCK_TYPES) {
            for (RegistryObject<?> deferredBlock : blockType.getAllBlocks()) {
                if (deferredBlock.get() != block) continue;
                ChiselSound sound = blockType.getChiselSound();
                return sound != null ? sound : ChiselSound.FALLBACK;
            }
        }
        return ChiselSound.FALLBACK;
    }

    public static boolean canChisel(BlockState state) {
        return CarvingHelper.getCarvingGroup(state) != null;
    }

    public static boolean canChisel(ItemStack stack) {
        return CarvingHelper.getCarvingGroupForItem(stack) != null;
    }

    @Nullable
    public static TagKey<Item> getCarvingGroupForBlock(Block block) {
        Item item = block.m_5456_();
        if (item == Items.f_41852_) {
            return null;
        }
        return CarvingHelper.getCarvingGroupForItem(new ItemStack((ItemLike)item));
    }
}

