/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.client.gui;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.api.carving.IChiselMode;
import com.leclowndu93150.chisel.carving.ChiselModeRegistry;
import com.leclowndu93150.chisel.client.gui.ButtonChiselMode;
import com.leclowndu93150.chisel.inventory.ChiselMenu;
import com.leclowndu93150.chisel.inventory.SlotChiselInput;
import com.leclowndu93150.chisel.item.ItemChisel;
import com.leclowndu93150.chisel.network.ChiselNetwork;
import com.leclowndu93150.chisel.network.server.ChiselModePacket;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ChiselScreen
extends AbstractContainerScreen<ChiselMenu> {
    private static final ResourceLocation TEXTURE = Chisel.id("textures/gui/chisel2gui.png");
    public static final int GUI_WIDTH = 252;
    public static final int GUI_HEIGHT = 202;

    public ChiselScreen(ChiselMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.f_97726_ = 252;
        this.f_97727_ = 202;
    }

    protected void m_7856_() {
        ItemChisel itemChisel;
        super.m_7856_();
        ItemStack chisel = ((ChiselMenu)this.f_97732_).getChisel();
        Item item = chisel.m_41720_();
        if (item instanceof ItemChisel && (itemChisel = (ItemChisel)item).getChiselType().hasModes()) {
            this.addModeButtons();
        }
    }

    private void addModeButtons() {
        Rect2i area = this.getModeButtonArea();
        int buttonsPerRow = area.m_110090_() / 20;
        int padding = (area.m_110090_() - buttonsPerRow * 20) / Math.max(1, buttonsPerRow);
        int id = 0;
        ItemStack chisel = ((ChiselMenu)this.f_97732_).getChisel();
        IChiselMode currentMode = null;
        Item item = chisel.m_41720_();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            currentMode = itemChisel.getMode(chisel);
        }
        for (IChiselMode mode : ChiselModeRegistry.INSTANCE.getAllModes()) {
            ItemChisel itemChisel;
            Item item2 = chisel.m_41720_();
            if (item2 instanceof ItemChisel && !(itemChisel = (ItemChisel)item2).supportsMode((Player)this.f_96541_.f_91074_, chisel, mode)) continue;
            int x = area.m_110085_() + padding / 2 + id % buttonsPerRow * (20 + padding);
            int y = area.m_110086_() + id / buttonsPerRow * (20 + padding);
            IChiselMode finalMode = mode;
            ButtonChiselMode button = new ButtonChiselMode(x, y, 20, 20, mode, b -> {
                this.onModeButtonClick(finalMode);
                b.f_93623_ = false;
                for (Renderable other : this.f_169369_) {
                    if (other == b || !(other instanceof ButtonChiselMode)) continue;
                    ButtonChiselMode b2 = (ButtonChiselMode)other;
                    b2.f_93623_ = true;
                }
            });
            if (mode == currentMode) {
                button.f_93623_ = false;
            }
            this.m_142416_((GuiEventListener)button);
            ++id;
        }
    }

    protected Rect2i getModeButtonArea() {
        int down = 73;
        int padding = 7;
        return new Rect2i(this.f_97735_ + padding, this.f_97736_ + down + padding, 50, this.f_97727_ - down - padding * 2);
    }

    private void onModeButtonClick(IChiselMode mode) {
        ItemStack chisel = ((ChiselMenu)this.f_97732_).getChisel();
        Item item = chisel.m_41720_();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            itemChisel.setMode(chisel, mode);
            int slot = ((ChiselMenu)this.f_97732_).getHand() == InteractionHand.MAIN_HAND ? this.f_96541_.f_91074_.m_150109_().f_35977_ : 40;
            ChiselNetwork.sendToServer(new ChiselModePacket(slot, mode));
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        SlotChiselInput inputSlot = ((ChiselMenu)this.f_97732_).getInputSlot();
        if (inputSlot.m_7993_().m_41619_()) {
            graphics.m_280218_(TEXTURE, this.f_97735_ + inputSlot.f_40220_ - 16, this.f_97736_ + inputSlot.f_40221_ - 16, 0, this.f_97727_, 48, 48);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        List lines = this.f_96547_.m_92923_((FormattedText)this.f_96539_, 40);
        int y = 60;
        for (FormattedCharSequence s : lines) {
            graphics.m_280649_(this.f_96547_, s, 32 - this.f_96547_.m_92724_(s) / 2, y, 0x404040, false);
            y += 10;
        }
        this.drawButtonTooltips(graphics, mouseX, mouseY);
    }

    protected void drawButtonTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        for (Renderable widget : this.f_169369_) {
            ButtonChiselMode button;
            if (!(widget instanceof ButtonChiselMode) || !(button = (ButtonChiselMode)widget).m_274382_()) continue;
            IChiselMode mode = button.getMode();
            List<MutableComponent> ttLines = List.of(mode.getLocalizedName(), mode.getLocalizedDescription().m_6881_().m_130940_(ChatFormatting.GRAY));
            graphics.m_280666_(this.f_96547_, ttLines, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    protected boolean m_6774_(int x, int y, int width, int height, double mouseX, double mouseY) {
        SlotChiselInput inputSlot = ((ChiselMenu)this.f_97732_).getInputSlot();
        if (x == inputSlot.f_40220_ && y == inputSlot.f_40221_ && width == 16 && height == 16) {
            return super.m_6774_(x - 8, y - 8, 32, 32, mouseX, mouseY);
        }
        return super.m_6774_(x, y, width, height, mouseX, mouseY);
    }

    public void m_280092_(GuiGraphics graphics, Slot slot) {
        if (slot == ((ChiselMenu)this.f_97732_).getInputSlot()) {
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            float centerX = slot.f_40220_ + 8;
            float centerY = slot.f_40221_ + 8;
            poseStack.m_252880_(centerX, centerY, 0.0f);
            poseStack.m_85841_(2.0f, 2.0f, 1.0f);
            poseStack.m_252880_(-centerX, -centerY, 0.0f);
            super.m_280092_(graphics, slot);
            poseStack.m_85849_();
        } else {
            super.m_280092_(graphics, slot);
        }
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280072_(graphics, mouseX, mouseY);
    }
}

