/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.client.gui;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.api.carving.IChiselMode;
import com.leclowndu93150.chisel.carving.ChiselModeRegistry;
import com.leclowndu93150.chisel.client.gui.ButtonChiselMode;
import com.leclowndu93150.chisel.client.gui.PreviewBlockGetter;
import com.leclowndu93150.chisel.inventory.HitechChiselMenu;
import com.leclowndu93150.chisel.inventory.SlotChiselInput;
import com.leclowndu93150.chisel.item.ItemChisel;
import com.leclowndu93150.chisel.network.ChiselNetwork;
import com.leclowndu93150.chisel.network.server.ChiselButtonPacket;
import com.leclowndu93150.chisel.network.server.ChiselModePacket;
import com.leclowndu93150.chisel.network.server.HitechSettingsPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class HitechChiselScreen
extends AbstractContainerScreen<HitechChiselMenu> {
    private static final ResourceLocation TEXTURE = Chisel.id("textures/gui/chiselguihitech.png");
    public static final int GUI_WIDTH = 256;
    public static final int GUI_HEIGHT = 220;
    private static final int PREVIEW_X = 8;
    private static final int PREVIEW_Y = 14;
    private static final int PREVIEW_WIDTH = 74;
    private static final int PREVIEW_HEIGHT = 74;
    private static final int PREVIEW_BUTTON_X = 7;
    private static final int PREVIEW_BUTTON_Y = 91;
    private static final int CHISEL_BUTTON_Y = 113;
    private static final int BUTTON_WIDTH = 76;
    private static final int BUTTON_HEIGHT = 20;
    private static final int HIGHLIGHT_SELECTION_U = 0;
    private static final int HIGHLIGHT_DUPLICATE_U = 18;
    private static final int HIGHLIGHT_TARGET_U = 36;
    private static final int HIGHLIGHT_V = 220;
    private float rotX = 25.0f;
    private float rotY = -45.0f;
    private float zoom = 1.0f;
    private float initRotX;
    private float initRotY;
    private float initZoom;
    private float prevRotX;
    private float prevRotY;
    private double momentumX = 0.0;
    private double momentumY = 0.0;
    private PreviewMode previewMode = PreviewMode.PANEL;
    private boolean autoRotate = true;
    private boolean panelClicked = false;
    private int clickButton;
    private int clickX;
    private int clickY;
    private long lastDragTime;
    private Button chiselButton;

    public HitechChiselScreen(HitechChiselMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.f_97726_ = 256;
        this.f_97727_ = 220;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getPreviewModeText(), this::onPreviewModeClick).m_252987_(this.f_97735_ + 7, this.f_97736_ + 91, 76, 20).m_253136_());
        this.chiselButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"chisel.button.chisel"), this::onChiselClick).m_252987_(this.f_97735_ + 7, this.f_97736_ + 113, 76, 20).build(builder -> new Button((Button.Builder)builder){

            public void m_7435_(SoundManager handler) {
            }
        }));
        this.addModeButtons();
        ItemStack chisel = ((HitechChiselMenu)this.f_97732_).getChisel();
        Item item = chisel.m_41720_();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            this.previewMode = PreviewMode.values()[Math.min(itemChisel.getPreviewType(chisel), PreviewMode.values().length - 1)];
            this.autoRotate = itemChisel.getRotate(chisel);
        }
    }

    private Component getPreviewModeText() {
        return Component.m_237113_((String)"< ").m_7220_((Component)Component.m_237115_((String)("chisel.preview." + this.previewMode.name().toLowerCase()))).m_130946_(" >");
    }

    private void addModeButtons() {
        int buttonX = this.f_97735_ + 7;
        int buttonY = this.f_97736_ + 140;
        int modesAdded = 0;
        ItemStack chisel = ((HitechChiselMenu)this.f_97732_).getChisel();
        IChiselMode currentMode = null;
        Item item = chisel.m_41720_();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            currentMode = itemChisel.getMode(chisel);
        }
        for (IChiselMode mode : ChiselModeRegistry.INSTANCE.getAllModes()) {
            ItemChisel itemChisel;
            Item item2 = chisel.m_41720_();
            if (item2 instanceof ItemChisel && !(itemChisel = (ItemChisel)item2).supportsMode((Player)this.f_96541_.f_91074_, chisel, mode)) continue;
            IChiselMode finalMode = mode;
            ButtonChiselMode button = new ButtonChiselMode(buttonX + modesAdded % 2 * 38, buttonY + modesAdded / 2 * 22, 20, 20, mode, b -> this.onModeButtonClick(finalMode));
            if (mode == currentMode) {
                button.f_93623_ = false;
            }
            this.m_142416_((GuiEventListener)button);
            ++modesAdded;
        }
    }

    private int getChiselSlot() {
        return ((HitechChiselMenu)this.f_97732_).getHand() == InteractionHand.MAIN_HAND ? this.f_96541_.f_91074_.m_150109_().f_35977_ : 40;
    }

    private void onPreviewModeClick(Button button) {
        this.previewMode = PreviewMode.values()[(this.previewMode.ordinal() + 1) % PreviewMode.values().length];
        button.m_93666_(this.getPreviewModeText());
        this.saveSettings();
    }

    private void onChiselClick(Button button) {
        int[] slots;
        Slot selection = ((HitechChiselMenu)this.f_97732_).getSelection();
        Slot target = ((HitechChiselMenu)this.f_97732_).getTarget();
        if (selection == null || !selection.m_6657_()) {
            return;
        }
        if (target == null || !target.m_6657_()) {
            return;
        }
        if (ItemStack.m_41656_((ItemStack)selection.m_7993_(), (ItemStack)target.m_7993_())) {
            return;
        }
        if (HitechChiselScreen.m_96638_()) {
            List<Slot> duplicates = ((HitechChiselMenu)this.f_97732_).getSelectionDuplicates();
            slots = new int[1 + duplicates.size()];
            slots[0] = selection.f_40219_;
            for (int i = 0; i < duplicates.size(); ++i) {
                slots[i + 1] = duplicates.get((int)i).f_40219_;
            }
        } else {
            slots = new int[]{selection.f_40219_};
        }
        ChiselNetwork.sendToServer(new ChiselButtonPacket(slots));
        ((HitechChiselMenu)this.f_97732_).chiselSlots(slots);
    }

    private void onModeButtonClick(IChiselMode mode) {
        ItemStack chisel = ((HitechChiselMenu)this.f_97732_).getChisel();
        Item item = chisel.m_41720_();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            itemChisel.setMode(chisel, mode);
            ChiselNetwork.sendToServer(new ChiselModePacket(this.getChiselSlot(), mode));
            for (GuiEventListener widget : this.m_6702_()) {
                if (!(widget instanceof ButtonChiselMode)) continue;
                ButtonChiselMode modeButton = (ButtonChiselMode)widget;
                modeButton.f_93623_ = modeButton.getMode() != mode;
            }
        }
    }

    private void saveSettings() {
        ItemStack chisel = ((HitechChiselMenu)this.f_97732_).getChisel();
        Item item = chisel.m_41720_();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            itemChisel.setPreviewType(chisel, this.previewMode.ordinal());
            itemChisel.setRotate(chisel, this.autoRotate);
        }
        ChiselNetwork.sendToServer(new HitechSettingsPacket((byte)this.previewMode.ordinal(), this.autoRotate, this.getChiselSlot()));
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.chiselButton != null) {
            if (HitechChiselScreen.m_96638_()) {
                this.chiselButton.m_93666_((Component)Component.m_237115_((String)"chisel.button.chisel_all").m_130940_(ChatFormatting.YELLOW));
            } else {
                this.chiselButton.m_93666_((Component)Component.m_237115_((String)"chisel.button.chisel"));
            }
            this.chiselButton.f_93623_ = ((HitechChiselMenu)this.f_97732_).getSelection() != null && ((HitechChiselMenu)this.f_97732_).getSelection().m_6657_() && ((HitechChiselMenu)this.f_97732_).getTarget() != null && ((HitechChiselMenu)this.f_97732_).getTarget().m_6657_();
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.renderSlotHighlights(graphics);
        if (this.autoRotate && this.momentumX == 0.0 && this.momentumY == 0.0 && !this.panelClicked && System.currentTimeMillis() - this.lastDragTime > 2000L) {
            this.rotY = this.initRotY + 2.0f * partialTick;
        }
        if (this.panelClicked && this.clickButton == 0) {
            this.momentumX = this.rotX - this.prevRotX;
            this.momentumY = this.rotY - this.prevRotY;
            this.prevRotX = this.rotX;
            this.prevRotY = this.rotY;
        }
        this.render3DPreview(graphics, partialTick);
    }

    private void renderSlotHighlights(GuiGraphics graphics) {
        Slot target;
        Slot selection = ((HitechChiselMenu)this.f_97732_).getSelection();
        if (selection != null && selection.m_6657_()) {
            this.drawSlotHighlight(graphics, selection, 0);
            for (Slot dup : ((HitechChiselMenu)this.f_97732_).getSelectionDuplicates()) {
                this.drawSlotHighlight(graphics, dup, HitechChiselScreen.m_96638_() ? 0 : 18);
            }
        }
        if ((target = ((HitechChiselMenu)this.f_97732_).getTarget()) != null && target.m_6657_()) {
            this.drawSlotHighlight(graphics, target, 36);
        }
    }

    private void drawSlotHighlight(GuiGraphics graphics, Slot slot, int u) {
        graphics.m_280218_(TEXTURE, this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, u, 220, 18, 18);
    }

    private void render3DPreview(GuiGraphics graphics, float partialTick) {
        Item item;
        ItemStack previewItem = ((HitechChiselMenu)this.f_97732_).getTargetItem();
        if (previewItem.m_41619_()) {
            previewItem = ((HitechChiselMenu)this.f_97732_).getSelectionStack();
        }
        if (previewItem == null || previewItem.m_41619_() || !((item = previewItem.m_41720_()) instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState state = blockItem.m_40614_().m_49966_();
        int centerX = this.f_97735_ + 8 + 37;
        int centerY = this.f_97736_ + 14 + 37;
        graphics.m_280588_(this.f_97735_ + 8, this.f_97736_ + 14, this.f_97735_ + 8 + 74, this.f_97736_ + 14 + 74);
        if (!this.panelClicked) {
            this.rotX += (float)this.momentumX;
            this.rotY += (float)this.momentumY;
            this.momentumX *= 0.98;
            this.momentumY *= 0.98;
            if (Math.abs(this.momentumX) < 0.05) {
                this.momentumX = 0.0;
            }
            if (Math.abs(this.momentumY) < 0.05) {
                this.momentumY = 0.0;
            }
        }
        this.rotX = Math.max(-90.0f, Math.min(90.0f, this.rotX));
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)centerX, (float)centerY, 100.0f);
        float scale = 30.0f * this.zoom * this.previewMode.getScale();
        poseStack.m_85841_(scale, -scale, scale);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(this.rotX));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(this.rotY));
        poseStack.m_85837_((double)(-this.previewMode.getCenterX()), (double)(-this.previewMode.getCenterY()), -0.5);
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        BakedModel model = blockRenderer.m_110910_(state);
        PreviewBlockGetter blockGetter = new PreviewBlockGetter(state, this.previewMode.getPositions());
        for (int[] pos : this.previewMode.getPositions()) {
            poseStack.m_85836_();
            poseStack.m_252880_((float)pos[0], (float)pos[1], (float)pos[2]);
            BlockPos blockPos = new BlockPos(pos[0], pos[1], pos[2]);
            ModelData modelData = model.getModelData((BlockAndTintGetter)blockGetter, blockPos, state, ModelData.EMPTY);
            for (RenderType renderType : model.getRenderTypes(state, this.f_96541_.f_91073_.f_46441_, modelData)) {
                blockRenderer.m_110937_().renderModel(poseStack.m_85850_(), bufferSource.m_6299_(renderType), state, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, modelData, renderType);
            }
            poseStack.m_85849_();
        }
        bufferSource.m_109911_();
        poseStack.m_85849_();
        graphics.m_280618_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
        MutableComponent previewLabel = Component.m_237115_((String)"chisel.preview");
        graphics.m_280614_(this.f_96547_, (Component)previewLabel, this.f_97735_ + 8 + (74 - this.f_96547_.m_92852_((FormattedText)previewLabel)) / 2, this.f_97736_ + 14 - 9, 0x404040, false);
        this.drawButtonTooltips(graphics, mouseX, mouseY);
    }

    protected void drawButtonTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        for (GuiEventListener widget : this.m_6702_()) {
            ButtonChiselMode button;
            if (!(widget instanceof ButtonChiselMode) || !(button = (ButtonChiselMode)widget).m_274382_()) continue;
            IChiselMode mode = button.getMode();
            List<MutableComponent> ttLines = List.of(mode.getLocalizedName(), mode.getLocalizedDescription().m_6881_().m_130940_(ChatFormatting.GRAY));
            graphics.m_280666_(this.f_96547_, ttLines, mouseX, mouseY);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    public void m_280092_(GuiGraphics graphics, Slot slot) {
        if (slot == ((HitechChiselMenu)this.f_97732_).getInputSlot()) {
            return;
        }
        super.m_280092_(graphics, slot);
    }

    protected boolean m_6774_(int x, int y, int width, int height, double mouseX, double mouseY) {
        SlotChiselInput inputSlot = ((HitechChiselMenu)this.f_97732_).getInputSlot();
        if (x == inputSlot.f_40220_ && y == inputSlot.f_40221_) {
            return false;
        }
        return super.m_6774_(x, y, width, height, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isInPreviewArea(mouseX, mouseY)) {
            this.panelClicked = true;
            this.clickButton = button;
            this.clickX = (int)mouseX;
            this.clickY = (int)mouseY;
            this.initRotX = this.rotX;
            this.initRotY = this.rotY;
            this.initZoom = this.zoom;
            this.prevRotX = this.rotX;
            this.prevRotY = this.rotY;
            this.momentumX = 0.0;
            this.momentumY = 0.0;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.panelClicked) {
            this.lastDragTime = System.currentTimeMillis();
            this.panelClicked = false;
            this.initRotX = this.rotX;
            this.initRotY = this.rotY;
            this.initZoom = this.zoom;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.panelClicked) {
            if (this.clickButton == 0) {
                this.rotX = Math.max(-90.0f, Math.min(90.0f, this.initRotX + ((float)mouseY - (float)this.clickY)));
                this.rotY = this.initRotY + ((float)mouseX - (float)this.clickX);
            } else if (this.clickButton == 1) {
                this.zoom = Math.max(0.5f, this.initZoom + ((float)this.clickY - (float)mouseY) * 0.01f);
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isInPreviewArea(mouseX, mouseY)) {
            this.zoom += (float)delta * 0.1f;
            this.zoom = Math.max(0.5f, Math.min(3.0f, this.zoom));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private boolean isInPreviewArea(double mouseX, double mouseY) {
        return mouseX >= (double)(this.f_97735_ + 8) && mouseX < (double)(this.f_97735_ + 8 + 74) && mouseY >= (double)(this.f_97736_ + 14) && mouseY < (double)(this.f_97736_ + 14 + 74);
    }

    public static enum PreviewMode {
        PANEL(0.5f, 1.5f, 2.0f, new int[][]{{0, 1, 0}, {1, 1, 0}, {2, 1, 0}, {0, 2, 0}, {1, 2, 0}, {2, 2, 0}, {0, 3, 0}, {1, 3, 0}, {2, 3, 0}}),
        HOLLOW(0.5f, 1.5f, 2.0f, new int[][]{{0, 1, 0}, {1, 1, 0}, {2, 1, 0}, {0, 2, 0}, {2, 2, 0}, {0, 3, 0}, {1, 3, 0}, {2, 3, 0}}),
        PLUS(0.6f, 1.0f, 2.0f, new int[][]{{1, 1, 0}, {1, 2, 0}, {2, 2, 0}, {0, 2, 0}, {1, 3, 0}}),
        SINGLE(1.0f, 0.5f, 0.5f, new int[][]{{0, 0, 0}});

        private final float scale;
        private final float centerX;
        private final float centerY;
        private final int[][] positions;

        private PreviewMode(float scale, float centerX, float centerY, int[][] positions) {
            this.scale = scale;
            this.centerX = centerX;
            this.centerY = centerY;
            this.positions = positions;
        }

        public float getScale() {
            return this.scale;
        }

        public float getCenterX() {
            return this.centerX;
        }

        public float getCenterY() {
            return this.centerY;
        }

        public int[][] getPositions() {
            return this.positions;
        }
    }
}

