/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.compat;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="chisel", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ChiselRebornCompat {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, String> BLOCK_REMAPS = new HashMap<String, String>();
    private static final Map<String, String> ITEM_REMAPS = new HashMap<String, String>();
    private static final String[] COLORS = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    private static final String[] WOOD_TYPES = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "crimson"};
    private static final String[] ROCK_VARIANTS_REBORN = new String[]{"array", "braid", "chaotic_bricks", "chaotic_medium", "chaotic_small", "circular", "cracked", "cracked_bricks", "cut", "dent", "encased_bricks", "french", "jellybean", "large_tile", "layer", "mosaic", "ornate", "panel", "pillar", "prism", "road", "slant", "small_bricks", "soft_bricks", "solid_bricks", "tiles_medium", "tiles_small", "triple_bricks", "twist", "weaver", "zag"};
    private static final String[] PLANK_VARIANTS_REBORN = new String[]{"braid", "crude_horizontal", "crude_paneling", "crude_vertical", "encased", "encased_large", "encased_smooth", "large", "log_bordered", "paneling", "shipping_crate", "smooth", "stacked", "vertical"};

    public static void init() {
        LOGGER.info("Initializing Chisel Reborn compatibility mappings...");
        int count = 0;
        count += ChiselRebornCompat.registerRawVariantAliases();
        count += ChiselRebornCompat.registerRockBlockAliases();
        count += ChiselRebornCompat.registerConcreteAliases();
        count += ChiselRebornCompat.registerWoolAliases();
        count += ChiselRebornCompat.registerPlankAliases();
        count += ChiselRebornCompat.registerGoldAliases();
        count += ChiselRebornCompat.registerIronAliases();
        count += ChiselRebornCompat.registerDiamondAliases();
        count += ChiselRebornCompat.registerEmeraldAliases();
        count += ChiselRebornCompat.registerLapisAliases();
        count += ChiselRebornCompat.registerRedstoneAliases();
        count += ChiselRebornCompat.registerGlassAliases();
        count += ChiselRebornCompat.registerGlowstoneAliases();
        count += ChiselRebornCompat.registerDirtAliases();
        count += ChiselRebornCompat.registerNetherbrickAliases();
        LOGGER.info("Initialized {} Chisel Reborn compatibility mappings", (Object)(count += ChiselRebornCompat.registerFallbackAliases()));
    }

    @SubscribeEvent
    public static void onMissingBlockMappings(MissingMappingsEvent event) {
        for (MissingMappingsEvent.Mapping mapping : event.getMappings(Registries.f_256747_, "chisel")) {
            ResourceLocation newId;
            String oldPath = mapping.getKey().m_135815_();
            String newPath = BLOCK_REMAPS.get(oldPath);
            if (newPath == null || (newId = ResourceLocation.m_135820_((String)newPath)) == null) continue;
            Block newBlock = (Block)ForgeRegistries.BLOCKS.getValue(newId);
            if (newBlock != null) {
                LOGGER.debug("Remapping block {} -> {}", (Object)mapping.getKey(), (Object)newId);
                mapping.remap((Object)newBlock);
                continue;
            }
            LOGGER.warn("Could not find block to remap to: {}", (Object)newId);
            mapping.warn();
        }
    }

    @SubscribeEvent
    public static void onMissingItemMappings(MissingMappingsEvent event) {
        for (MissingMappingsEvent.Mapping mapping : event.getMappings(Registries.f_256913_, "chisel")) {
            ResourceLocation newId;
            String oldPath = mapping.getKey().m_135815_();
            String newPath = ITEM_REMAPS.get(oldPath);
            if (newPath == null || (newId = ResourceLocation.m_135820_((String)newPath)) == null) continue;
            Item newItem = (Item)ForgeRegistries.ITEMS.getValue(newId);
            if (newItem != null) {
                LOGGER.debug("Remapping item {} -> {}", (Object)mapping.getKey(), (Object)newId);
                mapping.remap((Object)newItem);
                continue;
            }
            LOGGER.warn("Could not find item to remap to: {}", (Object)newId);
            mapping.warn();
        }
    }

    private static String mapVariant(String rebornVariant) {
        return switch (rebornVariant) {
            case "layer" -> "layers";
            case "slant" -> "slanted";
            case "twist" -> "twisted";
            case "large_tile" -> "tiles_large";
            case "french" -> "french_1";
            case "cut" -> "cuts";
            default -> rebornVariant;
        };
    }

    private static String mapPlankVariant(String rebornVariant) {
        return switch (rebornVariant) {
            case "large" -> "large_planks";
            case "crude_horizontal" -> "crude_horizontal_planks";
            case "vertical" -> "vertical_planks";
            case "crude_vertical" -> "crude_vertical_planks";
            case "encased" -> "encased_planks";
            case "encased_large" -> "encased_large_planks";
            case "log_bordered" -> "braced_planks";
            default -> rebornVariant;
        };
    }

    private static int registerRawVariantAliases() {
        int count = 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/andesite", "andesite") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/granite", "granite") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/diorite", "diorite") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/cobblestone", "cobblestone") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/stone", "stone") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/bricks", "bricks") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/sandstone", "sandstone") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/red_sandstone", "red_sandstone") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/end_stone", "end_stone") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/prismarine", "prismarine") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/ice", "ice") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/coal_block", "coal_block") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/deepslate", "deepslate") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/blackstone", "blackstone") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/purpur", "purpur_block") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/quartz", "quartz_block") ? 1 : 0;
        for (String color : COLORS) {
            count += ChiselRebornCompat.registerAliasToVanilla("raw/" + color + "_concrete", color + "_concrete") ? 1 : 0;
        }
        return count;
    }

    private static int registerRockBlockAliases() {
        String modernVariant;
        String[] directMappingBases;
        int count = 0;
        for (String base : directMappingBases = new String[]{"andesite", "bricks", "cobblestone", "diorite", "end_stone", "granite", "prismarine", "sandstone", "red_sandstone", "ice"}) {
            for (String rebornVariant : ROCK_VARIANTS_REBORN) {
                String modernVariant2 = ChiselRebornCompat.mapVariant(rebornVariant);
                count += ChiselRebornCompat.registerAlias(rebornVariant + "/" + base, base + "/" + modernVariant2) ? 1 : 0;
            }
        }
        for (String rebornVariant : ROCK_VARIANTS_REBORN) {
            modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
            count += ChiselRebornCompat.registerAlias(rebornVariant + "/stone", "stone_bricks/" + modernVariant) ? 1 : 0;
        }
        count += ChiselRebornCompat.registerAlias("largeornate/stone", "stone_bricks/extra/largeornate") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("poison/stone", "stone_bricks/extra/poison") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("sunken/stone", "stone_bricks/extra/sunken") ? 1 : 0;
        for (String rebornVariant : ROCK_VARIANTS_REBORN) {
            modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
            count += ChiselRebornCompat.registerAlias(rebornVariant + "/quartz", "quartz/" + modernVariant) ? 1 : 0;
        }
        for (String rebornVariant : ROCK_VARIANTS_REBORN) {
            modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
            count += ChiselRebornCompat.registerAlias(rebornVariant + "/purpur", "purpur/" + modernVariant) ? 1 : 0;
        }
        for (String rebornVariant : ROCK_VARIANTS_REBORN) {
            modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
            count += ChiselRebornCompat.registerAlias(rebornVariant + "/coal_block", "coal/" + modernVariant) ? 1 : 0;
        }
        count += ChiselRebornCompat.registerAlias("large_bricks/coal_block", "coal/solid_bricks") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("masonry/coal_block", "coal/solid_bricks") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("bevel_creeper/sandstone", "sandstone/extra/bevel_creeper") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("glyphs/sandstone", "sandstone/extra/glyphs") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("small/sandstone", "sandstone/extra/small") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("bevel_skeleton/red_sandstone", "red_sandstone/extra/bevel_skeleton") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("glyphs/red_sandstone", "red_sandstone/extra/glyphs") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("small/red_sandstone", "red_sandstone/extra/small") ? 1 : 0;
    }

    private static int registerConcreteAliases() {
        int count = 0;
        for (String color : COLORS) {
            for (String rebornVariant : ROCK_VARIANTS_REBORN) {
                String modernPath;
                String modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
                String rebornPath = rebornVariant + "/" + color + "_concrete";
                count += ChiselRebornCompat.registerAlias(rebornPath, modernPath = "concrete_" + color + "/" + modernVariant) ? 1 : 0;
            }
        }
        return count;
    }

    private static int registerWoolAliases() {
        int count = 0;
        String[] woolVariants = new String[]{"legacy", "llama"};
        for (String color : COLORS) {
            for (String variant : woolVariants) {
                String modernPath;
                String rebornPath = variant + "/" + color + "_wool";
                count += ChiselRebornCompat.registerAlias(rebornPath, modernPath = "wool_" + color + "/" + variant) ? 1 : 0;
            }
        }
        return count;
    }

    private static int registerPlankAliases() {
        int count = 0;
        for (String wood : WOOD_TYPES) {
            for (String rebornVariant : PLANK_VARIANTS_REBORN) {
                String modernPath;
                String modernVariant = ChiselRebornCompat.mapPlankVariant(rebornVariant);
                String rebornPath = rebornVariant + "/" + wood + "_planks";
                count += ChiselRebornCompat.registerAlias(rebornPath, modernPath = "planks_" + wood + "/" + modernVariant) ? 1 : 0;
            }
        }
        return count;
    }

    private static int registerGoldAliases() {
        String[] metalVariants;
        int count = 0;
        for (String v : metalVariants = new String[]{"caution", "crate", "thermal", "machine", "badgreggy", "bolted", "scaffold"}) {
            count += ChiselRebornCompat.registerAlias(v + "/gold_block", "gold/" + v) ? 1 : 0;
        }
        count += ChiselRebornCompat.registerAlias("largeingot/gold_block", "gold/large_ingot") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("smallingot/gold_block", "gold/small_ingot") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("brick/gold_block", "gold/brick") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("coin_heads/gold_block", "gold/coin_heads") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("coin_tails/gold_block", "gold/coin_tails") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("crate_dark/gold_block", "gold/crate_dark") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("crate_light/gold_block", "gold/crate_light") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("plates/gold_block", "gold/plates") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("rivets/gold_block", "gold/rivets") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("space/gold_block", "gold/space") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("spaceblack/gold_block", "gold/space_black") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("simple/gold_block", "gold/simple") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("cart/gold_block", "gold/cart") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("star/gold_block", "gold/star") ? 1 : 0;
    }

    private static int registerIronAliases() {
        String[] metalVariants;
        int count = 0;
        for (String v : metalVariants = new String[]{"caution", "crate", "thermal", "machine", "badgreggy", "bolted", "scaffold"}) {
            count += ChiselRebornCompat.registerAlias(v + "/iron_block", "iron/" + v) ? 1 : 0;
        }
        count += ChiselRebornCompat.registerAlias("largeingot/iron_block", "iron/large_ingot") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("smallingot/iron_block", "iron/small_ingot") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("brick/iron_block", "iron/brick") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("coin_heads/iron_block", "iron/coin_heads") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("coin_tails/iron_block", "iron/coin_tails") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("crate_dark/iron_block", "iron/crate_dark") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("crate_light/iron_block", "iron/crate_light") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("plates/iron_block", "iron/plates") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("rivets/iron_block", "iron/rivets") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("space/iron_block", "iron/space") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("spaceblack/iron_block", "iron/space_black") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("simple/iron_block", "iron/simple") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("moon/iron_block", "iron/moon") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("vents/iron_block", "iron/vents") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("gears/iron_block", "iron/vents") ? 1 : 0;
    }

    private static int registerDiamondAliases() {
        int count = 0;
        count += ChiselRebornCompat.registerAlias("embossed/diamond_block", "diamond/terrain_diamond_embossed") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("gem/diamond_block", "diamond/terrain_diamond_gem") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("cells/diamond_block", "diamond/terrain_diamond_cells") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("space/diamond_block", "diamond/terrain_diamond_space") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("spaceblack/diamond_block", "diamond/terrain_diamond_spaceblack") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("simple/diamond_block", "diamond/terrain_diamond_simple") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("bismuth/diamond_block", "diamond/terrain_diamond_bismuth") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("crushed/diamond_block", "diamond/terrain_diamond_crushed") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("four/diamond_block", "diamond/terrain_diamond_four") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("fourornate/diamond_block", "diamond/terrain_diamond_fourornate") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("zelda/diamond_block", "diamond/terrain_diamond_zelda") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("ornatelayer/diamond_block", "diamond/terrain_diamond_ornatelayer") ? 1 : 0;
    }

    private static int registerEmeraldAliases() {
        int count = 0;
        count += ChiselRebornCompat.registerAlias("panel/emerald_block", "emerald/panel") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("panelclassic/emerald_block", "emerald/panelclassic") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("smooth/emerald_block", "emerald/smooth") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("chunky/emerald_block", "emerald/chunk") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("goldborder/emerald_block", "emerald/goldborder") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("zelda/emerald_block", "emerald/zelda") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("cells/emerald_block", "emerald/cell") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("bismuth/emerald_block", "emerald/cellbismuth") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("four/emerald_block", "emerald/four") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("fourornate/emerald_block", "emerald/fourornate") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("ornate/emerald_block", "emerald/ornate") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("masonry/emerald_block", "emerald/masonryemerald") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("circular/emerald_block", "emerald/emeraldcircle") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("prism/emerald_block", "emerald/emeraldprismatic") ? 1 : 0;
    }

    private static int registerLapisAliases() {
        int count = 0;
        count += ChiselRebornCompat.registerAlias("chunky/lapis_block", "lapis/terrain_lapisblock_chunky") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("large_tile/lapis_block", "lapis/terrain_lapisblock_panel") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("zelda/lapis_block", "lapis/terrain_lapisblock_zelda") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("ornate/lapis_block", "lapis/terrain_lapisornate") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("panel/lapis_block", "lapis/terrain_lapistile") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("panelclassic/lapis_block", "lapis/a1_blocklapis_panel") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("smooth/lapis_block", "lapis/a1_blocklapis_smooth") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("ornatelayer/lapis_block", "lapis/a1_blocklapis_ornatelayer") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("masonry/lapis_block", "lapis/masonrylapis") ? 1 : 0;
    }

    private static int registerRedstoneAliases() {
        String[] stoneVariants;
        int count = 0;
        for (String rebornVariant : stoneVariants = new String[]{"array", "braid", "chaotic_medium", "chaotic_small", "circular", "cracked", "cracked_bricks", "dent", "encased_bricks", "french", "jellybean", "large_tile", "layer", "mosaic", "ornate", "panel", "pillar", "prism", "road", "slant", "small_bricks", "soft_bricks", "solid_bricks", "tiles_medium", "tiles_small", "triple_bricks", "twist"}) {
            String modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
            count += ChiselRebornCompat.registerAlias(rebornVariant + "/redstone_block", "redstone/" + modernVariant) ? 1 : 0;
        }
        return count;
    }

    private static int registerGlassAliases() {
        int count = 0;
        count += ChiselRebornCompat.registerAlias("bubble/glass", "glass/terrain_glassbubble") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("japanese/glass", "glass/japanese") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("dungeon/glass", "glass/terrain_glassdungeon") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("light/glass", "glass/terrain_glasslight") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("noborder/glass", "glass/terrain_glassnoborder") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("ornatesteel/glass", "glass/terrain_glass_ornatesteel") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("ornatesteel_old/glass", "glass/terrain_glass_ornatesteel") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("screen/glass", "glass/terrain_glass_screen") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("shale/glass", "glass/terrain_glassshale") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("steelframe/glass", "glass/terrain_glass_steelframe") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("stone/glass", "glass/terrain_glassstone") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("streak/glass", "glass/terrain_glassstreak") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("thick/glass", "glass/terrain_glass_thickgrid") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("thin/glass", "glass/terrain_glass_thingrid") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("ironfencemodern/glass", "glass/a1_glasswindow_ironfencemodern") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("chrono/glass", "glass/chrono") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("chinese/glass", "glass/chinese2") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("chinese2/glass", "glass/chinese2") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("japanese2/glass", "glass/japanese2") ? 1 : 0;
    }

    private static int registerGlowstoneAliases() {
        String[] stoneVariants;
        int count = 0;
        for (String rebornVariant : stoneVariants = new String[]{"array", "braid", "chaotic_medium", "chaotic_small", "circular", "cracked", "cracked_bricks", "dent", "encased_bricks", "french", "jellybean", "large_tile", "layer", "mosaic", "ornate", "panel", "pillar", "prism", "road", "slant", "small_bricks", "soft_bricks", "solid_bricks", "tiles_medium", "tiles_small", "triple_bricks", "twist"}) {
            String modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
            count += ChiselRebornCompat.registerAlias(rebornVariant + "/glowstone", "glowstone/" + modernVariant) ? 1 : 0;
        }
        count += ChiselRebornCompat.registerAlias("bismuth/glowstone", "glowstone/extra/bismuth") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("large_tile_bismuth/glowstone", "glowstone/extra/tiles_large_bismuth") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("tiles_medium_bismuth/glowstone", "glowstone/extra/tiles_medium_bismuth") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("neon/glowstone", "glowstone/extra/neon") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("neon_panel/glowstone", "glowstone/extra/neon_panel") ? 1 : 0;
    }

    private static int registerDirtAliases() {
        int count = 0;
        count += ChiselRebornCompat.registerAlias("bricks/dirt", "dirt/bricks") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("bricks2/dirt", "dirt/bricks2") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("bricks3/dirt", "dirt/bricks3") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("chunky/dirt", "dirt/chunky") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("cobble/dirt", "dirt/cobble") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("happy/dirt", "dirt/happy") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("horizontal/dirt", "dirt/horizontal") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("layer/dirt", "dirt/layers") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("panel/dirt", "dirt/plate") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("reinforced/dirt", "dirt/reinforceddirt") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("reinforcedcobble/dirt", "dirt/reinforcedcobbledirt") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("vertical/dirt", "dirt/vert") ? 1 : 0;
    }

    private static int registerNetherbrickAliases() {
        int count = 0;
        count += ChiselRebornCompat.registerAlias("pillar/nether_brick", "netherbrick/a1_netherbrick_brinstar") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("mosaic/nether_brick", "netherbrick/netherfancybricks") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("slant/nether_brick", "netherbrick/a1_netherbrick_red") ? 1 : 0;
    }

    private static int registerFallbackAliases() {
        int count = 0;
        for (String rebornVariant : ROCK_VARIANTS_REBORN) {
            String modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
            count += ChiselRebornCompat.registerAlias(rebornVariant + "/deepslate", "basalt/" + modernVariant) ? 1 : 0;
        }
        count += ChiselRebornCompat.registerAlias("largeornate/deepslate", "basalt/panel") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("poison/deepslate", "basalt/panel") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("sunken/deepslate", "basalt/panel") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("pillar/blackstone", "basalt/pillar") ? 1 : 0;
    }

    private static boolean registerAlias(String fromPath, String toPath) {
        if (BLOCK_REMAPS.containsKey(fromPath)) {
            LOGGER.debug("Skipping duplicate alias: {} (already registered)", (Object)fromPath);
            return false;
        }
        String fullPath = "chisel:" + toPath;
        BLOCK_REMAPS.put(fromPath, fullPath);
        ITEM_REMAPS.put(fromPath, fullPath);
        return true;
    }

    private static boolean registerAliasToVanilla(String fromPath, String vanillaBlock) {
        if (BLOCK_REMAPS.containsKey(fromPath)) {
            LOGGER.debug("Skipping duplicate alias: {} (already registered)", (Object)fromPath);
            return false;
        }
        String fullPath = "minecraft:" + vanillaBlock;
        BLOCK_REMAPS.put(fromPath, fullPath);
        ITEM_REMAPS.put(fromPath, fullPath);
        return true;
    }
}

