/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.compat.kubejs;

import com.leclowndu93150.chisel.compat.kubejs.CarvingGroupBuilder;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class ModifyCarvingGroupsEvent
extends EventJS {
    private final Map<ResourceLocation, CarvingGroupBuilder> groups = new LinkedHashMap<ResourceLocation, CarvingGroupBuilder>();
    private final Set<ResourceLocation> removedGroups = new HashSet<ResourceLocation>();
    private final Set<ResourceLocation> blocksRemovedFromAll = new HashSet<ResourceLocation>();

    @Info(value="Get or create a carving group by ID. Use 'chisel:groupname' format or just 'groupname' for chisel namespace.")
    public CarvingGroupBuilder get(String groupId) {
        ResourceLocation id = this.parseId(groupId);
        return this.groups.computeIfAbsent(id, CarvingGroupBuilder::new);
    }

    @Info(value="Alias for get(), creates a new carving group or modifies existing one")
    public CarvingGroupBuilder create(String groupId) {
        return this.get(groupId);
    }

    @Info(value="Remove an entire carving group")
    public ModifyCarvingGroupsEvent remove(String groupId) {
        ResourceLocation id = this.parseId(groupId);
        this.removedGroups.add(id);
        this.groups.remove(id);
        return this;
    }

    @Info(value="Remove a block from ALL carving groups")
    public ModifyCarvingGroupsEvent removeFromAll(String blockId) {
        ResourceLocation id = this.parseBlockId(blockId);
        this.blocksRemovedFromAll.add(id);
        for (CarvingGroupBuilder builder : this.groups.values()) {
            builder.remove(blockId);
        }
        return this;
    }

    @Info(value="Check if a group exists or is being created")
    public boolean hasGroup(String groupId) {
        return this.groups.containsKey(this.parseId(groupId));
    }

    @Info(value="Get all group IDs being modified")
    public String[] getGroupIds() {
        return (String[])this.groups.keySet().stream().map(ResourceLocation::toString).toArray(String[]::new);
    }

    public Map<ResourceLocation, CarvingGroupBuilder> getGroups() {
        return Collections.unmodifiableMap(this.groups);
    }

    public Set<ResourceLocation> getRemovedGroups() {
        return Collections.unmodifiableSet(this.removedGroups);
    }

    public Set<ResourceLocation> getBlocksRemovedFromAll() {
        return Collections.unmodifiableSet(this.blocksRemovedFromAll);
    }

    private ResourceLocation parseId(String id) {
        if (id.contains(":")) {
            return new ResourceLocation(id);
        }
        return new ResourceLocation("chisel", id);
    }

    private ResourceLocation parseBlockId(String id) {
        if (id.contains(":")) {
            return new ResourceLocation(id);
        }
        return new ResourceLocation("minecraft", id);
    }
}

