/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.inventory;

import com.google.common.collect.ImmutableList;
import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.inventory.ChiselMenu;
import com.leclowndu93150.chisel.item.ItemChisel;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class HitechChiselMenu
extends ChiselMenu {
    public static final int HITECH_SELECTION_ROWS = 7;
    public static final int HITECH_SELECTION_COLS = 9;
    public static final int HITECH_SELECTION_SIZE = 63;
    public static final int HITECH_SELECTION_LEFT = 88;
    public static final int HITECH_SELECTION_TOP = 8;
    public static final int HITECH_INPUT_X = -1000;
    public static final int HITECH_INPUT_Y = 0;
    public static final int HITECH_PLAYER_INV_LEFT = 88;
    public static final int HITECH_PLAYER_INV_TOP = 138;
    public static final int HITECH_HOTBAR_TOP = 196;
    @Nullable
    private Slot selection;
    @Nullable
    private Slot target;
    private List<Slot> selectionDuplicates = ImmutableList.of();
    @Nullable
    private TagKey<Item> currentGroup;
    public static Supplier<MenuType<HitechChiselMenu>> MENU_TYPE_SUPPLIER;

    public HitechChiselMenu(int containerId, Inventory playerInv, FriendlyByteBuf buf) {
        this(containerId, playerInv, buf != null && buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
    }

    public HitechChiselMenu(int containerId, Inventory playerInv, InteractionHand hand) {
        super(MENU_TYPE_SUPPLIER != null ? MENU_TYPE_SUPPLIER.get() : null, containerId, playerInv, hand, 63);
        Item item;
        if (!this.chisel.m_41619_() && (item = this.chisel.m_41720_()) instanceof ItemChisel) {
            int targetSlot;
            int playerSlotIndex;
            ItemChisel itemChisel = (ItemChisel)item;
            int selectionSlot = itemChisel.getSelectionSlot(this.chisel);
            if (selectionSlot >= this.inventoryChisel.m_6643_() && (playerSlotIndex = selectionSlot - this.inventoryChisel.m_6643_()) >= 0 && playerSlotIndex < 36) {
                this.setSelection(this.m_38853_(selectionSlot));
            }
            if ((targetSlot = itemChisel.getTargetSlot(this.chisel)) >= 0 && targetSlot < this.inventoryChisel.size) {
                this.setTarget(this.m_38853_(targetSlot));
            }
        }
    }

    @Override
    protected int getSelectionLeft() {
        return 88;
    }

    @Override
    protected int getSelectionTop() {
        return 8;
    }

    @Override
    protected int getSelectionCols() {
        return 9;
    }

    @Override
    protected int getPlayerInvLeft() {
        return 88;
    }

    @Override
    protected int getPlayerInvTop() {
        return 138;
    }

    @Override
    protected int getHotbarTop() {
        return 196;
    }

    @Override
    public int getSelectionSize() {
        return 63;
    }

    public void setTarget(@Nullable Slot slot) {
        this.target = slot;
        Item item = this.chisel.m_41720_();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            itemChisel.setTargetSlot(this.chisel, slot != null ? slot.f_40219_ : -1);
        }
    }

    public void setSelection(@Nullable Slot slot) {
        this.selection = slot;
        if (slot == null || !slot.m_6657_()) {
            this.currentGroup = null;
            this.selectionDuplicates = ImmutableList.of();
            this.setTarget(null);
            this.inventoryChisel.setStackInSpecialSlot(ItemStack.f_41583_);
        } else {
            int playerInvStart;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = playerInvStart = this.inventoryChisel.m_6643_(); i < this.f_38839_.size(); ++i) {
                Slot s = this.m_38853_(i);
                if (slot == s || !ItemStack.m_41656_((ItemStack)slot.m_7993_(), (ItemStack)s.m_7993_())) continue;
                builder.add((Object)s);
            }
            this.selectionDuplicates = builder.build();
            TagKey<Item> group = CarvingHelper.getCarvingGroupForItem(slot.m_7993_());
            if (this.currentGroup != null && group != this.currentGroup) {
                this.setTarget(null);
            }
            this.currentGroup = group;
            this.inventoryChisel.setStackInSpecialSlot(slot.m_7993_().m_41777_());
        }
        this.inventoryChisel.updateItems();
        Item item = this.chisel.m_41720_();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            itemChisel.setSelectionSlot(this.chisel, slot != null ? slot.f_40219_ : -1);
        }
    }

    @Nullable
    public Slot getSelection() {
        return this.selection;
    }

    @Nullable
    public Slot getTarget() {
        return this.target;
    }

    public List<Slot> getSelectionDuplicates() {
        return this.selectionDuplicates;
    }

    @Nullable
    public ItemStack getSelectionStack() {
        return this.selection != null ? this.selection.m_7993_() : ItemStack.f_41583_;
    }

    public ItemStack getTargetItem() {
        return this.target != null ? this.target.m_7993_() : ItemStack.f_41583_;
    }

    @Override
    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 0 && slotId < this.f_38839_.size()) {
            Slot slot = this.m_38853_(slotId);
            if (slotId < this.inventoryChisel.size) {
                this.setTarget(slot);
            } else if (slotId > this.inventoryChisel.size) {
                if (dragType == 1) {
                    ItemStack toFind = slot.m_7993_();
                    if (!toFind.m_41619_()) {
                        for (int i = 0; i < this.inventoryChisel.size; ++i) {
                            if (!ItemStack.m_41656_((ItemStack)toFind, (ItemStack)this.inventoryChisel.m_8020_(i))) continue;
                            this.setTarget(this.m_38853_(i));
                            break;
                        }
                    }
                } else if (slot.m_6657_() && CarvingHelper.canChisel(slot.m_7993_())) {
                    this.setSelection(slot);
                }
            }
        }
    }

    @Override
    public void m_6877_(Player player) {
        Item item = this.chisel.m_41720_();
        if (item instanceof ItemChisel) {
            ItemChisel itemChisel = (ItemChisel)item;
            itemChisel.setTarget(this.chisel, this.getTargetItem());
        }
        this.inventoryChisel.setStackInSpecialSlot(ItemStack.f_41583_);
        super.m_6877_(player);
    }

    @Override
    public ItemStack m_7648_(Player player, int slotIdx) {
        return ItemStack.f_41583_;
    }

    public void chiselSlots(int[] slots) {
        Block block;
        if (this.target == null || !this.target.m_6657_()) {
            return;
        }
        if (this.selection == null || !this.selection.m_6657_()) {
            return;
        }
        Item item = this.chisel.m_41720_();
        if (!(item instanceof IChiselItem)) {
            return;
        }
        IChiselItem chiselItem = (IChiselItem)item;
        ItemStack targetStack = this.target.m_7993_();
        boolean chiseledAny = false;
        Item item2 = targetStack.m_41720_();
        if (item2 instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item2;
            block = blockItem.m_40614_();
        } else {
            block = Blocks.f_50016_;
        }
        Block targetBlock = block;
        for (int slotIndex : slots) {
            ItemStack source;
            Slot slot = this.m_38853_(slotIndex);
            if (slot == null || !slot.m_6657_() || !CarvingHelper.canChisel(source = slot.m_7993_())) continue;
            TagKey<Item> sourceGroup = CarvingHelper.getCarvingGroupForItem(source);
            TagKey<Item> targetGroup = CarvingHelper.getCarvingGroupForItem(targetStack);
            if (sourceGroup == null || !sourceGroup.equals(targetGroup)) continue;
            ItemStack converted = targetStack.m_41777_();
            converted.m_41764_(source.m_41613_());
            slot.m_5852_(converted);
            chiseledAny = true;
            chiselItem.onChisel(this.inventoryPlayer.f_35978_.m_9236_(), this.inventoryPlayer.f_35978_, this.chisel, targetBlock);
            if (!this.chisel.m_41619_()) continue;
            this.inventoryPlayer.m_6836_(this.chiselSlot, ItemStack.f_41583_);
            break;
        }
        if (this.selection != null && !this.selection.m_6657_()) {
            if (!this.selectionDuplicates.isEmpty()) {
                this.setSelection(this.selectionDuplicates.get(0));
            } else {
                this.setSelection(null);
            }
        } else if (this.selection != null) {
            this.setSelection(this.selection);
        }
        this.m_38946_();
    }
}

