/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.inventory;

import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.inventory.ChiselMenu;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class InventoryChiselSelection
implements Container {
    public final int size;
    public int activeVariations = 0;
    @Nullable
    ChiselMenu container;
    NonNullList<ItemStack> inventory;

    public InventoryChiselSelection(ChiselMenu container, int size) {
        this.size = size;
        this.container = container;
        this.inventory = NonNullList.m_122780_((int)(size + 1), (Object)ItemStack.f_41583_);
    }

    public int m_6643_() {
        return this.size + 1;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.inventory) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        if (slot < 0 || slot >= this.inventory.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (!stack.m_41619_()) {
            if (stack.m_41613_() <= amount) {
                this.m_6836_(slot, ItemStack.f_41583_);
                return stack;
            }
            ItemStack split = stack.m_41620_(amount);
            if (stack.m_41613_() == 0) {
                this.m_6836_(slot, ItemStack.f_41583_);
            }
            return split;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.m_8020_(slot);
        this.inventory.set(slot, (Object)ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.inventory.size()) {
            this.inventory.set(slot, (Object)stack);
        }
    }

    public int m_6893_() {
        return 64;
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        IChiselItem chiselItem;
        Item item;
        if (this.container == null) {
            return false;
        }
        ItemStack held = player.m_150109_().m_8020_(this.container.getChiselSlot());
        return !held.m_41619_() && (item = held.m_41720_()) instanceof IChiselItem && (chiselItem = (IChiselItem)item).canOpenGui(player.m_9236_(), player, this.container.getHand());
    }

    public void m_6211_() {
        this.inventory.clear();
        for (int i = 0; i < this.size + 1; ++i) {
            this.inventory.add((Object)ItemStack.f_41583_);
        }
    }

    public ItemStack getStackInSpecialSlot() {
        return (ItemStack)this.inventory.get(this.size);
    }

    public void setStackInSpecialSlot(ItemStack stack) {
        this.m_6836_(this.size, stack);
    }

    public void clearItems() {
        this.activeVariations = 0;
        for (int i = 0; i < this.size; ++i) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public void updateItems() {
        ItemStack target = this.getStackInSpecialSlot();
        this.clearItems();
        if (target.m_41619_()) {
            return;
        }
        TagKey<Item> group = CarvingHelper.getCarvingGroupForItem(target);
        if (group == null) {
            return;
        }
        List<Item> variations = CarvingHelper.getItemsInGroup(group);
        this.activeVariations = 0;
        for (Item item : variations) {
            if (this.activeVariations >= this.size) break;
            this.m_6836_(this.activeVariations, new ItemStack((ItemLike)item));
            ++this.activeVariations;
        }
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (slot != this.size) {
            return false;
        }
        return CarvingHelper.canChisel(stack);
    }
}

