/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.item;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.leclowndu93150.chisel.ChiselConfig;
import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.api.carving.IChiselMode;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.compat.ftbultimine.FTBUltimineHelper;
import com.leclowndu93150.chisel.item.ItemChisel;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ChiselController {
    private static final LoadingCache<Player, Long> CLICK_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).weakKeys().build((CacheLoader)new CacheLoader<Player, Long>(){

        public Long load(Player key) {
            return 0L;
        }
    });

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemChisel itemChisel;
        Item item;
        Player player = event.getEntity();
        ItemStack held = event.getItemStack();
        Item item2 = held.m_41720_();
        if (!(item2 instanceof IChiselItem)) {
            return;
        }
        IChiselItem chisel = (IChiselItem)item2;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Direction side = event.getFace();
        BlockState state = level.m_8055_(pos);
        if (!chisel.canChiselBlock(level, player, event.getHand(), pos, state)) {
            return;
        }
        TagKey<Item> blockGroup = CarvingHelper.getCarvingGroupForBlock(state.m_60734_());
        if (blockGroup == null) {
            return;
        }
        Iterable<? extends BlockPos> candidates = ChiselController.getCandidates(player, pos, side, chisel.getMode(held));
        ItemStack target = chisel.getTarget(held);
        if (target.m_41619_() && (item = held.m_41720_()) instanceof ItemChisel && (itemChisel = (ItemChisel)item).getChiselType() == ItemChisel.ChiselType.HITECH) {
            if (level.f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)"chisel.message.no_target"), true);
            }
            event.setCanceled(true);
            return;
        }
        if (!target.m_41619_()) {
            Block targetBlock;
            TagKey<Item> targetGroup = CarvingHelper.getCarvingGroupForItem(target);
            if (blockGroup.equals(targetGroup) && (targetBlock = Block.m_49814_((Item)target.m_41720_())) != null) {
                ChiselController.setAll(candidates, player, state, targetBlock, held, event.getHand());
                event.setCanceled(true);
            }
        } else {
            List<Item> variations = CarvingHelper.getItemsInGroup(blockGroup);
            if (variations.isEmpty()) {
                return;
            }
            int index = -1;
            for (int i = 0; i < variations.size(); ++i) {
                if (Block.m_49814_((Item)variations.get(i)) != state.m_60734_()) continue;
                index = i;
                break;
            }
            index = player.m_6047_() ? index - 1 : index + 1;
            Block nextBlock = Block.m_49814_((Item)variations.get(index = (index + variations.size()) % variations.size()));
            if (nextBlock != null) {
                ChiselController.setAll(candidates, player, state, nextBlock, held, event.getHand());
                event.setCanceled(true);
            }
        }
    }

    private static void setAll(Iterable<? extends BlockPos> candidates, Player player, BlockState origState, Block targetBlock, ItemStack chisel, InteractionHand hand) {
        if (!ChiselController.checkClickCache(player)) {
            return;
        }
        for (BlockPos blockPos : candidates) {
            ChiselController.setVariation(player, blockPos, origState, targetBlock, chisel, hand);
        }
    }

    private static boolean checkClickCache(Player player) {
        long time = player.m_9236_().m_46467_();
        int cooldown = ChiselConfig.carvingCooldownTicks;
        long lastClick = (Long)CLICK_CACHE.getUnchecked((Object)player);
        if (lastClick > time - (long)cooldown) {
            if (player.m_9236_().f_46443_) {
                long ticksRemaining = (long)cooldown - (time - lastClick);
                double secondsRemaining = (double)ticksRemaining / 20.0;
                player.m_5661_((Component)Component.m_237110_((String)"chisel.message.cooldown", (Object[])new Object[]{String.format("%.1f", secondsRemaining)}), true);
            }
            return false;
        }
        CLICK_CACHE.put((Object)player, (Object)time);
        return true;
    }

    private static void setVariation(Player player, BlockPos pos, BlockState origState, Block targetBlock, ItemStack chiselStack, InteractionHand hand) {
        Level level = player.m_9236_();
        BlockState curState = level.m_8055_(pos);
        if (curState.m_60734_() == targetBlock) {
            return;
        }
        if (origState != curState) {
            return;
        }
        Item item = chiselStack.m_41720_();
        if (item instanceof IChiselItem) {
            IChiselItem chisel = (IChiselItem)item;
            EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            chisel.onChisel(level, player, chiselStack, targetBlock);
            if (chiselStack.m_41619_() || chiselStack.m_41613_() <= 0) {
                ItemStack targetItem = chisel.getTarget(chiselStack);
                player.m_150109_().m_6836_(player.m_150109_().f_35977_, targetItem.m_41619_() ? ItemStack.f_41583_ : targetItem);
                return;
            }
            if (level.f_46443_) {
                CarvingHelper.playChiselSound(level, player, targetBlock);
                level.m_5898_(player, 2001, pos, Block.m_49956_((BlockState)origState));
            }
            level.m_46597_(pos, targetBlock.m_49966_());
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack mainhandStack;
        if (event.getHand() == InteractionHand.OFF_HAND && (mainhandStack = event.getEntity().m_21205_()).m_41720_() instanceof IChiselItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack stack = event.getPlayer().m_21205_();
        if (event.getPlayer().m_150110_().f_35937_ && !stack.m_41619_() && stack.m_41720_() instanceof IChiselItem) {
            event.setCanceled(true);
        }
    }

    private static Iterable<? extends BlockPos> getCandidates(Player player, BlockPos pos, Direction side, IChiselMode mode) {
        Optional<Collection<BlockPos>> ultimineSelection;
        if (ChiselConfig.enableUltimineCompat && ModList.get().isLoaded("ftbultimine") && (ultimineSelection = FTBUltimineHelper.getBlockSelection(player)).isPresent()) {
            return ultimineSelection.get();
        }
        return mode.getCandidates(player, pos, side);
    }
}

