/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.leclowndu93150.chisel.ChiselConfig;
import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.api.carving.IChiselMode;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.carving.ChiselMode;
import com.leclowndu93150.chisel.carving.ChiselModeRegistry;
import com.leclowndu93150.chisel.component.ChiselData;
import com.leclowndu93150.chisel.init.ChiselDataComponents;
import com.leclowndu93150.chisel.inventory.ChiselMenu;
import com.leclowndu93150.chisel.inventory.HitechChiselMenu;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ItemChisel
extends Item
implements IChiselItem {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private final ChiselType type;

    public ItemChisel(ChiselType type, Item.Properties properties) {
        super(properties);
        this.type = type;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)type.getAttackDamage(), AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public ChiselType getChiselType() {
        return this.type;
    }

    public int getMaxDamage(ItemStack stack) {
        if (ChiselConfig.allowChiselDamage) {
            return this.type.getMaxDamage();
        }
        return 0;
    }

    public boolean isDamageable(ItemStack stack) {
        return ChiselConfig.allowChiselDamage;
    }

    public boolean m_6832_(ItemStack damagedItem, ItemStack repairMaterial) {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case ChiselType.DIAMOND, ChiselType.HITECH -> repairMaterial.m_150930_(Items.f_42415_);
            case ChiselType.IRON -> repairMaterial.m_150930_(Items.f_42416_);
        };
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"chisel.tooltip.gui").m_130940_(ChatFormatting.GRAY));
        if (this.type.canLeftClick()) {
            tooltip.add((Component)Component.m_237115_((String)"chisel.tooltip.leftclick.1").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"chisel.tooltip.leftclick.2").m_130940_(ChatFormatting.GRAY));
            if (this.type == ChiselType.HITECH) {
                tooltip.add((Component)Component.m_237115_((String)"chisel.tooltip.hitech.target").m_130940_(ChatFormatting.YELLOW));
            }
        }
        if (this.type.hasModes()) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"chisel.tooltip.modes").m_130940_(ChatFormatting.GRAY));
            IChiselMode mode = this.getMode(stack);
            tooltip.add((Component)Component.m_237110_((String)"chisel.tooltip.selectedmode", (Object[])new Object[]{mode.getLocalizedName().m_6881_().m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, final InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_() && this.type.hasModes()) {
            if (!level.f_46443_) {
                this.cycleMode(stack, player, true);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (!level.f_46443_ && this.canOpenGui(level, player, hand) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            IChiselItem.ChiselGuiType guiType = this.getGuiType(level, player, hand);
            if (guiType == IChiselItem.ChiselGuiType.HITECH) {
                serverPlayer.m_5893_(new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237115_((String)"container.chisel.hitech");
                    }

                    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInv, Player p) {
                        return new HitechChiselMenu(containerId, playerInv, hand);
                    }
                });
            } else {
                serverPlayer.m_5893_(new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237115_((String)"container.chisel");
                    }

                    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInv, Player p) {
                        return new ChiselMenu(containerId, playerInv, hand);
                    }
                });
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    public boolean canOpenGui(Level world, Player player, InteractionHand hand) {
        return true;
    }

    @Override
    public IChiselItem.ChiselGuiType getGuiType(Level world, Player player, InteractionHand hand) {
        return this.type == ChiselType.HITECH ? IChiselItem.ChiselGuiType.HITECH : IChiselItem.ChiselGuiType.NORMAL;
    }

    @Override
    public boolean onChisel(Level world, Player player, ItemStack chisel, Block target) {
        return ChiselConfig.allowChiselDamage;
    }

    @Override
    public boolean canChisel(Level world, Player player, ItemStack chisel, ItemStack target) {
        return !chisel.m_41619_() && CarvingHelper.canChisel(target);
    }

    @Override
    public boolean canChiselBlock(Level world, Player player, InteractionHand hand, BlockPos pos, BlockState state) {
        return this.type.canLeftClick() && CarvingHelper.canChisel(state);
    }

    @Override
    public boolean supportsMode(Player player, ItemStack chisel, IChiselMode mode) {
        if (this.type == ChiselType.HITECH) {
            return true;
        }
        if (this.type == ChiselType.DIAMOND || ChiselConfig.ironChiselHasModes) {
            return mode != ChiselMode.CONTIGUOUS && mode != ChiselMode.CONTIGUOUS_2D;
        }
        return mode == ChiselMode.SINGLE;
    }

    @Override
    public IChiselMode getMode(ItemStack stack) {
        IChiselMode mode;
        ChiselData data = ChiselDataComponents.CHISEL_DATA.get().get(stack);
        if (data != null && (mode = ChiselModeRegistry.INSTANCE.getModeByName(data.mode())) != null) {
            return mode;
        }
        return ChiselMode.SINGLE;
    }

    public void setMode(ItemStack stack, IChiselMode mode) {
        ChiselData data = ChiselDataComponents.CHISEL_DATA.get().get(stack);
        ChiselDataComponents.CHISEL_DATA.get().set(stack, data.withMode(mode.name()));
    }

    public int getPreviewType(ItemStack stack) {
        ChiselData data = ChiselDataComponents.CHISEL_DATA.get().get(stack);
        return data != null ? data.previewType() : 0;
    }

    public void setPreviewType(ItemStack stack, int type) {
        ChiselData data = ChiselDataComponents.CHISEL_DATA.get().get(stack);
        ChiselDataComponents.CHISEL_DATA.get().set(stack, data.withPreviewType(type));
    }

    public int getSelectionSlot(ItemStack stack) {
        ChiselData data = ChiselDataComponents.CHISEL_DATA.get().get(stack);
        return data != null ? data.selectionSlot() : -1;
    }

    public void setSelectionSlot(ItemStack stack, int slot) {
        ChiselData data = ChiselDataComponents.CHISEL_DATA.get().get(stack);
        ChiselDataComponents.CHISEL_DATA.get().set(stack, data.withSelectionSlot(slot));
    }

    public int getTargetSlot(ItemStack stack) {
        ChiselData data = ChiselDataComponents.CHISEL_DATA.get().get(stack);
        return data != null ? data.targetSlot() : -1;
    }

    public void setTargetSlot(ItemStack stack, int slot) {
        ChiselData data = ChiselDataComponents.CHISEL_DATA.get().get(stack);
        ChiselDataComponents.CHISEL_DATA.get().set(stack, data.withTargetSlot(slot));
    }

    public boolean getRotate(ItemStack stack) {
        ChiselData data = ChiselDataComponents.CHISEL_DATA.get().get(stack);
        return data != null && data.rotate();
    }

    public void setRotate(ItemStack stack, boolean rotate) {
        ChiselData data = ChiselDataComponents.CHISEL_DATA.get().get(stack);
        ChiselDataComponents.CHISEL_DATA.get().set(stack, data.withRotate(rotate));
    }

    @Override
    public ItemStack getTarget(ItemStack stack) {
        ChiselData data = ChiselDataComponents.CHISEL_DATA.get().get(stack);
        return data != null ? data.target() : ItemStack.f_41583_;
    }

    public void setTarget(ItemStack stack, ItemStack target) {
        ChiselData data = ChiselDataComponents.CHISEL_DATA.get().get(stack);
        ChiselDataComponents.CHISEL_DATA.get().set(stack, data.withTarget(target));
    }

    public void cycleMode(ItemStack stack, Player player, boolean forward) {
        IChiselMode current = this.getMode(stack);
        IChiselMode next = forward ? ChiselModeRegistry.INSTANCE.getNextMode(current) : ChiselModeRegistry.INSTANCE.getPreviousMode(current);
        while (next != current && !this.supportsMode(player, stack, next)) {
            if (forward) {
                next = ChiselModeRegistry.INSTANCE.getNextMode(next);
                continue;
            }
            next = ChiselModeRegistry.INSTANCE.getPreviousMode(next);
        }
        if (next != current) {
            this.setMode(stack, next);
            player.m_5661_((Component)Component.m_237110_((String)"chisel.message.mode_changed", (Object[])new Object[]{next.getLocalizedName()}), true);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.m_41656_((ItemStack)oldStack, (ItemStack)newStack);
    }

    @Override
    public void openGui(Player player, final InteractionHand hand, ItemStack chisel) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            IChiselItem.ChiselGuiType guiType = this.getGuiType(player.m_9236_(), player, hand);
            if (guiType == IChiselItem.ChiselGuiType.HITECH) {
                serverPlayer.m_5893_(new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237115_((String)"container.chisel.hitech");
                    }

                    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInv, Player p) {
                        return new HitechChiselMenu(containerId, playerInv, hand);
                    }
                });
            } else {
                serverPlayer.m_5893_(new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237115_((String)"container.chisel");
                    }

                    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInv, Player p) {
                        return new ChiselMenu(containerId, playerInv, hand);
                    }
                });
            }
        }
    }

    public static enum ChiselType {
        IRON(false, false),
        DIAMOND(true, true),
        HITECH(true, true);

        private final boolean canLeftClick;
        private final boolean hasModes;

        private ChiselType(boolean canLeftClick, boolean hasModes) {
            this.canLeftClick = canLeftClick;
            this.hasModes = hasModes;
        }

        public int getMaxDamage() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case IRON -> ChiselConfig.ironChiselMaxDamage;
                case DIAMOND -> ChiselConfig.diamondChiselMaxDamage;
                case HITECH -> ChiselConfig.hitechChiselMaxDamage;
            };
        }

        public int getAttackDamage() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case IRON -> ChiselConfig.ironChiselAttackDamage;
                case DIAMOND -> ChiselConfig.diamondChiselAttackDamage;
                case HITECH -> ChiselConfig.hitechChiselAttackDamage;
            };
        }

        public boolean canLeftClick() {
            return this.canLeftClick || ChiselConfig.ironChiselCanLeftClick;
        }

        public boolean hasModes() {
            return this.hasModes || ChiselConfig.ironChiselHasModes;
        }
    }
}

