/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.leclowndu93150.chisel.api.chunkdata.ChunkData;
import com.leclowndu93150.chisel.api.chunkdata.OffsetData;
import com.leclowndu93150.chisel.network.ChiselNetwork;
import com.leclowndu93150.chisel.network.client.ChunkDataPacket;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public class ItemOffsetTool
extends Item {
    private static final int MAX_CONNECTED_BLOCKS = 512;

    public ItemOffsetTool(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ChunkPos chunkPos;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockState clickedState = world.m_8055_(pos);
        Block clickedBlock = clickedState.m_60734_();
        Set<BlockPos> connectedBlocks = this.findConnectedBlocks(world, pos, clickedBlock);
        Vec3 hitVec = context.m_43720_();
        Direction moveDir = this.getMoveDir(context.m_43719_(), hitVec.m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
        HashMap<ChunkPos, Set> blocksByChunk = new HashMap<ChunkPos, Set>();
        for (BlockPos blockPos : connectedBlocks) {
            chunkPos = new ChunkPos(blockPos);
            blocksByChunk.computeIfAbsent(chunkPos, k -> new HashSet()).add(blockPos);
        }
        for (Map.Entry entry : blocksByChunk.entrySet()) {
            chunkPos = (ChunkPos)entry.getKey();
            Set blocksInChunk = (Set)entry.getValue();
            OffsetData data = ChunkData.getOrCreateData(world, chunkPos);
            data.moveAll(blocksInChunk, moveDir);
            LevelChunk chunk = world.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
            chunk.m_8092_(true);
            if (!(world instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)world;
            CompoundTag tag = new CompoundTag();
            data.writeToNBT(tag);
            LevelChunk trackingChunk = serverLevel.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
            ChiselNetwork.sendToAllTrackingChunk(trackingChunk, new ChunkDataPacket(chunkPos.f_45578_, chunkPos.f_45579_, tag));
        }
        return InteractionResult.SUCCESS;
    }

    private Set<BlockPos> findConnectedBlocks(Level world, BlockPos start, Block targetBlock) {
        HashSet<BlockPos> connected = new HashSet<BlockPos>();
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        toCheck.add(start);
        connected.add(start);
        while (!toCheck.isEmpty() && connected.size() < 512) {
            BlockPos current = (BlockPos)toCheck.poll();
            for (Direction dir : Direction.values()) {
                BlockState neighborState;
                BlockPos neighbor = current.m_121945_(dir);
                if (connected.contains(neighbor) || (neighborState = world.m_8055_(neighbor)).m_60734_() != targetBlock) continue;
                connected.add(neighbor);
                toCheck.add(neighbor);
            }
        }
        return connected;
    }

    public Direction getMoveDir(Direction face, Vec3 hitVec) {
        HashMap map = Maps.newHashMap();
        if (face.m_122429_() != 0) {
            this.fillMap(map, hitVec.f_82481_ - (double)((int)hitVec.f_82481_), hitVec.f_82480_ - (double)((int)hitVec.f_82480_), Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH);
        } else if (face.m_122430_() != 0) {
            this.fillMap(map, hitVec.f_82479_ - (double)((int)hitVec.f_82479_), hitVec.f_82481_ - (double)((int)hitVec.f_82481_), Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
        } else if (face.m_122431_() != 0) {
            this.fillMap(map, hitVec.f_82479_ - (double)((int)hitVec.f_82479_), hitVec.f_82480_ - (double)((int)hitVec.f_82480_), Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST);
        }
        ArrayList keys = Lists.newArrayList(map.keySet());
        Collections.sort(keys);
        return (Direction)map.get(keys.get(0));
    }

    private void fillMap(Map<Double, Direction> map, double x, double y, Direction ... dirs) {
        map.put(Line2D.ptLineDistSq(0.0, 0.0, 1.0, 0.0, x, y), dirs[0]);
        map.put(Line2D.ptLineDistSq(0.0, 1.0, 1.0, 1.0, x, y), dirs[1]);
        map.put(Line2D.ptLineDistSq(0.0, 0.0, 0.0, 1.0, x, y), dirs[2]);
        map.put(Line2D.ptLineDistSq(1.0, 0.0, 1.0, 1.0, x, y), dirs[3]);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"chisel.tooltip.offset_tool.1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"chisel.tooltip.offset_tool.2").m_130940_(ChatFormatting.GRAY));
    }
}

