/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.network.client;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class AutoChiselFXPacket {
    private final BlockPos pos;
    private final ItemStack chisel;
    private final BlockState state;

    public AutoChiselFXPacket(BlockPos pos, ItemStack chisel, BlockState state) {
        this.pos = pos;
        this.chisel = chisel;
        this.state = state;
    }

    public static void encode(AutoChiselFXPacket packet, FriendlyByteBuf buf) {
        buf.writeLong(packet.pos.m_121878_());
        buf.m_130055_(packet.chisel);
        buf.m_130130_(Block.m_49956_((BlockState)packet.state));
    }

    public static AutoChiselFXPacket decode(FriendlyByteBuf buf) {
        return new AutoChiselFXPacket(BlockPos.m_122022_((long)buf.readLong()), buf.m_130267_(), Block.m_49803_((int)buf.m_130242_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClient(AutoChiselFXPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && level.m_46805_(packet.pos)) {
                double x = (double)packet.pos.m_123341_() + 0.5;
                double y = (double)packet.pos.m_123342_() + 1.0;
                double z = (double)packet.pos.m_123343_() + 0.5;
                for (int i = 0; i < 5; ++i) {
                    double dx = (level.f_46441_.m_188500_() - 0.5) * 0.3;
                    double dy = level.f_46441_.m_188500_() * 0.2;
                    double dz = (level.f_46441_.m_188500_() - 0.5) * 0.3;
                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, packet.state), x, y, z, dx, dy, dz);
                }
                level.m_245747_(packet.pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 0.5f, 1.0f, false);
            }
        });
    }
}

