/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.api.ritual;

import com.Polarice3.Goety.api.ritual.IRitualType;
import com.Polarice3.Goety.common.ritual.type.AdeptNetherRitualType;
import com.Polarice3.Goety.common.ritual.type.AnimationRitualType;
import com.Polarice3.Goety.common.ritual.type.DeepRitualType;
import com.Polarice3.Goety.common.ritual.type.EndRitualType;
import com.Polarice3.Goety.common.ritual.type.ExpertNetherRitualType;
import com.Polarice3.Goety.common.ritual.type.ForgeRitualType;
import com.Polarice3.Goety.common.ritual.type.FrostRitualType;
import com.Polarice3.Goety.common.ritual.type.GeoturgyRitualType;
import com.Polarice3.Goety.common.ritual.type.MagicRitualType;
import com.Polarice3.Goety.common.ritual.type.NecroturgyRitualType;
import com.Polarice3.Goety.common.ritual.type.SabbathRitualType;
import com.Polarice3.Goety.common.ritual.type.SkyRitualType;
import com.Polarice3.Goety.common.ritual.type.StormRitualType;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RitualType {
    public static Map<String, IRitualType> RITUAL_TYPE_LIST = Maps.newHashMap();
    public static IRitualType ANIMATION = new AnimationRitualType();
    public static IRitualType NECROTURGY = new NecroturgyRitualType();
    public static IRitualType FORGE = new ForgeRitualType();
    public static IRitualType MAGIC = new MagicRitualType();
    public static IRitualType ADEPT_NETHER = new AdeptNetherRitualType();
    public static IRitualType EXPERT_NETHER = new ExpertNetherRitualType();
    public static IRitualType SABBATH = new SabbathRitualType();
    public static IRitualType END = new EndRitualType();
    public static IRitualType SKY = new SkyRitualType();
    public static IRitualType STORM = new StormRitualType();
    public static IRitualType GEOTURGY = new GeoturgyRitualType();
    public static IRitualType FROST = new FrostRitualType();
    public static IRitualType DEEP = new DeepRitualType();

    public static void addRitualType(String id, IRitualType ritualType) {
        RITUAL_TYPE_LIST.put(id, ritualType);
    }

    public static Map<String, IRitualType> getRitualTypeList() {
        HashMap rituals = Maps.newHashMap();
        rituals.put(ANIMATION.getName(), ANIMATION);
        rituals.put(NECROTURGY.getName(), NECROTURGY);
        rituals.put(FORGE.getName(), FORGE);
        rituals.put(MAGIC.getName(), MAGIC);
        rituals.put(ADEPT_NETHER.getName(), ADEPT_NETHER);
        rituals.put(EXPERT_NETHER.getName(), EXPERT_NETHER);
        rituals.put(SABBATH.getName(), SABBATH);
        rituals.put(END.getName(), END);
        rituals.put(SKY.getName(), SKY);
        rituals.put(STORM.getName(), STORM);
        rituals.put(GEOTURGY.getName(), GEOTURGY);
        rituals.put(FROST.getName(), FROST);
        rituals.put(DEEP.getName(), DEEP);
        if (!RITUAL_TYPE_LIST.isEmpty()) {
            rituals.putAll(RITUAL_TYPE_LIST);
        }
        return rituals;
    }

    public static List<IRitualType> getAllRitualType() {
        ArrayList<IRitualType> list = new ArrayList<IRitualType>();
        for (IRitualType ritualType : RitualType.getRitualTypeList().values()) {
            if (ritualType == null) continue;
            list.add(ritualType);
        }
        return list;
    }

    public static IRitualType getRitualType(String craftType) {
        if (RitualType.getRitualTypeList().containsKey(craftType)) {
            return RitualType.getRitualTypeList().get(craftType);
        }
        return null;
    }
}

