/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.particles;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.utils.ColorUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.client.Timer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class MagicSmokeParticle
extends TextureSheetParticle {
    public Timer timer;
    public int colorFrom;
    public int colorTo;

    public MagicSmokeParticle(ClientLevel clientLevel, double x, double y, double z, double xd, double yd, double zd, int colorFrom, int colorTo, int duration, float size, float gravity) {
        super(clientLevel, x, y, z, xd, yd, zd);
        this.f_172258_ = 0.96f;
        this.f_107226_ = gravity;
        this.f_172259_ = true;
        this.f_107215_ = xd == 0.0 ? (this.f_107223_.m_188500_() * 2.0 - 1.0) / 10.0 : xd;
        this.f_107216_ = yd == 0.0 ? 0.1 + this.f_107223_.m_188500_() / 10.0 : yd;
        this.f_107217_ = zd == 0.0 ? (this.f_107223_.m_188500_() * 2.0 - 1.0) / 10.0 : zd;
        this.f_107215_ *= 0.5;
        this.f_107217_ *= 0.5;
        ColorUtil colorUtil = new ColorUtil(colorFrom);
        this.f_107227_ = colorUtil.red();
        this.f_107228_ = colorUtil.green();
        this.f_107229_ = colorUtil.blue();
        this.colorFrom = colorFrom;
        this.colorTo = colorTo;
        this.f_107663_ = size;
        this.f_107225_ = duration;
        this.timer = new Timer((float)(duration + 1), 0L);
        this.f_107219_ = true;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public float m_5902_(float p_105642_) {
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + p_105642_) / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        ++this.f_107224_;
        if (this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.f_107216_ -= 0.04 * (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            if (this.f_172259_ && this.f_107213_ == this.f_107210_) {
                this.f_107215_ *= 1.1;
                this.f_107217_ *= 1.1;
            }
            this.f_107215_ *= (double)this.f_172258_;
            this.f_107216_ *= (double)this.f_172258_;
            this.f_107217_ *= (double)this.f_172258_;
            if (this.f_107218_) {
                this.f_107215_ *= (double)0.7f;
                this.f_107217_ *= (double)0.7f;
            }
            this.timer.m_92525_(Util.m_137550_());
            float lerp = ((float)this.f_107224_ + this.timer.f_92518_) / (float)this.f_107225_;
            int newColor = FastColor.ARGB32.m_269105_((float)lerp, (int)this.colorFrom, (int)this.colorTo);
            ColorUtil colorUtil = new ColorUtil(newColor);
            this.f_107227_ = colorUtil.red();
            this.f_107228_ = colorUtil.green();
            this.f_107229_ = colorUtil.blue();
        }
    }

    public int m_6355_(float f) {
        return 0xF000F0;
    }

    public static class Option
    implements ParticleOptions {
        public static final Codec<Option> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("colorFrom").forGetter(Option::getColorFrom), (App)Codec.INT.fieldOf("colorTo").forGetter(Option::getColorTo), (App)ExtraCodecs.f_144629_.fieldOf("duration").forGetter(Option::getDuration), (App)Codec.FLOAT.fieldOf("size").forGetter(Option::getSize), (App)Codec.FLOAT.fieldOf("gravity").forGetter(Option::getGravity)).apply((Applicative)instance, Option::new));
        public static final ParticleOptions.Deserializer<Option> DESERIALIZER = new ParticleOptions.Deserializer<Option>(){

            public Option fromCommand(ParticleType<Option> p_235961_, StringReader p_235962_) throws CommandSyntaxException {
                p_235962_.expect(' ');
                int colorFrom = p_235962_.readInt();
                p_235962_.expect(' ');
                int colorTo = p_235962_.readInt();
                p_235962_.expect(' ');
                int duration = p_235962_.readInt();
                p_235962_.expect(' ');
                float size = p_235962_.readFloat();
                p_235962_.expect(' ');
                float gravity = p_235962_.readFloat();
                return new Option(colorFrom, colorTo, duration, size, gravity);
            }

            public Option fromNetwork(ParticleType<Option> p_235964_, FriendlyByteBuf p_235965_) {
                return new Option(p_235965_.readInt(), p_235965_.readInt(), p_235965_.readInt(), p_235965_.readFloat(), p_235965_.readFloat());
            }
        };
        public int colorFrom;
        public int colorTo;
        public int duration;
        public float size;
        public float gravity;

        public Option(int colorFrom, int colorTo, int duration, float size, float gravity) {
            this.colorFrom = colorFrom;
            this.colorTo = colorTo;
            this.duration = duration;
            this.size = size;
            this.gravity = gravity;
        }

        public Option(int colorFrom, int colorTo, int duration, float size) {
            this(colorFrom, colorTo, duration, size, -0.1f);
        }

        public ParticleType<Option> m_6012_() {
            return (ParticleType)ModParticleTypes.MAGIC_SMOKE.get();
        }

        public void m_7711_(FriendlyByteBuf p_123732_) {
            p_123732_.writeInt(this.getColorFrom());
            p_123732_.writeInt(this.getColorTo());
            p_123732_.writeInt(this.getDuration());
            p_123732_.writeFloat(this.getSize());
            p_123732_.writeFloat(this.getGravity());
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %s %s %s %.2f %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.colorFrom, this.colorTo, this.duration, Float.valueOf(this.size), Float.valueOf(this.gravity));
        }

        public int getColorFrom() {
            return this.colorFrom;
        }

        public int getColorTo() {
            return this.colorTo;
        }

        public int getDuration() {
            return this.duration;
        }

        public float getSize() {
            return this.size;
        }

        public float getGravity() {
            return this.gravity;
        }
    }

    public static class Provider
    implements ParticleProvider<Option> {
        private final SpriteSet sprite;

        public Provider(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(Option option, ClientLevel clientLevel, double d, double e, double f, double g, double h, double i) {
            MagicSmokeParticle trailParticle = new MagicSmokeParticle(clientLevel, d, e, f, g, h, i, option.getColorFrom(), option.getColorTo(), option.getDuration(), option.getSize(), option.getGravity());
            trailParticle.m_108335_(this.sprite);
            return trailParticle;
        }
    }
}

