/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.particles;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.WindTrailParticle;
import com.Polarice3.Goety.utils.ColorUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;

public class WindBlowParticle
extends WindTrailParticle {
    public final int width;
    public final float height;

    public WindBlowParticle(ClientLevel world, double x, double y, double z, double xd, double yd, double zd, float red, float green, float blue, int width, float height, int life) {
        super(world, x, y, z, 0.0, 0.0, 0.0, red, green, blue);
        this.f_107226_ = 0.0f;
        this.f_107215_ *= (double)0.1f;
        this.f_107216_ *= (double)0.1f;
        this.f_107217_ *= (double)0.1f;
        this.f_107215_ += xd;
        this.f_107216_ += yd;
        this.f_107217_ += zd;
        this.f_107225_ = life <= 0 ? 20 + this.f_107223_.m_188503_(20) : life;
        this.width = width;
        this.height = height;
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        this.trailA = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
    }

    @Override
    public float getTrailHeight() {
        return this.height;
    }

    @Override
    public int sampleSize() {
        return this.width;
    }

    public int m_6355_(float pPartialTick) {
        return 240;
    }

    public static class Option
    implements ParticleOptions {
        public static final Codec<Option> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("red").forGetter(d -> Float.valueOf(d.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(d -> Float.valueOf(d.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(d -> Float.valueOf(d.blue)), (App)Codec.INT.fieldOf("width").forGetter(d -> d.width), (App)Codec.FLOAT.fieldOf("height").forGetter(d -> Float.valueOf(d.height)), (App)Codec.INT.fieldOf("life").forGetter(d -> d.life)).apply((Applicative)instance, Option::new));
        public static final ParticleOptions.Deserializer<Option> DESERIALIZER = new ParticleOptions.Deserializer<Option>(){

            public Option fromCommand(ParticleType<Option> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float red = reader.readFloat();
                reader.expect(' ');
                float green = reader.readFloat();
                reader.expect(' ');
                float blue = reader.readFloat();
                reader.expect(' ');
                int width = reader.readInt();
                reader.expect(' ');
                float height = reader.readFloat();
                reader.expect(' ');
                int life = reader.readInt();
                return new Option(red, green, blue, width, height, life);
            }

            public Option fromNetwork(ParticleType<Option> particleTypeIn, FriendlyByteBuf buffer) {
                return new Option(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), buffer.readFloat(), buffer.readInt());
            }
        };
        private final float red;
        private final float green;
        private final float blue;
        private final int width;
        private final float height;
        private final int life;

        public Option(ColorUtil color, int width, float height) {
            this.red = color.red();
            this.green = color.green();
            this.blue = color.blue();
            this.width = width;
            this.height = height;
            this.life = 0;
        }

        public Option(ColorUtil color, int width, float height, int life) {
            this.red = color.red();
            this.green = color.green();
            this.blue = color.blue();
            this.width = width;
            this.height = height;
            this.life = life;
        }

        public Option(float red, float green, float blue, int width, float height, int life) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.width = width;
            this.height = height;
            this.life = life;
        }

        public Option(float red, float green, float blue, int width, float height) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.width = width;
            this.height = height;
            this.life = 0;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.red);
            buffer.writeFloat(this.green);
            buffer.writeFloat(this.blue);
            buffer.writeInt(this.width);
            buffer.writeFloat(this.height);
            buffer.writeInt(this.life);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %d %.2f %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), this.width, Float.valueOf(this.height), this.life);
        }

        public ParticleType<Option> m_6012_() {
            return (ParticleType)ModParticleTypes.WIND_BLOW.get();
        }

        public float getRed() {
            return this.red;
        }

        public float getGreen() {
            return this.green;
        }

        public float getBlue() {
            return this.blue;
        }

        public int getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }

        public int getLife() {
            return this.life;
        }
    }

    public static class Provider
    implements ParticleProvider<Option> {
        public Provider(SpriteSet p_172490_) {
        }

        public Particle createParticle(Option typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new WindBlowParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getRed(), typeIn.getGreen(), typeIn.getBlue(), typeIn.getWidth(), typeIn.getHeight(), typeIn.getLife());
        }
    }
}

