/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.particles;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.utils.ColorUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;

public class WindParticleOption
implements ParticleOptions {
    public static final Codec<WindParticleOption> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("red").forGetter(d -> Float.valueOf(d.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(d -> Float.valueOf(d.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(d -> Float.valueOf(d.blue)), (App)Codec.FLOAT.fieldOf("width").forGetter(d -> Float.valueOf(d.width)), (App)Codec.FLOAT.fieldOf("height").forGetter(d -> Float.valueOf(d.height)), (App)Codec.INT.fieldOf("life").forGetter(d -> d.life), (App)Codec.INT.fieldOf("ownerId").forGetter(d -> d.ownerId)).apply((Applicative)instance, WindParticleOption::new));
    public static final ParticleOptions.Deserializer<WindParticleOption> DESERIALIZER = new ParticleOptions.Deserializer<WindParticleOption>(){

        public WindParticleOption fromCommand(ParticleType<WindParticleOption> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float red = reader.readFloat();
            reader.expect(' ');
            float green = reader.readFloat();
            reader.expect(' ');
            float blue = reader.readFloat();
            reader.expect(' ');
            float width = reader.readFloat();
            reader.expect(' ');
            float height = reader.readFloat();
            reader.expect(' ');
            int life = reader.readInt();
            reader.expect(' ');
            int ownerId = reader.readInt();
            return new WindParticleOption(red, green, blue, width, height, life, ownerId);
        }

        public WindParticleOption fromNetwork(ParticleType<WindParticleOption> particleTypeIn, FriendlyByteBuf buffer) {
            return new WindParticleOption(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), buffer.readInt());
        }
    };
    private final float red;
    private final float green;
    private final float blue;
    private final float width;
    private final float height;
    private final int life;
    private final int ownerId;

    public WindParticleOption(ColorUtil color, float width, float height, int ownerId) {
        this.red = color.red();
        this.green = color.green();
        this.blue = color.blue();
        this.width = width;
        this.height = height;
        this.life = 0;
        this.ownerId = ownerId;
    }

    public WindParticleOption(ColorUtil color, float width, float height, int life, int ownerId) {
        this.red = color.red();
        this.green = color.green();
        this.blue = color.blue();
        this.width = width;
        this.height = height;
        this.life = life;
        this.ownerId = ownerId;
    }

    public WindParticleOption(float red, float green, float blue, float width, float height, int life, int ownerId) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.width = width;
        this.height = height;
        this.life = life;
        this.ownerId = ownerId;
    }

    public WindParticleOption(float red, float green, float blue, float width, float height, int ownerId) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.width = width;
        this.height = height;
        this.life = 0;
        this.ownerId = ownerId;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
        buffer.writeFloat(this.width);
        buffer.writeFloat(this.height);
        buffer.writeInt(this.life);
        buffer.writeInt(this.ownerId);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %d %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.width), Float.valueOf(this.height), this.life, this.ownerId);
    }

    public ParticleType<WindParticleOption> m_6012_() {
        return (ParticleType)ModParticleTypes.WIND.get();
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public int getLife() {
        return this.life;
    }

    public int getOwnerId() {
        return this.ownerId;
    }
}

