/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.EndersentModel;
import com.Polarice3.Goety.common.entities.hostile.ender.Endersent;
import com.Polarice3.Goety.common.entities.neutral.ender.AbstractEnderling;
import com.Polarice3.Goety.utils.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EndersentRenderer<T extends Endersent>
extends MobRenderer<T, EndersentModel<T>> {
    protected static final ResourceLocation TEXTURE_LOCATION = Goety.location("textures/entity/enderling/endersent.png");
    protected static final ResourceLocation DEATH = Goety.location("textures/entity/enderling/endersent_death.png");

    public EndersentRenderer(EntityRendererProvider.Context p_i47208_1_) {
        super(p_i47208_1_, new EndersentModel(p_i47208_1_.m_174023_(ModModelLayer.ENDERSENT)), 0.75f);
        this.m_115326_(new EnchantedLayer(this, p_i47208_1_.m_174027_()));
        this.m_115326_((RenderLayer)new GlowLayer(this));
        this.m_115326_((RenderLayer)new EnderEyeLayer(this));
    }

    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        if (((Endersent)pEntity).deathTime > 0) {
            pMatrixStack.m_85836_();
            boolean flag = ((Endersent)pEntity).f_20916_ > 0;
            float f = Mth.m_14189_((float)pPartialTicks, (float)((Endersent)pEntity).f_20884_, (float)((Endersent)pEntity).f_20883_);
            float f1 = Mth.m_14189_((float)pPartialTicks, (float)((Endersent)pEntity).f_20886_, (float)((Endersent)pEntity).f_20885_);
            float f2 = f1 - f;
            float f6 = Mth.m_14179_((float)pPartialTicks, (float)((Endersent)pEntity).f_19860_, (float)pEntity.m_146909_());
            float f71 = this.m_6930_((LivingEntity)pEntity, pPartialTicks);
            this.m_7523_((LivingEntity)pEntity, pMatrixStack, f71, f, pPartialTicks);
            pMatrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
            this.m_7546_((LivingEntity)pEntity, pMatrixStack, pPartialTicks);
            pMatrixStack.m_85837_(0.0, (double)-1.501f, 0.0);
            ((EndersentModel)this.f_115290_).m_6839_((Entity)pEntity, 0.0f, 0.0f, pPartialTicks);
            ((EndersentModel)this.f_115290_).setupAnim(pEntity, 0.0f, 0.0f, f71, f2, f6);
            float f8 = MathHelper.secondsToTicks(4);
            float f9 = (float)((Endersent)pEntity).deathTime / f8;
            float f10 = 1.0f - (float)((Endersent)pEntity).deathTime / f8;
            VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_173235_((ResourceLocation)DEATH));
            ((EndersentModel)this.f_115290_).m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, f9);
            VertexConsumer ivertexbuilder1 = pBuffer.m_6299_(RenderType.m_110479_((ResourceLocation)this.getTextureLocation(pEntity)));
            ((EndersentModel)this.f_115290_).m_7695_(pMatrixStack, ivertexbuilder1, pPackedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), f10, f10, f10, 1.0f);
            pMatrixStack.m_85849_();
        }
    }

    @Nullable
    protected RenderType getRenderType(T p_230496_1_, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        if (((Endersent)p_230496_1_).deathTime > 0) {
            return RenderType.m_173235_((ResourceLocation)DEATH);
        }
        return super.m_7225_(p_230496_1_, p_230496_2_, p_230496_3_, p_230496_4_);
    }

    public ResourceLocation getTextureLocation(T pEntity) {
        return TEXTURE_LOCATION;
    }

    public static class EnchantedLayer<T extends Endersent, M extends EndersentModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation ARMOR = Goety.location("textures/entity/enderling/endersent_glint.png");
        private final EndersentModel<T> model;

        public EnchantedLayer(RenderLayerParent<T, M> p_116967_, EntityModelSet p_174555_) {
            super(p_116967_);
            this.model = new EndersentModel(p_174555_.m_171103_(ModModelLayer.ENDERSENT));
        }

        public void render(PoseStack p_116970_, MultiBufferSource p_116971_, int p_116972_, T p_116973_, float p_116974_, float p_116975_, float p_116976_, float p_116977_, float p_116978_, float p_116979_) {
            if (((Endersent)p_116973_).hasEye() && !((AbstractEnderling)p_116973_).m_20145_() && !p_116973_.m_21224_()) {
                float f = (float)((Endersent)p_116973_).f_19797_ + p_116976_;
                EndersentModel<T> entitymodel = this.model;
                entitymodel.m_6839_((Entity)p_116973_, p_116974_, p_116975_, p_116976_);
                ((EndersentModel)this.m_117386_()).m_102624_((EntityModel)entitymodel);
                VertexConsumer vertexconsumer = p_116971_.m_6299_(RenderType.m_110436_((ResourceLocation)ARMOR, (float)(this.xOffset(f) % 1.0f), (float)(f * 0.01f % 1.0f)));
                entitymodel.setupAnim(p_116973_, p_116974_, p_116975_, p_116977_, p_116978_, p_116979_);
                entitymodel.m_7695_(p_116970_, vertexconsumer, p_116972_, OverlayTexture.f_118083_, 0.5f, 0.5f, 0.5f, 1.0f);
                entitymodel.ender_eye.f_104207_ = false;
            }
        }

        protected float xOffset(float p_225634_1_) {
            return Mth.m_14089_((float)(p_225634_1_ * 0.02f)) * 3.0f;
        }
    }

    public static class GlowLayer<T extends Endersent, M extends EndersentModel<T>>
    extends EyesLayer<T, M> {
        private static final RenderType RENDER_TYPE = RenderType.m_110488_((ResourceLocation)Goety.location("textures/entity/enderling/endersent_glow.png"));

        public GlowLayer(RenderLayerParent<T, M> p_i50919_1_) {
            super(p_i50919_1_);
        }

        public void render(PoseStack p_116983_, MultiBufferSource p_116984_, int p_116985_, T p_116986_, float p_116987_, float p_116988_, float p_116989_, float p_116990_, float p_116991_, float p_116992_) {
            if (!((AbstractEnderling)p_116986_).m_20145_() && !p_116986_.m_21224_()) {
                VertexConsumer vertexconsumer = p_116984_.m_6299_(this.m_5708_());
                ((EndersentModel)this.m_117386_()).m_7695_(p_116983_, vertexconsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }

        public RenderType m_5708_() {
            return RENDER_TYPE;
        }
    }

    public static class EnderEyeLayer<T extends Endersent, M extends EndersentModel<T>>
    extends EyesLayer<T, M> {
        private static final RenderType RENDER_TYPE = RenderType.m_110452_((ResourceLocation)Goety.location("textures/entity/enderling/endersent_eye.png"));

        public EnderEyeLayer(RenderLayerParent<T, M> p_i50919_1_) {
            super(p_i50919_1_);
        }

        public void render(PoseStack p_116983_, MultiBufferSource p_116984_, int p_116985_, T p_116986_, float p_116987_, float p_116988_, float p_116989_, float p_116990_, float p_116991_, float p_116992_) {
            if (!((AbstractEnderling)p_116986_).m_20145_() && !p_116986_.m_21224_() && ((Endersent)p_116986_).hasEye()) {
                VertexConsumer vertexconsumer = p_116984_.m_6299_(this.m_5708_());
                ((EndersentModel)this.m_117386_()).m_7695_(p_116983_, vertexconsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }

        public RenderType m_5708_() {
            return RENDER_TYPE;
        }
    }
}

