/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.BlackWolfModel;
import com.Polarice3.Goety.common.entities.ally.BlackWolf;
import com.Polarice3.Goety.common.entities.ally.Hellhound;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class HellhoundRenderer
extends MobRenderer<Hellhound, BlackWolfModel<Hellhound>> {
    private static final ResourceLocation TEXTURES = Goety.location("textures/entity/servants/black_wolf/hellhound.png");

    public HellhoundRenderer(EntityRendererProvider.Context p_174452_) {
        super(p_174452_, new BlackWolfModel(p_174452_.m_174023_(ModModelLayer.BLACK_WOLF)), 0.5f);
        this.m_115326_((RenderLayer)new WolfEyesLayer(this));
        this.m_115326_(new ChainsLayer(this, p_174452_.m_174027_()));
        this.m_115326_(new BigFurLayer(this, p_174452_.m_174027_()));
    }

    protected void scale(Hellhound p_115314_, PoseStack p_115315_, float p_115316_) {
        boolean i = p_115314_.isUpgraded();
        float f = 1.0f + 0.15f * (float)i;
        p_115315_.m_85841_(f, f, f);
    }

    protected float getBob(Hellhound p_116528_, float p_116529_) {
        return p_116528_.getTailAngle();
    }

    public void render(Hellhound p_116531_, float p_116532_, float p_116533_, PoseStack p_116534_, MultiBufferSource p_116535_, int p_116536_) {
        if (p_116531_.isWet()) {
            float f = p_116531_.getWetShade(p_116533_);
            ((BlackWolfModel)this.f_115290_).setColor(f, f, f);
        }
        super.m_7392_((Mob)p_116531_, p_116532_, p_116533_, p_116534_, p_116535_, p_116536_);
        if (p_116531_.isWet()) {
            ((BlackWolfModel)this.f_115290_).setColor(1.0f, 1.0f, 1.0f);
        }
    }

    public ResourceLocation getTextureLocation(Hellhound p_116526_) {
        return TEXTURES;
    }

    public static class WolfEyesLayer<T extends Hellhound, M extends BlackWolfModel<T>>
    extends EyesLayer<T, M> {
        private static final ResourceLocation TEXTURES = Goety.location("textures/entity/servants/black_wolf/hellhound_eyes.png");

        public WolfEyesLayer(RenderLayerParent<T, M> p_117346_) {
            super(p_117346_);
        }

        @NotNull
        public RenderType m_5708_() {
            return RenderType.m_110488_((ResourceLocation)TEXTURES);
        }
    }

    public static class ChainsLayer<T extends Hellhound, M extends BlackWolfModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation TEXTURES = Goety.location("textures/entity/servants/black_wolf/hellhound_chains.png");
        private final BlackWolfModel<T> layerModel;

        public ChainsLayer(RenderLayerParent<T, M> p_117346_, EntityModelSet p_174555_) {
            super(p_117346_);
            this.layerModel = new BlackWolfModel(p_174555_.m_171103_(ModModelLayer.BLACK_WOLF));
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T blackHound, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!((Owned)blackHound).isNatural()) {
                ChainsLayer.m_117359_((EntityModel)this.m_117386_(), this.layerModel, (ResourceLocation)TEXTURES, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, blackHound, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    public static class BigFurLayer<T extends BlackWolf, M extends BlackWolfModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation TEXTURES = Goety.location("textures/entity/servants/black_wolf/hellhound_fur.png");
        private final BlackWolfModel<T> layerModel;

        public BigFurLayer(RenderLayerParent<T, M> p_117346_, EntityModelSet p_174555_) {
            super(p_117346_);
            this.layerModel = new BlackWolfModel(p_174555_.m_171103_(ModModelLayer.BLACK_WOLF));
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T blackHound, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (((Summoned)blackHound).isUpgraded()) {
                BigFurLayer.m_117359_((EntityModel)this.m_117386_(), this.layerModel, (ResourceLocation)TEXTURES, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, blackHound, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

