/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.layer.HierarchicalArmor;
import com.Polarice3.Goety.common.entities.ally.undead.bound.AbstractBoundIllager;
import com.Polarice3.Goety.utils.MathHelper;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class BoundIllagerAnimatedModel<T extends AbstractBoundIllager>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel,
HierarchicalArmor {
    private final ModelPart root;
    private final ModelPart illager;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart arms;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart cape;
    public HumanoidModel.ArmPose leftArmPose = HumanoidModel.ArmPose.EMPTY;
    public HumanoidModel.ArmPose rightArmPose = HumanoidModel.ArmPose.EMPTY;

    public BoundIllagerAnimatedModel(ModelPart root) {
        this.root = root;
        this.illager = root.m_171324_("illager");
        this.body = this.illager.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.arms = this.body.m_171324_("arms");
        this.RightArm = this.body.m_171324_("RightArm");
        this.LeftArm = this.body.m_171324_("LeftArm");
        this.cape = this.body.m_171324_("cape");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition illager = partdefinition.m_171599_("illager", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = illager.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition hood = head.m_171599_("hood", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-5.5f, -11.5f, -4.5f, 9.0f, 11.0f, 9.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)1.0f, (float)1.0f, (float)0.0f));
        PartDefinition arms = body.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171488_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(44, 22).m_171480_().m_171488_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(40, 38).m_171488_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition LeftArm = body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition cape = body.m_171599_("cape", CubeListBuilder.m_171558_().m_171514_(68, 0).m_171488_(-4.5f, -1.0f, -0.5f, 9.0f, 20.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)3.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        if (this.f_102609_) {
            this.RightArm.f_104203_ = -0.62831855f;
            this.RightArm.f_104204_ = 0.0f;
            this.RightArm.f_104205_ = 0.0f;
            this.LeftArm.f_104203_ = -0.62831855f;
        } else {
            this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.RightArm.f_104204_ = 0.0f;
            this.RightArm.f_104205_ = 0.0f;
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        }
        float f = 1.0f;
        if (entity.m_21256_() > 4) {
            f = (float)entity.m_20184_().m_82556_();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.cape.f_104203_ = MathHelper.modelDegrees(10.0f) + Mth.m_14154_((float)(Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.7f * limbSwingAmount / f));
        this.LeftArm.f_104204_ = 0.0f;
        this.LeftArm.f_104205_ = 0.0f;
        AbstractBoundIllager.BoundArmPose armPose = ((AbstractBoundIllager)entity).getArmPose();
        this.arms.f_104207_ = flag = armPose == AbstractBoundIllager.BoundArmPose.CROSSED;
        this.LeftArm.f_104207_ = !flag;
        boolean bl = this.RightArm.f_104207_ = !flag;
        if (flag) {
            this.RightArm.f_104203_ = -0.75f;
            this.LeftArm.f_104203_ = -0.75f;
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.LeftArm : this.RightArm;
    }

    public void m_6002_(HumanoidArm p_102925_, PoseStack p_102926_) {
        this.illager.m_104299_(p_102926_);
        this.body.m_104299_(p_102926_);
        this.getArm(p_102925_).m_104299_(p_102926_);
    }

    @Override
    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
    }

    @Override
    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    @Override
    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
    }

    @Override
    public void translateToArms(ModelPart modelPart, PoseStack poseStack) {
        this.illager.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    @Override
    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.RightArm);
    }

    @Override
    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.LeftArm);
    }

    @Override
    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    @Override
    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }
}

