/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.common.entities.hostile.cultists.Cultist;
import com.Polarice3.Goety.utils.MathHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;

public class CultistModel<T extends Cultist>
extends HumanoidModel<T> {
    public ModelPart clothes;
    public ModelPart arms;
    public ModelPart all;
    protected final ModelPart nose;

    public CultistModel(ModelPart p_170677_) {
        super(p_170677_);
        this.all = p_170677_;
        this.clothes = p_170677_.m_171324_("clothes");
        this.arms = p_170677_.m_171324_("arms");
        this.nose = this.f_102808_.m_171324_("nose");
    }

    public static MeshDefinition createMesh() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", new CubeListBuilder().m_171514_(0, 0).m_171481_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.f_171404_);
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.05f)), PartPose.f_171404_);
        partdefinition.m_171599_("clothes", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.05f)), PartPose.f_171404_);
        partdefinition.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171481_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).m_171514_(44, 22).m_171480_().m_171506_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, true).m_171514_(40, 38).m_171481_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        return meshdefinition;
    }

    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)CultistModel.createMesh(), (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), (Iterable)ImmutableList.of((Object)this.arms, (Object)this.clothes, (Object)this.all));
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        this.f_102808_.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.f_102808_.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.f_102809_.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.f_102809_.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.arms.f_104202_ = -1.0f;
        this.arms.f_104203_ = -0.75f;
        if (this.f_102609_) {
            this.f_102811_.f_104203_ = -0.62831855f;
            this.f_102811_.f_104204_ = 0.0f;
            this.f_102811_.f_104205_ = 0.0f;
            this.f_102812_.f_104203_ = -0.62831855f;
            this.f_102812_.f_104204_ = 0.0f;
            this.f_102812_.f_104205_ = 0.0f;
            this.f_102813_.f_104203_ = -1.4137167f;
            this.f_102813_.f_104204_ = 0.31415927f;
            this.f_102813_.f_104205_ = 0.07853982f;
            this.f_102814_.f_104203_ = -1.4137167f;
            this.f_102814_.f_104204_ = -0.31415927f;
            this.f_102814_.f_104205_ = -0.07853982f;
        } else {
            this.arms.f_104201_ = 3.0f;
            this.f_102811_.f_104201_ = 2.0f;
            this.f_102812_.f_104201_ = 2.0f;
            this.f_102811_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.f_102811_.f_104204_ = 0.0f;
            this.f_102811_.f_104205_ = 0.0f;
            this.f_102812_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.f_102812_.f_104204_ = 0.0f;
            this.f_102812_.f_104205_ = 0.0f;
            this.f_102813_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            this.f_102813_.f_104204_ = 0.0f;
            this.f_102813_.f_104205_ = 0.0f;
            this.f_102814_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
            this.f_102814_.f_104204_ = 0.0f;
            this.f_102814_.f_104205_ = 0.0f;
        }
        Cultist.CultistArmPose cultistArmPose = ((Cultist)entityIn).getArmPose();
        switch (cultistArmPose) {
            case CROSSED: {
                this.f_102811_.f_104203_ = 0.0f;
                this.f_102812_.f_104203_ = 0.0f;
                break;
            }
            case ATTACKING: {
                if (entityIn.m_21205_().m_41619_() || entityIn.m_21205_().m_41720_() instanceof ProjectileWeaponItem) break;
                AnimationUtils.m_102091_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, entityIn, (float)this.f_102608_, (float)ageInTicks);
                break;
            }
            case BOMB_AND_WEAPON: {
                if (!entityIn.m_21205_().m_41619_() && !(entityIn.m_21205_().m_41720_() instanceof ProjectileWeaponItem)) {
                    if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
                        AnimationUtils.m_102091_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, entityIn, (float)this.f_102608_, (float)ageInTicks);
                    } else {
                        AnimationUtils.m_102091_((ModelPart)this.f_102812_, (ModelPart)this.f_102811_, entityIn, (float)this.f_102608_, (float)ageInTicks);
                    }
                }
                if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
                    this.f_102812_.f_104202_ = 0.0f;
                    this.f_102812_.f_104200_ = 5.0f;
                    this.f_102812_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                    this.f_102812_.f_104205_ = -2.3561945f;
                    this.f_102812_.f_104204_ = 0.0f;
                    break;
                }
                this.f_102811_.f_104202_ = 0.0f;
                this.f_102811_.f_104200_ = -5.0f;
                this.f_102811_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.f_102811_.f_104205_ = 2.3561945f;
                this.f_102811_.f_104204_ = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.f_102811_.f_104204_ = -0.1f + this.f_102808_.f_104204_;
                this.f_102812_.f_104204_ = 0.1f + this.f_102808_.f_104204_ + 0.4f;
                this.f_102811_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
                this.f_102812_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
                break;
            }
            case THROW_SPEAR: {
                if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
                    this.f_102811_.f_104203_ = this.f_102811_.f_104203_ * 0.5f - (float)Math.PI;
                    this.f_102811_.f_104204_ = 0.0f;
                    break;
                }
                this.f_102812_.f_104203_ = this.f_102812_.f_104203_ * 0.5f - (float)Math.PI;
                this.f_102812_.f_104204_ = 0.0f;
                break;
            }
            case CROSSBOW_CHARGE: {
                AnimationUtils.m_102086_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, entityIn, (boolean)true);
                break;
            }
            case CROSSBOW_HOLD: {
                AnimationUtils.m_102097_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (ModelPart)this.f_102808_, (boolean)true);
                break;
            }
            case SPELLCASTING: {
                this.f_102811_.f_104202_ = 0.0f;
                this.f_102811_.f_104200_ = -5.0f;
                this.f_102812_.f_104202_ = 0.0f;
                this.f_102812_.f_104200_ = 5.0f;
                this.f_102811_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.f_102812_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.f_102811_.f_104205_ = 2.3561945f;
                this.f_102812_.f_104205_ = -2.3561945f;
                this.f_102811_.f_104204_ = 0.0f;
                this.f_102812_.f_104204_ = 0.0f;
                break;
            }
            case PRAYING: {
                this.f_102811_.f_104203_ = MathHelper.modelDegrees(125.0f);
                this.f_102812_.f_104203_ = MathHelper.modelDegrees(125.0f);
                this.f_102808_.f_104203_ = MathHelper.modelDegrees(30.0f);
                break;
            }
            case SPELL_AND_WEAPON: {
                if (!entityIn.m_21205_().m_41619_()) {
                    AnimationUtils.m_102091_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, entityIn, (float)this.f_102608_, (float)ageInTicks);
                }
                if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
                    this.f_102812_.f_104202_ = 0.0f;
                    this.f_102812_.f_104200_ = 5.0f;
                    this.f_102812_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                    this.f_102812_.f_104205_ = -2.3561945f;
                    this.f_102812_.f_104204_ = 0.0f;
                    break;
                }
                this.f_102811_.f_104202_ = 0.0f;
                this.f_102811_.f_104200_ = -5.0f;
                this.f_102811_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.f_102811_.f_104205_ = 2.3561945f;
                this.f_102811_.f_104204_ = 0.0f;
                break;
            }
            case TORCH_AND_WEAPON: {
                if (!entityIn.m_21205_().m_41619_() && !(entityIn.m_21205_().m_41720_() instanceof ProjectileWeaponItem)) {
                    if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
                        AnimationUtils.m_102091_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, entityIn, (float)this.f_102608_, (float)ageInTicks);
                    } else {
                        AnimationUtils.m_102091_((ModelPart)this.f_102812_, (ModelPart)this.f_102811_, entityIn, (float)this.f_102608_, (float)ageInTicks);
                    }
                }
                if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
                    this.f_102812_.f_104203_ = -(2.0f + Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.15f);
                    break;
                }
                this.f_102811_.f_104203_ = -(2.0f + Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.15f);
                break;
            }
            case ITEM: {
                this.f_102808_.f_104203_ = 0.5f;
                this.f_102808_.f_104204_ = 0.0f;
                this.f_102809_.f_104203_ = 0.5f;
                this.f_102809_.f_104204_ = 0.0f;
                if (entityIn.m_21526_()) {
                    this.f_102811_.f_104204_ = -0.5f;
                    this.f_102811_.f_104203_ = -0.9f;
                    break;
                }
                this.f_102812_.f_104204_ = 0.5f;
                this.f_102812_.f_104203_ = -0.9f;
                break;
            }
            case DYING: {
                if (!entityIn.m_21224_()) break;
                this.f_102811_.f_104202_ = 0.0f;
                this.f_102811_.f_104200_ = -5.0f;
                this.f_102812_.f_104202_ = 0.0f;
                this.f_102812_.f_104200_ = 5.0f;
                this.f_102811_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.f_102812_.f_104203_ = -Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.f_102811_.f_104205_ = 2.3561945f;
                this.f_102812_.f_104205_ = -2.3561945f;
                this.f_102813_.f_104203_ = 0.0f;
                this.f_102813_.f_104204_ = 0.0f;
                this.f_102813_.f_104205_ = 0.0f;
                this.f_102814_.f_104203_ = 0.0f;
                this.f_102814_.f_104204_ = 0.0f;
                this.f_102814_.f_104205_ = 0.0f;
                this.f_102808_.f_104203_ = -MathHelper.modelDegrees(25.0f);
                this.f_102809_.f_104203_ = -MathHelper.modelDegrees(25.0f);
            }
        }
        if (this.f_102815_ == HumanoidModel.ArmPose.THROW_SPEAR) {
            this.f_102812_.f_104203_ = this.f_102812_.f_104203_ * 0.5f - (float)Math.PI;
            this.f_102812_.f_104204_ = 0.0f;
        }
        if (this.f_102816_ == HumanoidModel.ArmPose.THROW_SPEAR) {
            this.f_102811_.f_104203_ = this.f_102811_.f_104203_ * 0.5f - (float)Math.PI;
            this.f_102811_.f_104204_ = 0.0f;
        }
        this.arms.f_104207_ = flag = cultistArmPose == Cultist.CultistArmPose.CROSSED;
        this.f_102812_.f_104207_ = !flag;
        this.f_102811_.f_104207_ = !flag;
        boolean flag2 = entityIn.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ArmorItem || entityIn.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ArmorItem;
        this.clothes.f_104207_ = !flag2;
    }

    public boolean isAggressive(T entityIn) {
        return entityIn.m_5912_();
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.f_102816_ = HumanoidModel.ArmPose.EMPTY;
        this.f_102815_ = HumanoidModel.ArmPose.EMPTY;
        if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
            this.RightArmPoses(InteractionHand.MAIN_HAND, entityIn);
            this.LeftArmPoses(InteractionHand.OFF_HAND, entityIn);
        } else {
            this.RightArmPoses(InteractionHand.OFF_HAND, entityIn);
            this.LeftArmPoses(InteractionHand.MAIN_HAND, entityIn);
        }
        ItemStack itemstack = entityIn.m_21120_(InteractionHand.MAIN_HAND);
        if (itemstack.m_41720_() == Items.f_42411_ && entityIn.m_5912_()) {
            if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
                this.f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.f_102815_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
        if (itemstack.m_41720_() instanceof TridentItem && entityIn.m_5912_()) {
            if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
                this.f_102816_ = HumanoidModel.ArmPose.THROW_SPEAR;
            } else {
                this.f_102815_ = HumanoidModel.ArmPose.THROW_SPEAR;
            }
        }
        super.m_6839_(entityIn, limbSwing, limbSwingAmount, partialTick);
    }

    private void RightArmPoses(InteractionHand hand, T entityIn) {
        ItemStack itemstack = entityIn.m_21120_(hand);
        UseAnim useAction = itemstack.m_41780_();
        if (((Cultist)entityIn).getArmPose() != Cultist.CultistArmPose.CROSSED) {
            switch (useAction) {
                case CROSSBOW: {
                    this.f_102816_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                    if (!entityIn.m_6117_()) break;
                    this.f_102816_ = HumanoidModel.ArmPose.CROSSBOW_CHARGE;
                    break;
                }
                case BOW: {
                    this.f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
                    break;
                }
                case SPEAR: {
                    this.f_102816_ = HumanoidModel.ArmPose.THROW_SPEAR;
                    break;
                }
                default: {
                    this.f_102816_ = HumanoidModel.ArmPose.EMPTY;
                    if (itemstack.m_41619_()) break;
                    this.f_102816_ = HumanoidModel.ArmPose.ITEM;
                }
            }
        }
    }

    private void LeftArmPoses(InteractionHand hand, T entityIn) {
        ItemStack itemstack = entityIn.m_21120_(hand);
        UseAnim useAction = itemstack.m_41780_();
        if (((Cultist)entityIn).getArmPose() != Cultist.CultistArmPose.CROSSED) {
            switch (useAction) {
                case CROSSBOW: {
                    this.f_102815_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                    if (!entityIn.m_6117_()) break;
                    this.f_102815_ = HumanoidModel.ArmPose.CROSSBOW_CHARGE;
                    break;
                }
                case BOW: {
                    this.f_102815_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
                    break;
                }
                case SPEAR: {
                    this.f_102815_ = HumanoidModel.ArmPose.THROW_SPEAR;
                    break;
                }
                default: {
                    this.f_102815_ = HumanoidModel.ArmPose.EMPTY;
                    if (itemstack.m_41619_()) break;
                    this.f_102815_ = HumanoidModel.ArmPose.ITEM;
                }
            }
        }
    }

    private ModelPart getthisArm(HumanoidArm p_191216_1_) {
        return p_191216_1_ == HumanoidArm.LEFT ? this.f_102812_ : this.f_102811_;
    }

    public ModelPart func_205062_a() {
        return this.f_102809_;
    }

    public ModelPart m_5585_() {
        return this.f_102808_;
    }

    public void m_6002_(HumanoidArm sideIn, PoseStack matrixStackIn) {
        this.getthisArm(sideIn).m_104299_(matrixStackIn);
    }
}

