/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.common.entities.ally.GuardianServant;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class GuardianServantModel
extends HierarchicalModel<GuardianServant> {
    private static final float[] SPIKE_X_ROT = new float[]{1.75f, 0.25f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f, 0.5f, 1.25f, 0.75f, 0.0f, 0.0f};
    private static final float[] SPIKE_Y_ROT = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.25f, 1.75f, 1.25f, 0.75f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static final float[] SPIKE_Z_ROT = new float[]{0.0f, 0.0f, 0.25f, 1.75f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.75f, 1.25f};
    private static final float[] SPIKE_X = new float[]{0.0f, 0.0f, 8.0f, -8.0f, -8.0f, 8.0f, 8.0f, -8.0f, 0.0f, 0.0f, 8.0f, -8.0f};
    private static final float[] SPIKE_Y = new float[]{-8.0f, -8.0f, -8.0f, -8.0f, 0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f};
    private static final float[] SPIKE_Z = new float[]{8.0f, -8.0f, 0.0f, 0.0f, -8.0f, -8.0f, 8.0f, 8.0f, 8.0f, -8.0f, 0.0f, 0.0f};
    private static final String EYE = "eye";
    private static final String TAIL_0 = "tail0";
    private static final String TAIL_1 = "tail1";
    private static final String TAIL_2 = "tail2";
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart eye;
    private final ModelPart[] spikeParts;
    private final ModelPart[] tailParts;

    public GuardianServantModel(ModelPart p_170600_) {
        this.root = p_170600_;
        this.spikeParts = new ModelPart[12];
        this.head = p_170600_.m_171324_("head");
        for (int i = 0; i < this.spikeParts.length; ++i) {
            this.spikeParts[i] = this.head.m_171324_(GuardianServantModel.createSpikeName(i));
        }
        this.eye = this.head.m_171324_(EYE);
        this.tailParts = new ModelPart[3];
        this.tailParts[0] = this.head.m_171324_(TAIL_0);
        this.tailParts[1] = this.tailParts[0].m_171324_(TAIL_1);
        this.tailParts[2] = this.tailParts[1].m_171324_(TAIL_2);
    }

    private static String createSpikeName(int p_170603_) {
        return "spike" + p_170603_;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(GuardianServant p_102719_, float p_102720_, float p_102721_, float p_102722_, float p_102723_, float p_102724_) {
        float f = p_102722_ - (float)p_102719_.f_19797_;
        this.head.f_104204_ = p_102723_ * ((float)Math.PI / 180);
        this.head.f_104203_ = p_102724_ * ((float)Math.PI / 180);
        float f1 = (1.0f - p_102719_.getSpikesAnimation(f)) * 0.55f;
        this.setupSpikes(p_102722_, f1);
        Entity entity = Minecraft.m_91087_().m_91288_();
        if (p_102719_.hasActiveAttackTarget()) {
            entity = p_102719_.getActiveAttackTarget();
        }
        if (entity != null) {
            Vec3 vec3 = entity.m_20299_(0.0f);
            Vec3 vec31 = p_102719_.m_20299_(0.0f);
            double d0 = vec3.f_82480_ - vec31.f_82480_;
            this.eye.f_104201_ = d0 > 0.0 ? 0.0f : 1.0f;
            Vec3 vec32 = p_102719_.m_20252_(0.0f);
            vec32 = new Vec3(vec32.f_82479_, 0.0, vec32.f_82481_);
            Vec3 vec33 = new Vec3(vec31.f_82479_ - vec3.f_82479_, 0.0, vec31.f_82481_ - vec3.f_82481_).m_82541_().m_82524_(1.5707964f);
            double d1 = vec32.m_82526_(vec33);
            this.eye.f_104200_ = Mth.m_14116_((float)((float)Math.abs(d1))) * 2.0f * (float)Math.signum(d1);
        }
        this.eye.f_104207_ = true;
        float f2 = p_102719_.getTailAnimation(f);
        this.tailParts[0].f_104204_ = Mth.m_14031_((float)f2) * (float)Math.PI * 0.05f;
        this.tailParts[1].f_104204_ = Mth.m_14031_((float)f2) * (float)Math.PI * 0.1f;
        this.tailParts[2].f_104204_ = Mth.m_14031_((float)f2) * (float)Math.PI * 0.15f;
    }

    private void setupSpikes(float p_102709_, float p_102710_) {
        for (int i = 0; i < 12; ++i) {
            this.spikeParts[i].f_104200_ = GuardianServantModel.getSpikeX(i, p_102709_, p_102710_);
            this.spikeParts[i].f_104201_ = GuardianServantModel.getSpikeY(i, p_102709_, p_102710_);
            this.spikeParts[i].f_104202_ = GuardianServantModel.getSpikeZ(i, p_102709_, p_102710_);
        }
    }

    private static float getSpikeOffset(int p_170605_, float p_170606_, float p_170607_) {
        return 1.0f + Mth.m_14089_((float)(p_170606_ * 1.5f + (float)p_170605_)) * 0.01f - p_170607_;
    }

    private static float getSpikeX(int p_170610_, float p_170611_, float p_170612_) {
        return SPIKE_X[p_170610_] * GuardianServantModel.getSpikeOffset(p_170610_, p_170611_, p_170612_);
    }

    private static float getSpikeY(int p_170614_, float p_170615_, float p_170616_) {
        return 16.0f + SPIKE_Y[p_170614_] * GuardianServantModel.getSpikeOffset(p_170614_, p_170615_, p_170616_);
    }

    private static float getSpikeZ(int p_170618_, float p_170619_, float p_170620_) {
        return SPIKE_Z[p_170618_] * GuardianServantModel.getSpikeOffset(p_170618_, p_170619_, p_170620_);
    }
}

