/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.common.entities.ally.undead.Haunt;
import com.Polarice3.Goety.utils.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class HauntModel<T extends Haunt>
extends HierarchicalModel<T> {
    private final ModelPart haunt;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart tail;
    private final ModelPart tail1;

    public HauntModel(ModelPart root) {
        this.haunt = root.m_171324_("haunt");
        this.rightArm = this.haunt.m_171324_("right_arm");
        this.leftArm = this.haunt.m_171324_("left_arm");
        this.tail = this.haunt.m_171324_("tail");
        this.tail1 = this.tail.m_171324_("tail1");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition haunt = partdefinition.m_171599_("haunt", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition body = haunt.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition tail = haunt.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(12, 16).m_171488_(-2.5f, 3.0f, -2.5f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition tail1 = tail.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.5f, 1.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition right_arm = haunt.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171480_().m_171488_(-2.0f, -1.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)-10.0f, (float)0.0f));
        PartDefinition left_arm = haunt.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(0.0f, -1.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-10.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float pLimbSwingAmount, float pAgeInTicks, float netHeadYaw, float headPitch) {
        float f = pAgeInTicks * 0.0025f;
        this.haunt.f_104201_ = Mth.m_14031_((float)(f * 40.0f)) + 22.0f;
        float f4 = Math.min(pLimbSwingAmount / 0.3f, 1.0f);
        this.haunt.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.haunt.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.tail.f_104203_ = f4 * MathHelper.modelDegrees(22.5f);
        this.tail.f_104203_ += Mth.m_14089_((float)(pAgeInTicks * 0.09f)) * 0.1f + 0.1f;
        this.tail1.f_104203_ = f4 * MathHelper.modelDegrees(40.0f);
        this.tail1.f_104203_ += Mth.m_14089_((float)(pAgeInTicks * 0.09f)) * 0.1f + 0.1f;
        HauntModel.animateArms(this.leftArm, this.rightArm, this.isAggressive(entity), this.f_102608_, pAgeInTicks);
    }

    public boolean isAggressive(T entityIn) {
        return entityIn.m_5912_();
    }

    public static void animateArms(ModelPart p_102103_, ModelPart p_102104_, boolean isAggressive, float p_102106_, float p_102107_) {
        float f2;
        float f = Mth.m_14031_((float)(p_102106_ * (float)Math.PI));
        float f1 = Mth.m_14031_((float)((1.0f - (1.0f - p_102106_) * (1.0f - p_102106_)) * (float)Math.PI));
        p_102104_.f_104205_ = 0.0f;
        p_102103_.f_104205_ = 0.0f;
        p_102104_.f_104204_ = -(0.1f - f * 0.6f);
        p_102103_.f_104204_ = 0.1f - f * 0.6f;
        p_102104_.f_104203_ = f2 = isAggressive ? -MathHelper.modelDegrees(120.0f) : -MathHelper.modelDegrees(45.0f);
        p_102103_.f_104203_ = f2;
        p_102104_.f_104203_ += f * 1.2f - f1 * 0.4f;
        p_102103_.f_104203_ += f * 1.2f - f1 * 0.4f;
        AnimationUtils.m_102082_((ModelPart)p_102104_, (ModelPart)p_102103_, (float)p_102107_);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.haunt.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.haunt;
    }
}

