/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.layer.HierarchicalArmor;
import com.Polarice3.Goety.common.entities.ally.illager.AbstractIllagerServant;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.SpyglassItem;

public class IllagerServantModel<T extends LivingEntity>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel,
HierarchicalArmor {
    public final ModelPart root;
    public final ModelPart body;
    public final ModelPart clothes;
    public final ModelPart head;
    public final ModelPart hat;
    public final ModelPart collar;
    public final ModelPart arms;
    public final ModelPart RightArm;
    public final ModelPart LeftArm;
    public final ModelPart RightLeg;
    public final ModelPart LeftLeg;
    public HumanoidModel.ArmPose leftArmPose = HumanoidModel.ArmPose.EMPTY;
    public HumanoidModel.ArmPose rightArmPose = HumanoidModel.ArmPose.EMPTY;

    public IllagerServantModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.hat = this.head.m_171324_("hat");
        this.hat.f_104207_ = false;
        this.collar = this.head.m_171324_("collar");
        this.body = root.m_171324_("body");
        this.clothes = this.body.m_171324_("clothes");
        this.arms = root.m_171324_("arms");
        this.RightArm = root.m_171324_("right_arm");
        this.LeftArm = root.m_171324_("left_arm");
        this.LeftLeg = root.m_171324_("left_leg");
        this.RightLeg = root.m_171324_("right_leg");
    }

    public static MeshDefinition createMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition partdefinition1 = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition1.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.45f)), PartPose.f_171404_);
        partdefinition1.m_171599_("collar", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.45f)), PartPose.f_171404_);
        partdefinition1.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("clothes", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-4.0f, -24.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition partdefinition2 = partdefinition.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171481_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).m_171514_(40, 38).m_171481_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        partdefinition2.m_171599_("left_shoulder", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171480_().m_171481_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.f_171404_);
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        return meshdefinition;
    }

    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)IllagerServantModel.createMesh(), (int)64, (int)64);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        AbstractIllagerServant servant;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entityIn instanceof AbstractIllagerServant) {
            servant = (AbstractIllagerServant)entityIn;
            if (servant.cantDo > 0) {
                this.head.f_104205_ = 0.3f * Mth.m_14031_((float)(0.45f * ageInTicks));
                this.head.f_104203_ = 0.4f;
            } else {
                this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
                this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
            }
        } else {
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        }
        if (this.f_102609_) {
            this.RightArm.f_104203_ = -0.62831855f;
            this.RightArm.f_104204_ = 0.0f;
            this.RightArm.f_104205_ = 0.0f;
            this.LeftArm.f_104203_ = -0.62831855f;
            this.LeftArm.f_104204_ = 0.0f;
            this.LeftArm.f_104205_ = 0.0f;
            this.RightLeg.f_104203_ = -1.4137167f;
            this.RightLeg.f_104204_ = 0.31415927f;
            this.RightLeg.f_104205_ = 0.07853982f;
            this.LeftLeg.f_104203_ = -1.4137167f;
            this.LeftLeg.f_104204_ = -0.31415927f;
            this.LeftLeg.f_104205_ = -0.07853982f;
        } else {
            this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.RightArm.f_104204_ = 0.0f;
            this.RightArm.f_104205_ = 0.0f;
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.LeftArm.f_104204_ = 0.0f;
            this.LeftArm.f_104205_ = 0.0f;
            this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            this.RightLeg.f_104204_ = 0.0f;
            this.RightLeg.f_104205_ = 0.0f;
            this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
            this.LeftLeg.f_104204_ = 0.0f;
            this.LeftLeg.f_104205_ = 0.0f;
        }
        if (entityIn instanceof AbstractIllagerServant) {
            boolean flag;
            servant = (AbstractIllagerServant)entityIn;
            AbstractIllagerServant.IllagerServantArmPose armPose = servant.getArmPose();
            if (armPose == AbstractIllagerServant.IllagerServantArmPose.ATTACKING) {
                if (entityIn.m_21205_().m_41619_()) {
                    AnimationUtils.m_102102_((ModelPart)this.LeftArm, (ModelPart)this.RightArm, (boolean)true, (float)this.f_102608_, (float)ageInTicks);
                } else {
                    AnimationUtils.m_102091_((ModelPart)this.RightArm, (ModelPart)this.LeftArm, (Mob)servant, (float)this.f_102608_, (float)ageInTicks);
                }
            } else if (armPose == AbstractIllagerServant.IllagerServantArmPose.SPELLCASTING) {
                this.RightArm.f_104202_ = 0.0f;
                this.RightArm.f_104200_ = -5.0f;
                this.LeftArm.f_104202_ = 0.0f;
                this.LeftArm.f_104200_ = 5.0f;
                this.RightArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.LeftArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.RightArm.f_104205_ = 2.3561945f;
                this.LeftArm.f_104205_ = -2.3561945f;
                this.RightArm.f_104204_ = 0.0f;
                this.LeftArm.f_104204_ = 0.0f;
            } else if (armPose == AbstractIllagerServant.IllagerServantArmPose.BOW_AND_ARROW) {
                this.RightArm.f_104204_ = -0.1f + this.head.f_104204_;
                this.RightArm.f_104203_ = -1.5707964f + this.head.f_104203_;
                this.LeftArm.f_104203_ = -0.9424779f + this.head.f_104203_;
                this.LeftArm.f_104204_ = this.head.f_104204_ - 0.4f;
                this.LeftArm.f_104205_ = 1.5707964f;
            } else if (armPose == AbstractIllagerServant.IllagerServantArmPose.CROSSBOW_HOLD) {
                AnimationUtils.m_102097_((ModelPart)this.RightArm, (ModelPart)this.LeftArm, (ModelPart)this.head, (boolean)true);
            } else if (armPose == AbstractIllagerServant.IllagerServantArmPose.CROSSBOW_CHARGE) {
                AnimationUtils.m_102086_((ModelPart)this.RightArm, (ModelPart)this.LeftArm, entityIn, (boolean)true);
            } else if (armPose == AbstractIllagerServant.IllagerServantArmPose.CELEBRATING) {
                this.RightArm.f_104202_ = 0.0f;
                this.RightArm.f_104200_ = -5.0f;
                this.RightArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
                this.RightArm.f_104205_ = 2.3561945f;
                this.RightArm.f_104204_ = 0.0f;
                this.LeftArm.f_104202_ = 0.0f;
                this.LeftArm.f_104200_ = 5.0f;
                this.LeftArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
                this.LeftArm.f_104205_ = -2.3561945f;
                this.LeftArm.f_104204_ = 0.0f;
            } else if (armPose == AbstractIllagerServant.IllagerServantArmPose.CROSSED && this.arms.f_104207_) {
                this.RightArm.f_104203_ = -0.75f;
                this.RightArm.f_104205_ = 0.0f;
                this.RightArm.f_104204_ = 0.0f;
                this.LeftArm.f_104203_ = -0.75f;
                this.LeftArm.f_104205_ = 0.0f;
                this.LeftArm.f_104204_ = 0.0f;
            }
            this.arms.f_104207_ = flag = armPose == AbstractIllagerServant.IllagerServantArmPose.CROSSED;
            this.LeftArm.f_104207_ = !flag;
            boolean bl = this.RightArm.f_104207_ = !flag;
            if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
                this.useItemRight(InteractionHand.MAIN_HAND, entityIn);
                this.useItemLeft(InteractionHand.OFF_HAND, entityIn);
            } else if (entityIn.m_5737_() == HumanoidArm.LEFT) {
                this.useItemLeft(InteractionHand.MAIN_HAND, entityIn);
                this.useItemRight(InteractionHand.OFF_HAND, entityIn);
            }
        }
        boolean flag2 = entityIn.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ArmorItem || entityIn.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ArmorItem;
        this.clothes.f_104207_ = !flag2;
    }

    public void m_7695_(PoseStack p_102034_, VertexConsumer p_102035_, int p_102036_, int p_102037_, float p_102038_, float p_102039_, float p_102040_, float p_102041_) {
        if (this.f_102610_) {
            p_102034_.m_85836_();
            float f = 0.75f;
            p_102034_.m_85841_(f, f, f);
            p_102034_.m_252880_(0.0f, 1.0f, 0.0f);
            this.headParts().forEach(p_102081_ -> p_102081_.m_104306_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_));
            p_102034_.m_85849_();
            p_102034_.m_85836_();
            float f1 = 0.5f;
            p_102034_.m_85841_(f1, f1, f1);
            p_102034_.m_252880_(0.0f, 1.5f, 0.0f);
            this.bodyParts().forEach(p_102071_ -> p_102071_.m_104306_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_));
            p_102034_.m_85849_();
        } else {
            super.m_7695_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_);
        }
    }

    public void copyPropertiesTo(IllagerServantModel<T> p_102873_) {
        super.m_102624_(p_102873_);
        p_102873_.leftArmPose = this.leftArmPose;
        p_102873_.rightArmPose = this.rightArmPose;
    }

    public void useItemRight(InteractionHand hand, T entityIn) {
        if (entityIn.m_7655_() == hand) {
            if (entityIn.m_21211_().m_41720_() instanceof SpyglassItem) {
                this.RightArm.f_104203_ = Mth.m_14036_((float)(this.head.f_104203_ - 1.9198622f - (entityIn.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.RightArm.f_104204_ = this.head.f_104204_ - 0.2617994f;
            } else if (entityIn.m_21211_().m_41720_() instanceof InstrumentItem) {
                this.RightArm.f_104203_ = Mth.m_14036_((float)this.head.f_104203_, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.RightArm.f_104204_ = this.head.f_104204_ - 0.5235988f;
            }
        }
    }

    public void useItemLeft(InteractionHand hand, T entityIn) {
        if (entityIn.m_7655_() == hand) {
            if (entityIn.m_21211_().m_41720_() instanceof SpyglassItem) {
                this.LeftArm.f_104203_ = Mth.m_14036_((float)(this.head.f_104203_ - 1.9198622f - (entityIn.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.LeftArm.f_104204_ = this.head.f_104204_ + 0.2617994f;
            } else if (entityIn.m_21211_().m_41720_() instanceof InstrumentItem) {
                this.LeftArm.f_104203_ = Mth.m_14036_((float)this.head.f_104203_, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.LeftArm.f_104204_ = this.head.f_104204_ + 0.5235988f;
            }
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.LeftArm : this.RightArm;
    }

    public ModelPart getHat() {
        return this.hat;
    }

    public ModelPart getCollar() {
        return this.collar;
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.RightArm, (Object)this.LeftArm, (Object)this.arms, (Object)this.RightLeg, (Object)this.LeftLeg);
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.getArm(arm).m_104299_(poseStack);
    }

    @Override
    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
    }

    @Override
    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    @Override
    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        modelPart.m_104299_(poseStack);
    }

    @Override
    public void translateToArms(ModelPart modelPart, PoseStack poseStack) {
        modelPart.m_104299_(poseStack);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    @Override
    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.RightArm);
    }

    @Override
    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.LeftArm);
    }

    @Override
    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.RightLeg);
    }

    @Override
    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.LeftLeg);
    }

    @Override
    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    @Override
    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }
}

